/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ModellingApp;
import buoy.event.KeyPressedEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.BOutline;
import buoy.widget.BPopupMenu;
import buoy.widget.BScrollPane;
import buoy.widget.MenuWidget;
import buoy.widget.TextWidget;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComponent;

public class UIUtilities {
    public static void centerWindow(WindowWidget win) {
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle d2 = win.getBounds();
        int x = (d1.width - d2.width) / 2;
        int y = (d1.height - d2.height) / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        win.setBounds(new Rectangle(x, y, d2.width, d2.height));
    }

    public static void centerDialog(BDialog dlg, WindowWidget parent) {
        Rectangle r1 = parent.getBounds();
        Rectangle r2 = dlg.getBounds();
        int x = r1.x + (r1.width - r2.width) / 2;
        int y = r1.y + 20;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        dlg.setBounds(new Rectangle(x, y, r2.width, r2.height));
    }

    public static void applyDefaultFont(Widget w) {
        if (ModellingApp.defaultFont == null) {
            return;
        }
        w.setFont(ModellingApp.defaultFont);
        if (w instanceof WidgetContainer && !(w instanceof BMenuBar)) {
            Iterator children = ((WidgetContainer)w).getChildren();
            while (children.hasNext()) {
                UIUtilities.applyDefaultFont((Widget)children.next());
            }
        }
    }

    public static void applyDefaultBackground(Widget w) {
        UIUtilities.applyBackground(w, ModellingApp.APP_BACKGROUND_COLOR);
    }

    public static void applyBackground(Widget w, Color color) {
        if (w instanceof WidgetContainer) {
            w.setBackground(color);
            Iterator children = ((WidgetContainer)w).getChildren();
            while (children.hasNext()) {
                UIUtilities.applyBackground((Widget)children.next(), color);
            }
        } else if (w instanceof BLabel) {
            w.setBackground(color);
        } else if (w instanceof BButton || w instanceof BComboBox) {
            ((JComponent)w.getComponent()).setOpaque(false);
        }
    }

    public static WidgetContainer createScrollingList(BList list) {
        BScrollPane scroll = new BScrollPane(list, BScrollPane.SCROLLBAR_AS_NEEDED, BScrollPane.SCROLLBAR_ALWAYS);
        scroll.setBackground(list.getBackground());
        scroll.setForceWidth(true);
        return BOutline.createBevelBorder(scroll, false);
    }

    public static WindowWidget findWindow(Widget w) {
        if (w instanceof WindowWidget) {
            return (WindowWidget)w;
        }
        if (w == null) {
            return null;
        }
        return UIUtilities.findWindow(w.getParent());
    }

    public static BFrame findFrame(Widget w) {
        if (w instanceof BFrame) {
            return (BFrame)w;
        }
        if (w == null) {
            return null;
        }
        return UIUtilities.findFrame(w.getParent());
    }

    public static String[] breakString(String s) {
        int lines = s.length() / 60 + 1;
        if (lines < 2) {
            return new String[]{s};
        }
        int lineLength = s.length() / lines;
        Vector<String> line = new Vector<String>();
        int index = 0;
        while (index + lineLength < s.length()) {
            int next = s.indexOf(32, index + lineLength);
            if (next == -1) {
                next = s.length();
            }
            line.addElement(s.substring(index, next).trim());
            index = next;
        }
        if (index < s.length()) {
            line.addElement(s.substring(index).trim());
        }
        Object[] result = new String[line.size()];
        line.copyInto(result);
        return result;
    }

    private static void getMenuItemList(BMenu menu, Vector result) {
        int l = menu.getChildCount();
        for (int i = 0; i < l; ++i) {
            MenuWidget m = menu.getChild(i);
            if (m instanceof BMenu) {
                UIUtilities.getMenuItemList((BMenu)m, result);
                continue;
            }
            result.add(m);
        }
    }

    public static MenuWidget[] getMenuItemList(BMenuBar menubar) {
        if (menubar == null) {
            return new MenuWidget[0];
        }
        Vector result = new Vector();
        int l = menubar.getChildCount();
        for (int i = 0; i < l; ++i) {
            BMenu m = menubar.getChild(i);
            UIUtilities.getMenuItemList(m, result);
        }
        return result.toArray(new MenuWidget[0]);
    }

    public static MenuWidget[] getMenuItemList(BMenu menu) {
        Vector result = new Vector();
        UIUtilities.getMenuItemList(menu, result);
        return result.toArray(new MenuWidget[0]);
    }

    public static MenuWidget[] getMenuItemList(BPopupMenu menu) {
        if (menu == null) {
            return new MenuWidget[0];
        }
        Vector<MenuWidget> result = new Vector<MenuWidget>();
        int l = menu.getChildCount();
        for (int i = 0; i < l; ++i) {
            MenuWidget m = menu.getChild(i);
            if (m instanceof BMenu) {
                UIUtilities.getMenuItemList((BMenu)m, result);
                continue;
            }
            result.add(m);
        }
        return result.toArray(new MenuWidget[0]);
    }

    protected static void recursivelyAddKeyPressedListeners(Widget w, Object listener) {
        if (!(w instanceof TextWidget)) {
            w.addEventLink(KeyPressedEvent.class, listener, "keyPressed");
        }
        if (w instanceof WidgetContainer) {
            Iterator children = ((WidgetContainer)w).getChildren();
            while (children.hasNext()) {
                UIUtilities.recursivelyAddKeyPressedListeners((Widget)children.next(), listener);
            }
        }
    }

    public static void recursivelyAddKeyPressedListeners(Widget w) {
        UIUtilities.recursivelyAddKeyPressedListeners(w, w);
    }
}

