/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ModellingApp;
import artofillusion.UndoRecord;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.PopupMenuManager;
import artofillusion.ui.TreeElement;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.WidgetEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.CustomWidget;
import buoy.widget.Widget;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

public class TreeList
extends CustomWidget {
    private EditingWindow window;
    private Vector elements;
    private Vector showing;
    private Vector indent;
    private Vector selected;
    private int yoffset;
    private int rowHeight;
    private int dragStart;
    private int lastDrag;
    private int lastIndent;
    private int maxRowWidth;
    private boolean updateDisabled;
    private boolean moving;
    private boolean[] origSelected;
    private boolean insertAbove;
    private boolean okToInsert;
    private boolean allowMultiple;
    private PopupMenuManager popupManager;
    protected UndoRecord undo;
    private static final Polygon openHandle = new Polygon(new int[]{-4, 4, 0}, new int[]{-2, -2, 2}, 3);
    private static final Polygon closedHandle = new Polygon(new int[]{-2, 2, -2}, new int[]{-4, 0, 4}, 3);
    private static final Polygon insertHandle = new Polygon(new int[]{-5, -2, -5}, new int[]{-3, 0, 3}, 3);
    private static final int INDENT_WIDTH = 10;
    private static final int HANDLE_WIDTH = 4;
    private static final int HANDLE_HEIGHT = 8;
    private static final int INSERT_WIDTH = 3;
    private static final int INSERT_HEIGHT = 6;

    public TreeList(EditingWindow win) {
        this.window = win;
        this.elements = new Vector();
        this.showing = new Vector();
        this.indent = new Vector();
        this.selected = new Vector();
        this.origSelected = new boolean[0];
        this.allowMultiple = true;
        Font font = this.getFont();
        if (font == null) {
            font = ModellingApp.defaultFont;
        }
        if (font != null) {
            FontMetrics fm = this.getComponent().getFontMetrics(font);
            this.rowHeight = Math.max(fm.getMaxAscent() + fm.getMaxDescent(), 8) + 3;
        } else {
            this.rowHeight = 15;
        }
        this.buildState();
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
    }

    public Dimension getPreferredSize() {
        Dimension superPref = super.getPreferredSize();
        return new Dimension(Math.max(superPref.width, this.maxRowWidth), Math.max(superPref.height, this.rowHeight * this.showing.size()));
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.maxRowWidth, this.rowHeight * this.showing.size());
    }

    public void setAllowMultiple(boolean allow) {
        this.allowMultiple = allow;
    }

    public void setUpdateEnabled(boolean enabled) {
        boolean bl = this.updateDisabled = !enabled;
        if (enabled) {
            this.buildState();
            this.repaint();
        }
    }

    public void addElement(TreeElement el) {
        this.elements.addElement(el);
        this.buildState();
        if (!this.updateDisabled) {
            this.repaint();
        }
    }

    public void addElement(TreeElement el, int position) {
        this.elements.insertElementAt(el, position);
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    public TreeElement findElement(Object obj) {
        for (int i = 0; i < this.elements.size(); ++i) {
            TreeElement el = (TreeElement)this.elements.elementAt(i);
            if (el.getObject().equals(obj)) {
                return el;
            }
            TreeElement subElement = this.findElement(obj, el);
            if (subElement == null) continue;
            return subElement;
        }
        return null;
    }

    private TreeElement findElement(Object obj, TreeElement parent) {
        for (int i = 0; i < parent.getNumChildren(); ++i) {
            TreeElement el = parent.getChild(i);
            if (el.getObject().equals(obj)) {
                return el;
            }
            TreeElement subElement = this.findElement(obj, el);
            if (subElement == null) continue;
            return subElement;
        }
        return null;
    }

    public void removeObject(Object obj) {
        for (int i = this.elements.size() - 1; i >= 0; --i) {
            TreeElement el = (TreeElement)this.elements.elementAt(i);
            if (el.getObject() == obj) {
                this.elements.removeElementAt(i);
                continue;
            }
            el.removeChild(obj);
        }
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    public void updateTree() {
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    public void removeAllElements() {
        this.elements.removeAllElements();
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    public TreeElement[] getElements() {
        Vector<TreeElement> v = new Vector<TreeElement>();
        for (int i = 0; i < this.elements.size(); ++i) {
            TreeElement el = (TreeElement)this.elements.elementAt(i);
            v.addElement(el);
            this.addChildrenToVector(el, v);
        }
        TreeElement[] allEl = new TreeElement[v.size()];
        for (int i = 0; i < allEl.length; ++i) {
            allEl[i] = (TreeElement)v.elementAt(i);
        }
        return allEl;
    }

    private void addChildrenToVector(TreeElement el, Vector v) {
        for (int i = 0; i < el.getNumChildren(); ++i) {
            TreeElement child = el.getChild(i);
            v.addElement(child);
            this.addChildrenToVector(child, v);
        }
    }

    public Object[] getSelectedObjects() {
        Object[] sel = new Object[this.selected.size()];
        for (int i = 0; i < sel.length; ++i) {
            sel[i] = ((TreeElement)this.selected.elementAt(i)).getObject();
        }
        return sel;
    }

    public TreeElement[] getSelectedElements() {
        return this.selected.toArray(new TreeElement[this.selected.size()]);
    }

    public void deselectAll() {
        for (int i = 0; i < this.elements.size(); ++i) {
            this.deselectRecursively((TreeElement)this.elements.elementAt(i));
        }
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    private void deselectRecursively(TreeElement el) {
        el.setSelected(false);
        for (int i = 0; i < el.getNumChildren(); ++i) {
            this.deselectRecursively(el.getChild(i));
        }
    }

    public Object[] getVisibleObjects() {
        Object[] vis = new Object[this.showing.size()];
        for (int i = 0; i < vis.length; ++i) {
            vis[i] = ((TreeElement)this.showing.elementAt(i)).getObject();
        }
        return vis;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setSelected(Object obj, boolean selected) {
        TreeElement el = obj instanceof TreeElement ? (TreeElement)obj : this.findElement(obj);
        boolean wasDisabled = this.updateDisabled;
        this.updateDisabled = true;
        if (el != null) {
            el.setSelected(selected);
            for (int i = 0; i < el.getNumChildren(); ++i) {
                TreeElement child = el.getChild(i);
                if (!child.selectWithParent()) continue;
                this.setSelected(child, selected);
            }
        }
        this.updateDisabled = wasDisabled;
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    public void expandToShowObject(Object obj) {
        TreeElement el;
        TreeElement treeElement = el = obj instanceof TreeElement ? (TreeElement)obj : this.findElement(obj);
        if (el == null) {
            return;
        }
        while ((el = el.getParent()) != null) {
            el.setExpanded(true);
        }
        if (!this.updateDisabled) {
            this.buildState();
            this.repaint();
        }
    }

    private void recordUndo() {
        this.undo = new UndoRecord(this.window, false);
    }

    private UndoRecord finishRecording() {
        UndoRecord rec = this.undo;
        this.undo = null;
        return rec;
    }

    private void buildState() {
        if (this.updateDisabled) {
            return;
        }
        this.showing.removeAllElements();
        this.indent.removeAllElements();
        this.selected.removeAllElements();
        for (int i = 0; i < this.elements.size(); ++i) {
            TreeElement el = (TreeElement)this.elements.elementAt(i);
            this.showing.addElement(el);
            this.indent.addElement(new Integer(0));
            if (el.isSelected()) {
                this.selected.addElement(el);
            }
            this.addChildrenToState(el, 1, el.isExpanded());
        }
        if (this.origSelected.length != this.showing.size()) {
            this.origSelected = new boolean[this.showing.size()];
        }
        this.invalidateSize();
        if (this.getComponent().isDisplayable()) {
            this.getParent().layoutChildren();
        }
    }

    private void addChildrenToState(TreeElement el, int currentIndent, boolean expanded) {
        for (int i = 0; i < el.getNumChildren(); ++i) {
            TreeElement child = el.getChild(i);
            if (expanded) {
                this.showing.addElement(child);
                this.indent.addElement(new Integer(currentIndent));
            }
            if (child.isSelected()) {
                this.selected.addElement(child);
            }
            this.addChildrenToState(child, currentIndent + 1, expanded & child.isExpanded());
        }
    }

    public void setYOffset(int offset) {
        this.yoffset = offset;
    }

    private void paint(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        Rectangle dim = this.getBounds();
        int y = this.yoffset;
        this.rowHeight = Math.max(fm.getMaxAscent() + fm.getMaxDescent(), 8) + 3;
        this.maxRowWidth = 0;
        for (int i = 0; i < this.showing.size(); ++i) {
            TreeElement el = (TreeElement)this.showing.elementAt(i);
            int x = (Integer)this.indent.elementAt(i) * 10;
            if (el.getNumChildren() > 0) {
                g.setColor(Color.black);
                if (el.isExpanded()) {
                    openHandle.translate(x + 5, y + this.rowHeight / 2);
                    g.drawPolygon(openHandle);
                    openHandle.translate(-x - 5, -y - this.rowHeight / 2);
                } else {
                    closedHandle.translate(x + 5, y + this.rowHeight / 2);
                    g.drawPolygon(closedHandle);
                    closedHandle.translate(-x - 5, -y - this.rowHeight / 2);
                }
            }
            x += 10;
            if (el.isSelected()) {
                g.setColor(el.isGray() ? Color.gray : Color.black);
                g.fillRect(x, y, dim.width - x, this.rowHeight - 3);
                g.setColor(Color.white);
                g.drawString(el.getLabel(), x + 1, y + fm.getMaxAscent());
            } else {
                g.setColor(el.isGray() ? Color.gray : Color.black);
                g.drawString(el.getLabel(), x + 1, y + fm.getMaxAscent());
            }
            y += this.rowHeight;
            this.maxRowWidth = Math.max(this.maxRowWidth, fm.stringWidth(el.getLabel()) + x + 1);
        }
    }

    private void mousePressed(MousePressedEvent ev) {
        Point pos = ev.getPoint();
        pos.y -= this.yoffset;
        int row = pos.y / this.rowHeight;
        this.moving = false;
        if (row >= this.showing.size()) {
            this.deselectAll();
            this.buildState();
            this.dispatchEvent(new SelectionChangedEvent(this));
            return;
        }
        this.dragStart = this.lastDrag = row;
        TreeElement el = (TreeElement)this.showing.elementAt(row);
        int i = pos.x / 10;
        int ind = (Integer)this.indent.elementAt(row);
        if (i == ind && el.getNumChildren() > 0) {
            el.setExpanded(!el.isExpanded());
            this.buildState();
            this.repaint();
            this.dispatchEvent(new ElementExpandedEvent(el));
            this.showPopupIfNeeded(ev);
            return;
        }
        if (i < ind || el.getParent() != null && el.selectWithParent() && el.getParent().isSelected()) {
            this.showPopupIfNeeded(ev);
            return;
        }
        this.moving = !ev.isShiftDown();
        this.okToInsert = false;
        if (this.allowMultiple && ev.isShiftDown()) {
            this.setSelected(el, !el.isSelected());
            this.dispatchEvent(new SelectionChangedEvent(this));
        } else if (!el.isSelected()) {
            this.deselectAll();
            this.setSelected(el, true);
            this.dispatchEvent(new SelectionChangedEvent(this));
        }
        for (i = 0; i < this.origSelected.length; ++i) {
            el = (TreeElement)this.showing.elementAt(i);
            this.origSelected[i] = el.isSelected();
        }
        this.buildState();
        this.repaint();
        this.showPopupIfNeeded(ev);
    }

    private void mouseDragged(MouseDraggedEvent ev) {
        Point pos = ev.getPoint();
        pos.y -= this.yoffset;
        int row = pos.y / this.rowHeight;
        if (this.moving) {
            TreeElement el;
            boolean above;
            if (this.selected.size() == 0) {
                return;
            }
            boolean bl = above = pos.y - row * this.rowHeight < this.rowHeight / 2;
            if (row >= this.showing.size()) {
                row = this.showing.size();
                above = true;
            }
            if (row < 0) {
                row = 0;
                above = true;
            }
            if (row == this.lastDrag && above == this.insertAbove) {
                return;
            }
            Graphics g = this.getComponent().getGraphics();
            if (this.okToInsert) {
                g.setColor(this.getBackground());
                this.drawInsertionPoint(g, this.insertAbove ? this.lastDrag : this.lastDrag + 1, this.lastIndent);
            }
            TreeElement parent = null;
            if (row < this.showing.size()) {
                parent = el = (TreeElement)this.showing.elementAt(row);
                this.lastIndent = (Integer)this.indent.elementAt(row);
                if (above) {
                    parent = el.getParent();
                    this.okToInsert = this.dragTargetOk(parent);
                } else {
                    this.okToInsert = this.dragTargetOk(parent);
                    if (this.okToInsert) {
                        ++this.lastIndent;
                    } else {
                        parent = el.getParent();
                        this.okToInsert = this.dragTargetOk(parent);
                    }
                }
            } else {
                this.lastIndent = 0;
            }
            this.okToInsert = true;
            for (int i = 0; this.okToInsert && i < this.selected.size(); ++i) {
                el = (TreeElement)this.selected.elementAt(i);
                if (el.getParent() != null && el.getParent().isSelected()) continue;
                this.okToInsert &= el.canAcceptAsParent(parent);
            }
            if (this.okToInsert) {
                g.setColor(Color.black);
                this.drawInsertionPoint(g, above ? row : row + 1, this.lastIndent);
            }
            g.dispose();
            this.lastDrag = row;
            this.insertAbove = above;
            return;
        }
        if (row == this.lastDrag || !this.allowMultiple) {
            return;
        }
        this.lastDrag = row;
        int min = Math.max(Math.min(row, this.dragStart), 0);
        int max = Math.min(Math.max(row, this.dragStart), this.showing.size() - 1);
        this.updateDisabled = true;
        for (int i = 0; i < this.showing.size(); ++i) {
            boolean sel;
            TreeElement el = (TreeElement)this.showing.elementAt(i);
            boolean bl = sel = this.origSelected[i] || i >= min && i <= max || el.getParent() != null && el.getParent().isSelected();
            if (el.isSelected() == sel) continue;
            this.setSelected(el, sel);
        }
        this.updateDisabled = false;
        this.buildState();
        this.repaint();
    }

    private void mouseReleased(MouseReleasedEvent ev) {
        if (this.moving) {
            if (this.okToInsert) {
                int i;
                TreeElement parent;
                this.recordUndo();
                this.updateDisabled = true;
                TreeElement el = null;
                int position = 0;
                if (this.lastDrag < this.showing.size()) {
                    parent = el = (TreeElement)this.showing.elementAt(this.lastDrag);
                    if (this.insertAbove || !this.dragTargetOk(el)) {
                        parent = el.getParent();
                        if (parent == null) {
                            position = 0;
                            while (this.elements.elementAt(position) != el) {
                                ++position;
                            }
                        } else {
                            position = 0;
                            while (parent.getChild(position) != el) {
                                ++position;
                            }
                        }
                        if (!this.insertAbove) {
                            ++position;
                        }
                    } else {
                        position = 0;
                    }
                } else {
                    parent = null;
                    position = this.elements.size();
                }
                for (i = 0; i < this.selected.size(); ++i) {
                    int j;
                    el = (TreeElement)this.selected.elementAt(i);
                    if (el.getParent() != null && el.getParent().isSelected()) {
                        this.selected.removeElementAt(i);
                        --i;
                        continue;
                    }
                    if (el.getParent() == parent && ((j = this.showing.indexOf(el)) < this.lastDrag || !this.insertAbove && j == this.lastDrag)) {
                        --position;
                    }
                    this.removeObject(el.getObject());
                }
                if (position < 0) {
                    position = 0;
                }
                if (parent == null) {
                    for (i = 0; i < this.selected.size(); ++i) {
                        el = (TreeElement)this.selected.elementAt(i);
                        if (el.getParent() != null && el.getParent().isSelected()) continue;
                        this.addElement(el, position++);
                    }
                } else {
                    for (i = 0; i < this.selected.size(); ++i) {
                        el = (TreeElement)this.selected.elementAt(i);
                        if (el.getParent() != null && el.getParent().isSelected()) continue;
                        parent.addChild(el, position++);
                    }
                }
                this.updateDisabled = false;
                this.buildState();
                this.window.setUndoRecord(this.finishRecording());
                this.repaint();
                this.dispatchEvent(new ElementMovedEvent(el));
            }
        } else if (this.lastDrag != this.dragStart) {
            this.dispatchEvent(new SelectionChangedEvent(this));
        }
        Point pos = ev.getPoint();
        this.showPopupIfNeeded(ev);
    }

    private boolean dragTargetOk(TreeElement parent) {
        for (int i = 0; i < this.selected.size(); ++i) {
            TreeElement el = (TreeElement)this.selected.elementAt(i);
            if (el.getParent() != null && el.getParent().isSelected() || el.canAcceptAsParent(parent)) continue;
            return false;
        }
        return true;
    }

    private void mouseClicked(MouseClickedEvent ev) {
        if (ev.getClickCount() != 2) {
            return;
        }
        Point pos = ev.getPoint();
        pos.y -= this.yoffset;
        int row = pos.y / this.rowHeight;
        int i = pos.x / 10;
        if (row >= this.showing.size()) {
            return;
        }
        int ind = (Integer)this.indent.elementAt(row);
        TreeElement el = (TreeElement)this.showing.elementAt(row);
        if (i < ind) {
            return;
        }
        this.dispatchEvent(new ElementDoubleClickedEvent(el));
    }

    private void drawInsertionPoint(Graphics g, int pos, int indent) {
        int x = (indent + 1) * 10;
        int y = pos * this.rowHeight - 2 + this.yoffset;
        Rectangle dim = this.getBounds();
        insertHandle.translate(x, y);
        g.fillPolygon(insertHandle);
        insertHandle.translate(-x, -y);
        g.drawLine(x - 2, y, dim.width, y);
    }

    public void setPopupMenuManager(PopupMenuManager manager) {
        this.popupManager = manager;
    }

    private void showPopupIfNeeded(WidgetMouseEvent ev) {
        if (!ev.isPopupTrigger() || this.popupManager == null) {
            return;
        }
        this.repaint();
        Point pos = ev.getPoint();
        this.popupManager.showPopupMenu(this, pos.x, pos.y);
    }

    public class ElementDoubleClickedEvent
    extends TreeElementEvent {
        private ElementDoubleClickedEvent(TreeElement el) {
            super(el);
        }
    }

    public class ElementExpandedEvent
    extends TreeElementEvent {
        private ElementExpandedEvent(TreeElement el) {
            super(el);
        }
    }

    public class ElementMovedEvent
    extends TreeElementEvent {
        private ElementMovedEvent(TreeElement el) {
            super(el);
        }
    }

    public class TreeElementEvent
    implements WidgetEvent {
        TreeElement elem;

        private TreeElementEvent(TreeElement el) {
            this.elem = el;
        }

        public TreeElement getElement() {
            return this.elem;
        }

        public Widget getWidget() {
            return TreeList.this;
        }
    }
}

