/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import buoy.event.CommandEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBoxMenuItem;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.Shortcut;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Translate {
    private static Locale locale = Locale.getDefault();
    private static ResourceBundle resources;

    public static void setLocale(Locale l) {
        locale = l;
        resources = ResourceBundle.getBundle("artofillusion", locale);
    }

    public static Locale getLocale() {
        return locale;
    }

    public static Locale[] getAvailableLocales() {
        return new Locale[]{new Locale("da", "DA"), Locale.US, Locale.FRENCH, Locale.GERMAN, Locale.ITALIAN, Locale.JAPANESE, new Locale("pt", "BR"), new Locale("es", "ES")};
    }

    public static BMenu menu(String name) {
        try {
            return new BMenu(resources.getString("menu." + name));
        }
        catch (MissingResourceException ex) {
            return new BMenu(name);
        }
    }

    public static Shortcut getShortcut(String name) {
        try {
            String shortcut = resources.getString("menu." + name + ".shortcut");
            if (shortcut.length() > 1 && shortcut.charAt(0) == '^') {
                return new Shortcut(shortcut.charAt(1), Shortcut.DEFAULT_MASK | 1);
            }
            if (shortcut.length() > 0) {
                return new Shortcut(shortcut.charAt(0));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static BMenuItem menuItem(String name, Object listener, String method) {
        return Translate.menuItem(name, listener, method, Translate.getShortcut(name));
    }

    public static BMenuItem menuItem(String name, Object listener, String method, Shortcut shortcut) {
        String command = name;
        try {
            command = resources.getString("menu." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BMenuItem item = new BMenuItem(command);
        item.setActionCommand(name);
        item.setName(name);
        if (shortcut != null) {
            item.setShortcut(shortcut);
        }
        if (listener != null) {
            item.addEventLink(CommandEvent.class, listener, method);
        }
        return item;
    }

    public static BCheckBoxMenuItem checkboxMenuItem(String name, Object listener, String method, boolean state) {
        String command = name;
        try {
            command = resources.getString("menu." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        BCheckBoxMenuItem item = new BCheckBoxMenuItem(command, state);
        item.setActionCommand(name);
        item.setName(name);
        try {
            Shortcut shortcut = Translate.getShortcut(name);
            if (shortcut != null) {
                item.setShortcut(shortcut);
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (listener != null) {
            item.addEventLink(CommandEvent.class, listener, method);
        }
        return item;
    }

    public static BButton button(String name, Object listener, String method) {
        return Translate.button(name, null, listener, method);
    }

    public static BButton button(String name, String suffix, Object listener, String method) {
        String command = name;
        try {
            command = resources.getString("button." + name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        if (suffix != null) {
            command = command + suffix;
        }
        BButton b = new BButton(command);
        b.setActionCommand(name);
        if (listener != null) {
            b.addEventLink(CommandEvent.class, listener, method);
        }
        return b;
    }

    public static BLabel label(String name) {
        return Translate.label(name, null);
    }

    public static BLabel label(String name, String suffix) {
        try {
            name = resources.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (suffix != null) {
            name = name + suffix;
        }
        return new BLabel(name);
    }

    public static String text(String name) {
        try {
            return resources.getString(name);
        }
        catch (MissingResourceException ex) {
            return name;
        }
    }

    public static String text(String name, Object arg1) {
        String pattern = name;
        try {
            pattern = resources.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return MessageFormat.format(pattern, arg1);
    }

    public static String text(String name, Object arg1, Object arg2) {
        String pattern = name;
        try {
            pattern = resources.getString(name);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return MessageFormat.format(pattern, arg1, arg2);
    }

    public static String text(String name, Object[] args) {
        String pattern = name;
        try {
            pattern = resources.getString(name);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return MessageFormat.format(pattern, args);
    }
}

