/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ModellingApp;
import artofillusion.ui.EditingTool;
import buoy.event.KeyPressedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ToolTipEvent;
import buoy.widget.BToolTip;
import buoy.widget.CustomWidget;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;

public class ToolPalette
extends CustomWidget {
    private int width;
    private int height;
    private int numTools;
    private int selected;
    private EditingTool[] tool;
    private Dimension maxsize;

    public ToolPalette(int w, int h) {
        this.width = w;
        this.height = h;
        this.tool = new EditingTool[w * h];
        this.numTools = 0;
        this.selected = 0;
        this.maxsize = new Dimension(0, 0);
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseClickedEvent.class, (Object)this, "mouseClicked");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
        this.addEventLink(ToolTipEvent.class, (Object)this, "showToolTip");
        this.setBackground(ModellingApp.APP_BACKGROUND_COLOR);
    }

    public void addTool(EditingTool t) {
        this.tool[this.numTools++] = t;
        int w = t.getIcon().getWidth(null);
        int h = t.getIcon().getHeight(null);
        if (w > this.maxsize.width) {
            this.maxsize.width = w;
        }
        if (h > this.maxsize.height) {
            this.maxsize.height = h;
        }
        if (this.numTools == 1) {
            t.activate();
        }
    }

    public int getSelection() {
        return this.selected;
    }

    public EditingTool getToolByIndex(int i) {
        return this.tool[i];
    }

    private void paint(RepaintEvent ev) {
        Graphics2D g = ev.getGraphics();
        for (int i = 0; i < this.numTools; ++i) {
            if (i == this.selected) {
                g.drawImage(this.tool[i].getSelectedIcon(), i % this.width * this.maxsize.width, i / this.width * this.maxsize.height, null);
                continue;
            }
            g.drawImage(this.tool[i].getIcon(), i % this.width * this.maxsize.width, i / this.width * this.maxsize.height, null);
        }
        g.drawLine(0, 0, this.width * this.maxsize.width, 0);
        g.drawLine(0, this.height * this.maxsize.height, this.width * this.maxsize.width, this.height * this.maxsize.height);
    }

    private void showToolTip(ToolTipEvent ev) {
        int i = this.findClickedTool(ev.getPoint());
        if (i < this.numTools) {
            String text = this.tool[i].getToolTipText();
            if (text == null) {
                BToolTip.hide();
            } else {
                new BToolTip(text).processEvent(ev);
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width * this.maxsize.width, this.height * this.maxsize.height + 2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private void mousePressed(MousePressedEvent e) {
        int i = this.findClickedTool(e.getPoint());
        if (i < this.numTools && i != this.selected) {
            if (this.selected < this.tool.length) {
                this.tool[this.selected].deactivate();
            }
            this.selected = i;
            this.repaint();
            this.tool[i].activate();
        }
    }

    private void mouseClicked(MouseClickedEvent e) {
        int i = this.findClickedTool(e.getPoint());
        if (i < this.numTools && e.getClickCount() == 2) {
            this.tool[i].iconDoubleClicked();
        }
    }

    private int findClickedTool(Point p) {
        return p.x / this.maxsize.width + (p.y - 1) / this.maxsize.height * this.width;
    }

    public void selectTool(EditingTool which) {
        for (int i = 0; i < this.numTools; ++i) {
            if (this.tool[i] != which) continue;
            this.tool[this.selected].deactivate();
            this.selected = i;
            this.repaint();
            this.tool[i].activate();
        }
    }

    public void keyPressed(KeyPressedEvent ev) {
        int newtool;
        int code = ev.getKeyCode();
        if (code == 37) {
            newtool = this.selected - 1;
        } else if (code == 39) {
            newtool = this.selected + 1;
        } else if (code == 38) {
            newtool = this.selected - this.width;
        } else if (code == 40) {
            newtool = this.selected + this.width;
        } else {
            return;
        }
        if (newtool < 0) {
            newtool += this.numTools;
        }
        if (newtool >= this.numTools) {
            newtool -= this.numTools;
        }
        this.tool[this.selected].deactivate();
        this.selected = newtool;
        this.repaint();
        this.tool[this.selected].activate();
    }
}

