/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.GenericTreeElement;
import artofillusion.ui.MenuDescription;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import java.util.Vector;

public class MenuTreeElement
extends GenericTreeElement {
    boolean isMenu;
    boolean isRoot;

    public MenuTreeElement(MenuDescription desc, TreeList tree, TreeElement[] children) {
        super(desc.getPresentableString(), desc, null, tree, MenuTreeElement.arrayToVector(children));
        this.isMenu = children != null;
        this.isRoot = false;
    }

    public void setAsRoot() {
        this.isRoot = true;
    }

    public void rereadLabel() {
        this.setLabel(this.getItemDescription().getPresentableString());
    }

    public static Vector arrayToVector(Object[] arr) {
        if (arr == null) {
            return null;
        }
        Vector<Object> result = new Vector<Object>();
        for (int i = 0; i < arr.length; ++i) {
            result.add(arr[i]);
        }
        return result;
    }

    public boolean acceptsChildren() {
        return this.isMenu;
    }

    public boolean representsMenu() {
        return this.isMenu;
    }

    public MenuDescription getItemDescription() {
        return (MenuDescription)this.getObject();
    }

    public boolean canAcceptAsParent(TreeElement el) {
        if (el == null && !this.isRoot) {
            return false;
        }
        if (el != null && this.isRoot) {
            return false;
        }
        if (el == this) {
            return false;
        }
        return el instanceof MenuTreeElement && ((MenuTreeElement)el).acceptsChildren();
    }

    public void removeIdentChildElement(MenuTreeElement toremove) {
        int pos;
        TreeElement el = null;
        for (pos = 0; pos < this.children.size() && (el = (TreeElement)this.children.elementAt(pos)) != toremove; ++pos) {
        }
        if (pos == this.children.size()) {
            for (int i = 0; i < this.children.size(); ++i) {
                ((MenuTreeElement)this.children.elementAt(i)).removeIdentChildElement(toremove);
            }
            return;
        }
        el.parent = null;
        this.children.removeElementAt(pos);
    }

    public boolean isDeletable() {
        return !this.isRoot;
    }
}

