/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ui.MenuDescription;
import artofillusion.ui.MenuItemFactory;
import artofillusion.ui.MenuTreeElement;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import buoy.widget.BMenu;
import buoy.widget.BMenuBar;
import buoy.widget.MenuWidget;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;

public class MenuStructure {
    protected Object[] structure;

    public MenuStructure() {
    }

    public MenuStructure(String menuname, boolean internal) {
        this();
        this.loadStructure(menuname, internal);
    }

    public Object[] getData() {
        return this.structure;
    }

    protected static MenuWidget createMenu(Object[] itemnames, MenuItemFactory factory) {
        boolean separator = false;
        MenuDescription itemdesc = (MenuDescription)itemnames[0];
        BMenu result = Translate.menu(itemdesc.internalName);
        result.setText(itemdesc.getLabel());
        for (int i = 1; i < itemnames.length; ++i) {
            MenuWidget mi = null;
            if (itemnames[i] instanceof Object[]) {
                mi = MenuStructure.createMenu((Object[])itemnames[i], factory);
            } else if (itemnames[i] instanceof MenuDescription) {
                itemdesc = (MenuDescription)itemnames[i];
                if ("separator".equals(itemdesc.internalName)) {
                    separator = true;
                    continue;
                }
                mi = factory.createMenuItem(itemdesc);
            }
            if (mi == null) continue;
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            result.add(mi);
        }
        return result;
    }

    public BMenu createMenu(MenuItemFactory factory) {
        return (BMenu)MenuStructure.createMenu(this.structure, factory);
    }

    public BMenuBar createMenuBar(MenuItemFactory factory) {
        BMenuBar result = new BMenuBar();
        for (int i = 1; i < this.structure.length; ++i) {
            MenuDescription itemdesc;
            MenuWidget mi;
            if (this.structure[i] instanceof Object[]) {
                result.add((BMenu)MenuStructure.createMenu((Object[])this.structure[i], factory));
                continue;
            }
            if (!(this.structure[i] instanceof MenuDescription) || !((mi = factory.createMenuItem(itemdesc = (MenuDescription)this.structure[i])) instanceof BMenu)) continue;
            result.add((BMenu)mi);
        }
        return result;
    }

    protected static MenuTreeElement createTreeElements(Object[] itemdescs, TreeList tree) {
        MenuDescription desc = (MenuDescription)itemdescs[0];
        TreeElement[] childs = new MenuTreeElement[itemdescs.length - 1];
        for (int i = 1; i < itemdescs.length; ++i) {
            if (itemdescs[i] instanceof MenuDescription) {
                MenuDescription childdesc = (MenuDescription)itemdescs[i];
                childs[i - 1] = new MenuTreeElement(childdesc, tree, null);
                continue;
            }
            if (!(itemdescs[i] instanceof Object[])) continue;
            childs[i - 1] = MenuStructure.createTreeElements((Object[])itemdescs[i], tree);
        }
        return new MenuTreeElement(desc, tree, childs);
    }

    public MenuTreeElement createTreeElements(TreeList tree) {
        return MenuStructure.createTreeElements(this.structure, tree);
    }

    protected static Object[] internBuildFromMenuTree(TreeElement treeelement) {
        MenuTreeElement mte = (MenuTreeElement)treeelement;
        Object[] result = new Object[mte.getNumChildren() + 1];
        result[0] = mte.getItemDescription();
        for (int i = 0; i < mte.getNumChildren(); ++i) {
            MenuTreeElement mtei = (MenuTreeElement)mte.getChild(i);
            result[i + 1] = mtei.representsMenu() ? MenuStructure.internBuildFromMenuTree(mtei) : mtei.getItemDescription();
        }
        return result;
    }

    public void buildFromMenuTree(TreeElement treeelement) {
        this.structure = MenuStructure.internBuildFromMenuTree(treeelement);
    }

    protected static void writeToStream(Object[] itemdescs, Writer w) throws IOException {
        for (int i = 0; i < itemdescs.length; ++i) {
            if (itemdescs[i] instanceof Object[]) {
                w.write("!SUBMENU\n");
                MenuStructure.writeToStream((Object[])itemdescs[i], w);
                continue;
            }
            if (!(itemdescs[i] instanceof MenuDescription)) continue;
            w.write(((MenuDescription)itemdescs[i]).getDescText() + "\n");
        }
        w.write("!END\n");
    }

    public void writeToStream(OutputStream output) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(output);
        MenuStructure.writeToStream(this.structure, w);
        ((Writer)w).flush();
        ((Writer)w).close();
    }

    protected static Object[] readFromStreamIntern(BufferedReader r) throws IOException {
        String line;
        Vector<Object> result = new Vector<Object>();
        while ((line = r.readLine()) != null && !"!END".equals(line = line.trim())) {
            if ("".equals(line) || line.startsWith("#")) continue;
            if ("!SUBMENU".equals(line)) {
                result.add(MenuStructure.readFromStreamIntern(r));
                continue;
            }
            result.add(new MenuDescription(line, result.size() == 0));
        }
        return result.toArray();
    }

    public void readFromStream(InputStream input) throws IOException {
        this.structure = MenuStructure.readFromStreamIntern(new BufferedReader(new InputStreamReader(input)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStructure(String menuname, boolean internal) {
        File f;
        InputStream input = null;
        if (!internal && (f = new File(System.getProperty("user.home"), ".aoimenus/" + menuname + ".menu")).exists()) {
            try {
                input = new FileInputStream(f);
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
        }
        if (input == null) {
            input = this.getClass().getResourceAsStream("/" + menuname + ".menu");
        }
        if (input == null) {
            System.out.println("buildStructure input == null");
            return;
        }
        try {
            this.readFromStream(input);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStructure(String menuname) {
        File dir2 = new File(System.getProperty("user.home"), ".aoimenus");
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        File f = new File(System.getProperty("user.home"), ".aoimenus/" + menuname + ".menu");
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(f);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            return;
        }
        try {
            this.writeToStream(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

