/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.ModellingTool;
import artofillusion.Translator;
import artofillusion.ui.AutoScroller;
import artofillusion.ui.MenuDescription;
import artofillusion.ui.MenuStructure;
import artofillusion.ui.MenuTreeElement;
import artofillusion.ui.Translate;
import artofillusion.ui.TreeElement;
import artofillusion.ui.TreeList;
import artofillusion.ui.UIUtilities;
import buoy.event.CommandEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WindowClosingEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BList;
import buoy.widget.BScrollPane;
import buoy.widget.BTextField;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Shortcut;
import buoy.widget.WindowWidget;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class MenuEditDialog
extends BDialog {
    private BComboBox menuChoice;
    private BComboBox filterChoice;
    private BList itemList;
    private BButton transferButton;
    private TreeList treeList;
    private BScrollPane treeListScroller;
    private BTextField itemNameField;
    private BCheckBox defShortcutCheck;
    private BTextField shortcutEntry;
    private Shortcut shortcutEntryContent;
    private BLabel shortcutInfo;
    private BButton removeOtherShortcutButton;
    private BButton closeButton;
    private LayoutWindow layoutWindow;
    MenuTreeElement rootElement;
    String currentMenuName;
    Vector itemListDescs;
    MenuTreeElement currentTreeEl;
    MenuDescription currentTreeElDesc;

    public MenuEditDialog(WindowWidget parent, LayoutWindow layoutWindow) {
        super(parent, "Edit Menu", true);
        this.layoutWindow = layoutWindow;
        this.itemListDescs = new Vector();
        this.menuChoice = new BComboBox(new String[]{"MainWindow", "TriMesh", "SplineMesh"});
        this.menuChoice.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
        this.filterChoice = new BComboBox();
        this.itemList = new BList();
        this.transferButton = new BButton(" ---> ");
        this.transferButton.setActionCommand("add");
        this.transferButton.addEventLink(CommandEvent.class, (Object)this, "actionPerformed");
        this.treeList = new TreeList(layoutWindow);
        this.treeList.setAllowMultiple(false);
        this.treeList.addEventLink(SelectionChangedEvent.class, (Object)this, "selectionChanged");
        this.treeList.setPreferredSize(new Dimension(500, 100));
        this.treeListScroller = new BScrollPane(BScrollPane.SCROLLBAR_AS_NEEDED, BScrollPane.SCROLLBAR_AS_NEEDED);
        this.treeListScroller.setBackground(Color.white);
        this.treeListScroller.setContent(this.treeList);
        new AutoScroller(this.treeListScroller, 0, 10);
        this.itemNameField = new BTextField();
        this.closeButton = Translate.button("close", this, "actionPerformed");
        this.defShortcutCheck = new BCheckBox(Translate.text("defaultShortcutEntry"), false);
        this.defShortcutCheck.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
        this.shortcutEntry = new BTextField();
        this.shortcutEntry.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        this.shortcutInfo = new BLabel();
        this.removeOtherShortcutButton = Translate.button("removeOtherShortcut", this, "actionPerformed");
        FormContainer content = new FormContainer(new double[]{0.0, 0.0, 0.0, 0.0}, new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0});
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
        content.add(this.menuChoice, 0, 0, 3, 1);
        content.add(this.filterChoice, 0, 1);
        content.add(new BScrollPane(this.itemList, BScrollPane.SCROLLBAR_AS_NEEDED, BScrollPane.SCROLLBAR_AS_NEEDED), 0, 2, 2, 1);
        content.add(this.transferButton, 2, 2);
        content.add(this.treeListScroller, 3, 2);
        content.add(new BLabel("Item name:"), 0, 3);
        content.add(this.itemNameField, 1, 3, 3, 1);
        content.add(Translate.label("shortcutField"), 0, 4);
        content.add(this.shortcutEntry, 1, 4, 2, 1);
        content.add(this.defShortcutCheck, 3, 4);
        content.add(this.shortcutInfo, 0, 5, 3, 1);
        content.add(this.removeOtherShortcutButton, 3, 5);
        content.add(this.closeButton, 1, 6);
        this.setContent(content);
        this.addEventLink(WindowClosingEvent.class, new Object(){

            public void processEvent(WindowClosingEvent e) {
                MenuEditDialog.this.closeWindow();
            }
        });
        this.pack();
        UIUtilities.centerDialog(this, parent);
        this.loadMenu("MainWindow");
        this.setVisible(true);
    }

    private static void createScriptList(ArrayList list, File dir2) {
        String[] files = dir2.list();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(dir2, files[i]);
            if (f.isDirectory()) {
                MenuEditDialog.createScriptList(list, f);
                continue;
            }
            if (!files[i].endsWith(".bsh") || files[i].length() <= 4) continue;
            list.add(new String[]{"beanshell/" + f.getAbsolutePath(), files[i].substring(0, files[i].length() - 4)});
        }
    }

    public static String[][] getScriptList() {
        ArrayList list = new ArrayList();
        MenuEditDialog.createScriptList(list, new File(ModellingApp.TOOL_SCRIPT_DIRECTORY));
        return (String[][])list.toArray((T[])new String[0][]);
    }

    protected static Vector fillUniqueList(Object[] itemdescs, Vector list) {
        MenuDescription d = (MenuDescription)itemdescs[0];
        if (list.indexOf(d) == -1) {
            list.add(d);
        }
        for (int i = 1; i < itemdescs.length; ++i) {
            if (itemdescs[i] instanceof Object[]) {
                MenuEditDialog.fillUniqueList((Object[])itemdescs[i], list);
                continue;
            }
            if (!(itemdescs[i] instanceof MenuDescription) || list.indexOf(d = (MenuDescription)itemdescs[i]) != -1 || d.internalName.equals("root") || d.internalName.indexOf(47) > -1) continue;
            list.add(d);
        }
        return list;
    }

    protected MenuTreeElement findOtherShortcut(Shortcut shortcut, MenuTreeElement mtel) {
        Shortcut shcut = mtel.getItemDescription().getMenuShortcut();
        if (MenuDescription.shortcutEquality(shortcut, shcut)) {
            return mtel;
        }
        for (int i = 0; i < mtel.getNumChildren(); ++i) {
            MenuTreeElement result = this.findOtherShortcut(shortcut, (MenuTreeElement)mtel.getChild(i));
            if (result == null || result == this.currentTreeEl) continue;
            return result;
        }
        return null;
    }

    public MenuTreeElement findOtherShortcut(Shortcut shortcut) {
        return this.findOtherShortcut(shortcut, this.rootElement);
    }

    public void loadMenu(String menuname) {
        int i;
        this.currentMenuName = menuname;
        Object[] structdata = new MenuStructure(menuname, true).getData();
        this.itemListDescs.removeAllElements();
        this.itemListDescs = MenuEditDialog.fillUniqueList(structdata, new Vector());
        if (menuname.equals("MainWindow")) {
            MenuDescription menudesc;
            ModellingTool[] tools = ModellingApp.getModellingTools();
            for (i = 0; i < tools.length; ++i) {
                menudesc = new MenuDescription();
                menudesc.internalName = "modellingTool/" + tools[i].getClass().getName();
                menudesc.labelText = tools[i].getName();
                menudesc.menu = false;
                this.itemListDescs.add(menudesc);
            }
            String[][] scripts = MenuEditDialog.getScriptList();
            for (i = 0; i < scripts.length; ++i) {
                menudesc = new MenuDescription();
                menudesc.internalName = scripts[i][0];
                menudesc.labelText = scripts[i][1];
                menudesc.menu = false;
                this.itemListDescs.add(menudesc);
            }
            Translator[] trans = ModellingApp.getTranslators();
            for (i = 0; i < trans.length; ++i) {
                if (!trans[i].canImport()) continue;
                menudesc = new MenuDescription();
                menudesc.internalName = "import/" + trans[i].getClass().getName();
                menudesc.menu = false;
                this.itemListDescs.add(menudesc);
            }
            for (i = 0; i < trans.length; ++i) {
                if (!trans[i].canExport()) continue;
                menudesc = new MenuDescription();
                menudesc.internalName = "export/" + trans[i].getClass().getName();
                menudesc.menu = false;
                this.itemListDescs.add(menudesc);
            }
        }
        this.itemList.removeAll();
        for (i = 0; i < this.itemListDescs.size(); ++i) {
            this.itemList.add(((MenuDescription)this.itemListDescs.get(i)).getPresentableString());
        }
        MenuStructure structure = new MenuStructure(menuname, false);
        this.rootElement = structure.createTreeElements(this.treeList);
        this.rootElement.setAsRoot();
        this.rootElement.setExpanded(true);
        this.treeList.removeAllElements();
        this.treeList.addElement(this.rootElement);
    }

    public void saveMenu() {
        if (this.rootElement == null) {
            return;
        }
        MenuStructure struct = new MenuStructure();
        struct.buildFromMenuTree(this.rootElement);
        struct.saveStructure(this.currentMenuName);
        this.rootElement = null;
    }

    public void updateComponents() {
        String shinfo = "";
        boolean enableRemoveShortcutButton = false;
        if (this.currentTreeElDesc != null) {
            MenuTreeElement mtel;
            if (this.defShortcutCheck.getState()) {
                shinfo = "Default shortcut: ";
                Shortcut defshcut = this.currentTreeElDesc.getDefaultMenuShortcut();
                if (defshcut == null) {
                    shinfo = shinfo + "None";
                } else {
                    MenuTreeElement mtel2 = this.findOtherShortcut(defshcut);
                    if (mtel2 != null) {
                        shinfo = MenuDescription.getShortcutDescription(defshcut) + " already used by: " + mtel2.getItemDescription().getPresentableString();
                        enableRemoveShortcutButton = true;
                    } else {
                        shinfo = shinfo + MenuDescription.getShortcutDescription(defshcut);
                    }
                }
            } else if (this.shortcutEntryContent != null && (mtel = this.findOtherShortcut(this.shortcutEntryContent)) != null) {
                shinfo = "Shortcut already used by: " + mtel.getItemDescription().getPresentableString();
                enableRemoveShortcutButton = true;
            }
        }
        this.shortcutInfo.setText(shinfo);
        this.removeOtherShortcutButton.setEnabled(enableRemoveShortcutButton);
    }

    public void transferToCurrentTreeEl() {
        if (this.currentTreeEl == null) {
            return;
        }
        this.currentTreeElDesc.useDefaultShortcut = this.defShortcutCheck.getState();
        if (!this.currentTreeElDesc.useDefaultShortcut) {
            this.currentTreeElDesc.shortcut = this.shortcutEntryContent;
        }
        this.currentTreeElDesc.labelText = "".equals(this.itemNameField.getText()) ? null : this.itemNameField.getText();
        this.currentTreeEl.rereadLabel();
        this.treeList.updateTree();
        this.currentTreeEl = null;
        this.currentTreeElDesc = null;
    }

    public void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        if (command.equals("close")) {
            this.closeWindow();
        } else if (command.equals("add")) {
            int idx = this.itemList.getSelectedIndex();
            MenuDescription d = (MenuDescription)this.itemListDescs.get(idx);
            if (d.menu) {
                this.rootElement.addChild(new MenuTreeElement(d, this.treeList, new MenuTreeElement[0]), 0);
                this.treeList.updateTree();
            } else {
                this.rootElement.addChild(new MenuTreeElement(d, this.treeList, null), 0);
                this.treeList.updateTree();
            }
        } else if (command.equals("removeOtherShortcut")) {
            MenuTreeElement mtel;
            Shortcut tofind = this.defShortcutCheck.getState() ? this.currentTreeElDesc.getDefaultMenuShortcut() : this.shortcutEntryContent;
            while ((mtel = this.findOtherShortcut(tofind)) != null) {
                mtel.getItemDescription().shortcut = null;
                mtel.getItemDescription().useDefaultShortcut = false;
            }
            this.updateComponents();
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        if (e.getSource() == this.treeList) {
            this.transferToCurrentTreeEl();
            TreeElement[] selected = this.treeList.getSelectedElements();
            if (selected.length == 1) {
                this.currentTreeEl = (MenuTreeElement)selected[0];
                this.currentTreeElDesc = this.currentTreeEl.getItemDescription();
                this.defShortcutCheck.setState(this.currentTreeElDesc.useDefaultShortcut);
                if (!this.currentTreeElDesc.useDefaultShortcut) {
                    this.shortcutEntryContent = this.currentTreeElDesc.shortcut;
                    if (this.shortcutEntryContent != null) {
                        this.shortcutEntry.setText(MenuDescription.getShortcutDescription(this.shortcutEntryContent));
                    } else {
                        this.shortcutEntry.setText("");
                    }
                } else {
                    this.shortcutEntryContent = null;
                    this.shortcutEntry.setText("");
                }
                this.itemNameField.setText(this.currentTreeElDesc.labelText);
                this.updateComponents();
            }
        }
    }

    public void valueChanged(ValueChangedEvent e) {
        if (e.getSource() == this.defShortcutCheck) {
            if (this.defShortcutCheck.getState()) {
                this.shortcutEntryContent = null;
                this.shortcutEntry.setText("");
            }
            this.updateComponents();
        } else if (e.getSource() == this.menuChoice) {
            this.transferToCurrentTreeEl();
            this.saveMenu();
            this.loadMenu((String)this.menuChoice.getSelectedValue());
        }
    }

    private void closeWindow() {
        this.transferToCurrentTreeEl();
        this.saveMenu();
        this.dispose();
    }

    public void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if ((code == 8 || code == 127) && ev.getSource() == this.treeList) {
            Object[] todelete = this.treeList.getSelectedObjects();
            TreeElement[] els = this.treeList.getSelectedElements();
            for (int i = 0; i < todelete.length; ++i) {
                if (!((MenuTreeElement)els[i]).isDeletable()) continue;
                this.treeList.removeObject(todelete[i]);
            }
            return;
        }
        if (code == 10 && ev.getSource() instanceof BButton) {
            return;
        }
        if (ev.getSource() == this.shortcutEntry) {
            if (ev.isControlDown()) {
                int shmod = Shortcut.DEFAULT_MASK | 2;
                if (ev.isShiftDown()) {
                    shmod |= 1;
                }
                this.shortcutEntryContent = new Shortcut(code, shmod);
                this.shortcutEntry.setText(MenuDescription.getShortcutDescription(this.shortcutEntryContent));
                this.defShortcutCheck.setState(false);
            } else if (code == 8 || code == 127) {
                this.shortcutEntryContent = null;
                this.shortcutEntry.setText("");
            } else if (code == 9) {
                this.shortcutEntry.getComponent().transferFocus();
            }
            ev.consume();
            this.updateComponents();
        } else if (code == 10 || code == 27) {
            this.closeWindow();
            return;
        }
    }
}

