/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.LayoutWindow;
import artofillusion.Utilities;
import artofillusion.ui.Translate;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.MenuWidget;
import buoy.widget.Shortcut;

public class MenuDescription {
    public boolean menu;
    public String internalName = "";
    public Shortcut shortcut;
    public boolean useDefaultShortcut = true;
    public String labelText;

    public MenuDescription() {
    }

    public MenuDescription(String descText, boolean menu) {
        this();
        this.setDescText(descText);
        this.menu = menu;
    }

    public MenuDescription(String descText) {
        this(descText, false);
    }

    public static String quote(String l) {
        if (l == null) {
            return "\\0";
        }
        if ("".equals(l)) {
            return "\\e";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < l.length(); ++i) {
            if (l.charAt(i) == ' ') {
                result.append("\\s");
                continue;
            }
            if (l.charAt(i) == '\\') {
                result.append("\\\\");
                continue;
            }
            result.append(l.charAt(i));
        }
        return result.toString();
    }

    public static String unquote(String l) {
        if ("\\0".equals(l)) {
            return null;
        }
        if ("\\e".equals(l)) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < l.length(); ++i) {
            if (l.charAt(i) == '\\') {
                if (l.charAt(++i) == 's') {
                    result.append(" ");
                    continue;
                }
                if (l.charAt(i) != '\\') continue;
                result.append("\\");
                continue;
            }
            result.append(l.charAt(i));
        }
        return result.toString();
    }

    public String getShortcutToken() {
        if (this.useDefaultShortcut) {
            return MenuDescription.quote(null);
        }
        if (this.shortcut == null) {
            return MenuDescription.quote("");
        }
        if ((this.shortcut.getModifiers() & 1) != 0) {
            return MenuDescription.quote("S" + this.shortcut.getKeyCode());
        }
        return MenuDescription.quote("" + this.shortcut.getKeyCode());
    }

    public void setShortcutToken(String shortcutstring) {
        String shstr = MenuDescription.unquote(shortcutstring);
        if (shstr == null) {
            this.useDefaultShortcut = true;
            this.shortcut = null;
            return;
        }
        this.useDefaultShortcut = false;
        if ("".equals(shstr)) {
            this.shortcut = null;
        } else {
            boolean usesshift = false;
            if (shstr.charAt(0) == 'S') {
                usesshift = true;
                shstr = shstr.substring(1);
            }
            int keycode = Integer.decode(shstr);
            this.shortcut = new Shortcut(keycode, Shortcut.DEFAULT_MASK | (usesshift ? 1 : 0));
        }
    }

    public String getDescText() {
        return MenuDescription.quote(this.internalName) + " " + this.getShortcutToken() + " " + MenuDescription.quote(this.labelText);
    }

    public void setDescText(String descText) {
        String[] pieces = Utilities.breakLine(descText);
        this.internalName = MenuDescription.unquote(pieces[0]);
        if (pieces.length > 1) {
            this.setShortcutToken(pieces[1]);
        } else {
            this.useDefaultShortcut = true;
        }
        this.labelText = pieces.length > 2 ? MenuDescription.unquote(pieces[2]) : null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MenuDescription)) {
            return false;
        }
        MenuDescription d = (MenuDescription)o;
        return d.internalName.equals(this.internalName) && d.menu == this.menu;
    }

    public String getPresentableString() {
        return this.getLabel() + " (" + this.internalName + ")";
    }

    public String getLabel() {
        if (this.labelText == null || "".equals(this.labelText)) {
            return LayoutWindow.getDefaultMenuLabel(this.internalName);
        }
        return this.labelText;
    }

    public Shortcut getDefaultMenuShortcut() {
        if (this.menu) {
            return null;
        }
        return Translate.getShortcut(this.internalName);
    }

    public Shortcut getMenuShortcut() {
        if (this.menu) {
            return null;
        }
        if (this.useDefaultShortcut) {
            return this.getDefaultMenuShortcut();
        }
        return this.shortcut;
    }

    public static String getShortcutDescription(Shortcut sh) {
        if (sh == null) {
            return "";
        }
        return sh.getKeyStroke().toString();
    }

    public static boolean shortcutEquality(Shortcut sh1, Shortcut sh2) {
        if (sh1 == null || sh2 == null) {
            return false;
        }
        return MenuDescription.getShortcutDescription(sh1).equals(MenuDescription.getShortcutDescription(sh2));
    }

    public void applyTo(MenuWidget menuitem) {
        if (menuitem instanceof BMenu) {
            ((BMenu)menuitem).setText(this.getLabel());
        } else if (menuitem instanceof BMenuItem) {
            ((BMenuItem)menuitem).setText(this.getLabel());
        }
        Shortcut shcut = this.getMenuShortcut();
        if (menuitem instanceof BMenuItem) {
            if (shcut == null) {
                ((BMenuItem)menuitem).setShortcut(null);
            } else {
                ((BMenuItem)menuitem).setShortcut(shcut);
            }
        }
    }
}

