/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ViewerCanvas;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.KeyPressedEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.RGBImageFilter;

public abstract class EditingTool {
    protected EditingWindow theWindow;
    protected BFrame theFrame;
    public static final int ALL_CLICKS = 0;
    public static final int OBJECT_CLICKS = 1;
    public static final int HANDLE_CLICKS = 2;

    public EditingTool(EditingWindow win) {
        this.theWindow = win;
        if (win != null) {
            this.theFrame = win.getFrame();
        }
    }

    public EditingWindow getWindow() {
        return this.theWindow;
    }

    protected Image loadImage(String name, Image fallback) {
        ImageProducer ip;
        if (this.theFrame == null) {
            return fallback;
        }
        try {
            ip = (ImageProducer)this.getClass().getResource("/artofillusion/Icons/" + name).getContent();
        }
        catch (Exception e) {
            new BStandardDialog("", Translate.text("errorLoadingIcon", name), BStandardDialog.ERROR).showMessageDialog(this.theFrame);
            return fallback;
        }
        Image im = this.theFrame.getComponent().createImage(ip);
        MediaTracker mt = new MediaTracker(this.theFrame.getComponent());
        mt.addImage(im, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ex) {
            new BStandardDialog("", Translate.text("errorLoadingIcon", name), BStandardDialog.ERROR).showMessageDialog(this.theFrame);
            return fallback;
        }
        return im;
    }

    protected Image loadImage(String name) {
        return this.loadImage(name, null);
    }

    protected Image createSelectedImage() {
        FilteredImageSource ip = new FilteredImageSource(this.getIcon().getSource(), new HighlightFilter());
        Image im = this.theFrame.getComponent().createImage(ip);
        MediaTracker mt = new MediaTracker(this.theFrame.getComponent());
        mt.addImage(im, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException ex) {
            return null;
        }
        return im;
    }

    public abstract Image getIcon();

    public abstract Image getSelectedIcon();

    public String getToolTipText() {
        return null;
    }

    public int whichClicks() {
        return 0;
    }

    public boolean hilightSelection() {
        return true;
    }

    public void drawOverlay(Graphics g, ViewerCanvas view) {
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
    }

    public void mousePressedOnObject(WidgetMouseEvent e, ViewerCanvas view, int obj) {
    }

    public void mousePressedOnHandle(WidgetMouseEvent e, ViewerCanvas view, int obj, int handle) {
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
    }

    public void mouseMoved(WidgetMouseEvent e, ViewerCanvas view) {
    }

    public void keyPressed(KeyPressedEvent e, ViewerCanvas view) {
    }

    public void activate() {
        this.theWindow.setTool(this);
    }

    public void deactivate() {
    }

    public void iconDoubleClicked() {
    }

    class HighlightFilter
    extends RGBImageFilter {
        public HighlightFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int x, int y, int rgb) {
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            r = (r + g + b) / 3;
            g = b = g / 3;
            return (rgb & 0xFF000000) + (r << 16) + (g << 8) + b;
        }
    }
}

