/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.ui;

import artofillusion.ModellingApp;
import artofillusion.math.RGBColor;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueSlider;
import buoy.event.KeyPressedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.awt.Insets;
import java.util.Iterator;
import java.util.prefs.Preferences;

public class ColorChooser
extends BDialog {
    private RGBColor oldColor;
    private RGBColor newColor;
    private ValueSlider slider1;
    private ValueSlider slider2;
    private ValueSlider slider3;
    private BLabel label1;
    private BLabel label2;
    private BLabel label3;
    private Widget oldColorPatch;
    private Widget newColorPatch;
    private BComboBox modeC;
    private static int mode;

    public ColorChooser(BFrame parent, String title, RGBColor c) {
        super(parent, title, true);
        BorderContainer content = new BorderContainer();
        this.setContent(BOutline.createEmptyBorder(content, ModellingApp.standardDialogInsets));
        this.oldColor = c;
        this.newColor = c.duplicate();
        RowContainer buttons = new RowContainer();
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("cancel", this, "dispose"));
        content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        FormContainer center = new FormContainer(new double[]{0.0, 1.0, 0.0}, new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
        center.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, null, null));
        content.add(center, BorderContainer.CENTER);
        this.label1 = Translate.label("Red");
        center.add(this.label1, 0, 0, 2, 1);
        this.label2 = Translate.label("Green");
        center.add(this.label2, 0, 2, 2, 1);
        this.label3 = Translate.label("Blue");
        center.add(this.label3, 0, 4, 2, 1);
        LayoutInfo sliderLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, new Insets(0, 0, 0, 5), null);
        this.slider1 = new ValueSlider(0.0, 1.0, 100, this.newColor.getRed());
        center.add(this.slider1, 0, 1, 2, 1, sliderLayout);
        this.slider2 = new ValueSlider(0.0, 1.0, 100, this.newColor.getGreen());
        center.add(this.slider2, 0, 3, 2, 1, sliderLayout);
        this.slider3 = new ValueSlider(0.0, 1.0, 100, this.newColor.getBlue());
        center.add(this.slider3, 0, 5, 2, 1, sliderLayout);
        this.slider1.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
        this.slider2.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
        this.slider3.addEventLink(ValueChangedEvent.class, (Object)this, "valueChanged");
        center.add(new BLabel("Color Model:"), 0, 6);
        this.modeC = new BComboBox(new String[]{"RGB", "HSV", "HLS"});
        center.add(this.modeC, 1, 6, new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
        this.modeC.addEventLink(ValueChangedEvent.class, (Object)this, "modeChanged");
        this.modeC.setSelectedIndex(mode);
        LayoutInfo patchLayout = new LayoutInfo();
        center.add(new BLabel("Original Color"), 2, 0, patchLayout);
        this.oldColorPatch = this.oldColor.getSample(50, 30);
        center.add(this.oldColorPatch, 2, 1, patchLayout);
        center.add(new BLabel("New Color"), 2, 2, patchLayout);
        this.newColorPatch = this.newColor.getSample(50, 30);
        center.add(this.newColorPatch, 2, 3, patchLayout);
        this.addAsListener(this);
        this.modeChanged();
        this.pack();
        this.setResizable(false);
        UIUtilities.centerWindow(this);
        this.setVisible(true);
    }

    private void addAsListener(Widget w) {
        w.addEventLink(KeyPressedEvent.class, (Object)this, "keyPressed");
        if (w instanceof WidgetContainer) {
            Iterator iter = ((WidgetContainer)w).getChildren();
            while (iter.hasNext()) {
                this.addAsListener((Widget)iter.next());
            }
        }
    }

    private void doOk() {
        this.oldColor.setRGB(this.newColor.getRed(), this.newColor.getGreen(), this.newColor.getBlue());
        this.dispose();
    }

    private void valueChanged() {
        float[] values = new float[]{(float)this.slider1.getValue(), (float)this.slider2.getValue(), (float)this.slider3.getValue()};
        if (mode == 0) {
            this.newColor.setRGB(values[0], values[1], values[2]);
        } else if (mode == 1) {
            this.newColor.setHSV(values[0] * 360.0f, values[1], values[2]);
        } else {
            this.newColor.setHLS(values[0] * 360.0f, values[1], values[2]);
        }
        this.newColorPatch.setBackground(this.newColor.getColor());
        this.newColorPatch.repaint();
    }

    private void keyPressed(KeyPressedEvent ev) {
        int code = ev.getKeyCode();
        if (code != 10 && code != 27) {
            return;
        }
        if (code == 10 && ev.getWidget() instanceof BButton) {
            return;
        }
        if (code == 10) {
            this.oldColor.setRGB(this.newColor.getRed(), this.newColor.getGreen(), this.newColor.getBlue());
        }
        this.dispose();
    }

    private void modeChanged() {
        float[] values;
        mode = this.modeC.getSelectedIndex();
        if (mode == 0) {
            this.label1.setText(Translate.text("Red"));
            this.label2.setText(Translate.text("Green"));
            this.label3.setText(Translate.text("Blue"));
            values = new float[]{this.newColor.getRed(), this.newColor.getGreen(), this.newColor.getBlue()};
        } else if (mode == 1) {
            this.label1.setText(Translate.text("Hue"));
            this.label2.setText(Translate.text("Saturation"));
            this.label3.setText(Translate.text("Value"));
            values = this.newColor.getHSV();
            values[0] = (float)((double)values[0] / 360.0);
        } else {
            this.label1.setText(Translate.text("Hue"));
            this.label2.setText(Translate.text("Lightness"));
            this.label3.setText(Translate.text("Saturation"));
            values = this.newColor.getHLS();
            values[0] = (float)((double)values[0] / 360.0);
        }
        this.slider1.setValue(values[0]);
        this.slider2.setValue(values[1]);
        this.slider3.setValue(values[2]);
        Preferences.userNodeForPackage(ColorChooser.class).putInt("defaultColorModel", mode);
    }

    static {
        try {
            mode = Preferences.userNodeForPackage(ColorChooser.class).getInt("defaultColorModel", 1);
        }
        catch (Exception ex) {
            mode = 1;
        }
    }
}

