/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.TextureParameter;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.texture.ParameterValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VertexParameterValue
implements ParameterValue {
    private double[] value;

    public VertexParameterValue(double[] val) {
        this.value = val;
    }

    public VertexParameterValue(Mesh mesh, TextureParameter param) {
        int i;
        MeshVertex[] vert = mesh.getVertices();
        if (vert == null) {
            return;
        }
        this.value = new double[vert.length];
        if (param.type == 0) {
            for (i = 0; i < this.value.length; ++i) {
                this.value[i] = param.defaultVal;
            }
        }
        if (param.type == 1) {
            for (i = 0; i < this.value.length; ++i) {
                this.value[i] = vert[i].r.x;
            }
        }
        if (param.type == 2) {
            for (i = 0; i < this.value.length; ++i) {
                this.value[i] = vert[i].r.y;
            }
        }
        if (param.type == 3) {
            for (i = 0; i < this.value.length; ++i) {
                this.value[i] = vert[i].r.z;
            }
        }
    }

    public double[] getValue() {
        return this.value;
    }

    public void setValue(double[] val) {
        this.value = val;
    }

    public double getValue(int tri, int v1, int v2, int v3, double u, double v, double w) {
        return u * this.value[v1] + v * this.value[v2] + w * this.value[v3];
    }

    public double getAverageValue() {
        double avg = 0.0;
        for (int i = 0; i < this.value.length; ++i) {
            avg += this.value[i];
        }
        return avg / (double)this.value.length;
    }

    public ParameterValue duplicate() {
        double[] d = new double[this.value.length];
        System.arraycopy(this.value, 0, d, 0, this.value.length);
        return new VertexParameterValue(d);
    }

    public boolean equals(Object o) {
        if (!(o instanceof VertexParameterValue)) {
            return false;
        }
        VertexParameterValue v = (VertexParameterValue)o;
        if (v.value.length != this.value.length) {
            return false;
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (v.value[i] == this.value[i]) continue;
            return false;
        }
        return true;
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            out.writeDouble(this.value[i]);
        }
    }

    public VertexParameterValue(DataInputStream in) throws IOException {
        this.value = new double[in.readInt()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = in.readDouble();
        }
    }
}

