/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueSlider;
import buoy.event.MouseClickedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BFrame;
import buoy.widget.BTextField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UniformTexture
extends Texture {
    public RGBColor diffuseColor;
    public RGBColor specularColor;
    public RGBColor transparentColor;
    public RGBColor emissiveColor;
    public double roughness;
    public double cloudiness;
    public float transparency;
    public float specularity;
    public float shininess;

    public UniformTexture() {
        this.diffuseColor = new RGBColor(1.0f, 1.0f, 1.0f);
        this.specularColor = new RGBColor(1.0f, 1.0f, 1.0f);
        this.transparentColor = new RGBColor(1.0f, 1.0f, 1.0f);
        this.emissiveColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.transparency = 0.0f;
        this.specularity = 0.0f;
        this.shininess = 0.0f;
        this.roughness = 0.2;
        this.cloudiness = 0.0;
        this.name = "";
    }

    public static UniformTexture invisibleTexture() {
        UniformTexture tex = new UniformTexture();
        tex.diffuseColor.setRGB(0.0f, 0.0f, 0.0f);
        tex.specularColor.setRGB(0.0f, 0.0f, 0.0f);
        tex.transparency = 1.0f;
        return tex;
    }

    public static String getTypeName() {
        return "Uniform";
    }

    public void getTextureSpec(TextureSpec spec) {
        float frac = (1.0f - this.transparency) * (1.0f - this.specularity);
        spec.diffuse.setRGB(this.diffuseColor.red * frac, this.diffuseColor.green * frac, this.diffuseColor.blue * frac);
        frac = (1.0f - this.transparency) * this.specularity;
        spec.specular.setRGB(this.specularColor.red * frac, this.specularColor.green * frac, this.specularColor.blue * frac);
        frac = (1.0f - this.transparency) * this.shininess;
        spec.hilight.setRGB(this.specularColor.red * frac, this.specularColor.green * frac, this.specularColor.blue * frac);
        spec.transparent.setRGB(this.transparentColor.red * this.transparency, this.transparentColor.green * this.transparency, this.transparentColor.blue * this.transparency);
        spec.emissive.copy(this.emissiveColor);
        spec.roughness = this.roughness;
        spec.cloudiness = this.cloudiness;
        spec.bumpGrad.set(0.0, 0.0, 0.0);
    }

    public void getTransparency(RGBColor trans) {
        trans.setRGB(this.transparentColor.red * this.transparency, this.transparentColor.green * this.transparency, this.transparentColor.blue * this.transparency);
    }

    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        this.getTextureSpec(spec);
    }

    public TextureMapping getDefaultMapping() {
        return new UniformMapping(this);
    }

    public Texture duplicate() {
        UniformTexture m = new UniformTexture();
        m.name = this.name;
        m.diffuseColor.copy(this.diffuseColor);
        m.specularColor.copy(this.specularColor);
        m.transparentColor.copy(this.transparentColor);
        m.emissiveColor.copy(this.emissiveColor);
        m.transparency = this.transparency;
        m.specularity = this.specularity;
        m.roughness = this.roughness;
        m.cloudiness = this.cloudiness;
        m.shininess = this.shininess;
        return m;
    }

    public boolean hasComponent(int component) {
        switch (component) {
            case 0: {
                return this.transparency < 1.0f && this.specularity < 1.0f && (double)this.diffuseColor.getMaxComponent() > 0.0;
            }
            case 1: {
                return this.transparency < 1.0f && this.specularity > 0.0f && (double)this.specularColor.getMaxComponent() > 0.0;
            }
            case 2: {
                return this.transparency > 0.0f && (double)this.transparentColor.getMaxComponent() > 0.0;
            }
            case 3: {
                return this.transparency < 1.0f && this.shininess > 0.0f && (double)this.specularColor.getMaxComponent() > 0.0;
            }
            case 4: {
                return (double)this.emissiveColor.getMaxComponent() > 0.0;
            }
        }
        return false;
    }

    public void edit(final BFrame fr, Scene sc) {
        BTextField nameField = new BTextField(this.name, 15);
        final ValueSlider transSlider = new ValueSlider(0.0, 1.0, 100, this.transparency);
        final ValueSlider specSlider = new ValueSlider(0.0, 1.0, 100, this.specularity);
        final ValueSlider shinSlider = new ValueSlider(0.0, 1.0, 100, this.shininess);
        final ValueSlider roughSlider = new ValueSlider(0.0, 1.0, 100, this.roughness);
        final ValueSlider clearSlider = new ValueSlider(0.0, 1.0, 100, this.cloudiness);
        final Widget diffPatch = this.diffuseColor.getSample(50, 30);
        final Widget specPatch = this.specularColor.getSample(50, 30);
        final Widget transPatch = this.transparentColor.getSample(50, 30);
        final Widget emissPatch = this.emissiveColor.getSample(50, 30);
        final UniformTexture newTexture = (UniformTexture)this.duplicate();
        final MaterialPreviewer preview = new MaterialPreviewer(newTexture, null, 200, 160);
        final ActionProcessor process = new ActionProcessor();
        final Runnable renderCallback = new Runnable(){

            public void run() {
                preview.render();
            }
        };
        diffPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(fr, Translate.text("DiffuseColor"), newTexture.diffuseColor);
                diffPatch.setBackground(newTexture.diffuseColor.getColor());
                process.addEvent(renderCallback);
            }
        });
        specPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(fr, Translate.text("SpecularColor"), newTexture.specularColor);
                specPatch.setBackground(newTexture.specularColor.getColor());
                process.addEvent(renderCallback);
            }
        });
        transPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(fr, Translate.text("TransparentColor"), newTexture.transparentColor);
                transPatch.setBackground(newTexture.transparentColor.getColor());
                process.addEvent(renderCallback);
            }
        });
        emissPatch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(fr, Translate.text("EmissiveColor"), newTexture.emissiveColor);
                emissPatch.setBackground(newTexture.emissiveColor.getColor());
                process.addEvent(renderCallback);
            }
        });
        Object valueListener = new Object(){

            void processEvent() {
                newTexture.transparency = (float)transSlider.getValue();
                newTexture.specularity = (float)specSlider.getValue();
                newTexture.shininess = (float)shinSlider.getValue();
                newTexture.roughness = roughSlider.getValue();
                newTexture.cloudiness = clearSlider.getValue();
                process.addEvent(renderCallback);
            }
        };
        transSlider.addEventLink(ValueChangedEvent.class, valueListener);
        specSlider.addEventLink(ValueChangedEvent.class, valueListener);
        shinSlider.addEventLink(ValueChangedEvent.class, valueListener);
        roughSlider.addEventLink(ValueChangedEvent.class, valueListener);
        clearSlider.addEventLink(ValueChangedEvent.class, valueListener);
        ComponentsDialog dlg = new ComponentsDialog(fr, "", new Widget[]{preview, nameField, diffPatch, specPatch, transPatch, emissPatch, transSlider, specSlider, shinSlider, roughSlider, clearSlider}, new String[]{null, Translate.text("Name"), Translate.text("DiffuseColor"), Translate.text("SpecularColor"), Translate.text("TransparentColor"), Translate.text("EmissiveColor"), Translate.text("Transparency"), Translate.text("Specularity"), Translate.text("Shininess"), Translate.text("Roughness"), Translate.text("Cloudiness")});
        process.stopProcessing();
        if (!dlg.clickedOk()) {
            return;
        }
        this.transparency = (float)transSlider.getValue();
        this.specularity = (float)specSlider.getValue();
        this.shininess = (float)shinSlider.getValue();
        this.roughness = roughSlider.getValue();
        this.cloudiness = clearSlider.getValue();
        this.name = nameField.getText();
        this.diffuseColor.copy(newTexture.diffuseColor);
        this.specularColor.copy(newTexture.specularColor);
        this.transparentColor.copy(newTexture.transparentColor);
        this.emissiveColor.copy(newTexture.emissiveColor);
    }

    public UniformTexture(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.diffuseColor = new RGBColor(in);
        this.specularColor = new RGBColor(in);
        this.transparentColor = new RGBColor(in);
        this.emissiveColor = new RGBColor(in);
        this.roughness = in.readDouble();
        this.cloudiness = in.readDouble();
        this.transparency = in.readFloat();
        this.specularity = in.readFloat();
        this.shininess = version > 0 ? in.readFloat() : this.specularity;
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.name);
        this.diffuseColor.writeToFile(out);
        this.specularColor.writeToFile(out);
        this.transparentColor.writeToFile(out);
        this.emissiveColor.writeToFile(out);
        out.writeDouble(this.roughness);
        out.writeDouble(this.cloudiness);
        out.writeFloat(this.transparency);
        out.writeFloat(this.specularity);
        out.writeFloat(this.shininess);
    }
}

