/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.texture.Texture3D;
import artofillusion.texture.TextureSpec;

public class UVWMappedTriangle
extends RenderingTriangle {
    float r1;
    float r2;
    float r3;
    float s1;
    float s2;
    float s3;
    float t1;
    float t2;
    float t3;
    float drdx;
    float drdy;
    float drdz;
    float dsdx;
    float dsdy;
    float dsdz;
    float dtdx;
    float dtdy;
    float dtdz;
    float texScaleR;
    float texScaleS;
    float texScaleT;
    boolean bumpMapped;

    public UVWMappedTriangle(int v1, int v2, int v3, int n1, int n2, int n3) {
        super(v1, v2, v3, n1, n2, n3);
    }

    public void setMesh(RenderingMesh mesh, int index) {
        super.setMesh(mesh, index);
        this.bumpMapped = this.theMesh.mapping.getTexture().hasComponent(5);
    }

    public void setTextureCoordinates(float r1, float s1, float t1, float r2, float s2, float t2, float r3, float s3, float t3, Vec3 vert1, Vec3 vert2, Vec3 vert3) {
        this.r1 = r1;
        this.s1 = s1;
        this.t1 = t1;
        this.r2 = r2;
        this.s2 = s2;
        this.t2 = t2;
        this.r3 = r3;
        this.s3 = s3;
        this.t3 = t3;
        Vec3 a = vert2.minus(vert1);
        Vec3 b = vert3.minus(vert1);
        double inva = 1.0 / a.length();
        double invb = 1.0 / b.length();
        a.scale(inva);
        b.scale(invb);
        double adotb = a.dot(b);
        a.set(a.x - adotb * b.x, a.y - adotb * b.y, a.z - adotb * b.z);
        double aprimeinv2 = 1.0 / (1.0 - adotb * adotb);
        double scaleaa = aprimeinv2 * inva;
        double scaleab = aprimeinv2 * adotb * invb;
        double scalea = scaleaa * (double)(r2 - r1) - scaleab * (double)(r3 - r1);
        double scaleb = invb * (double)(r3 - r1);
        this.drdx = (float)(scalea * a.x + scaleb * b.x);
        this.drdy = (float)(scalea * a.y + scaleb * b.y);
        this.drdz = (float)(scalea * a.z + scaleb * b.z);
        scalea = scaleaa * (double)(s2 - s1) - scaleab * (double)(s3 - s1);
        scaleb = invb * (double)(s3 - s1);
        this.dsdx = (float)(scalea * a.x + scaleb * b.x);
        this.dsdy = (float)(scalea * a.y + scaleb * b.y);
        this.dsdz = (float)(scalea * a.z + scaleb * b.z);
        scalea = scaleaa * (double)(t2 - t1) - scaleab * (double)(t3 - t1);
        scaleb = invb * (double)(t3 - t1);
        this.dtdx = (float)(scalea * a.x + scaleb * b.x);
        this.dtdy = (float)(scalea * a.y + scaleb * b.y);
        this.dtdz = (float)(scalea * a.z + scaleb * b.z);
        this.texScaleR = (float)Math.sqrt(this.drdx * this.drdx + this.drdy * this.drdy + this.drdz * this.drdz);
        this.texScaleS = (float)Math.sqrt(this.dsdx * this.dsdx + this.dsdy * this.dsdy + this.dsdz * this.dsdz);
        this.texScaleT = (float)Math.sqrt(this.dtdx * this.dtdx + this.dtdy * this.dtdy + this.dtdz * this.dtdz);
    }

    public void getTextureSpec(TextureSpec spec, double angle, double u, double v, double w, double size, double time) {
        if (!this.theMesh.mapping.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        ((Texture3D)this.theMesh.mapping.getTexture()).getTextureSpec(spec, (double)this.r1 * u + (double)this.r2 * v + (double)this.r3 * w, (double)this.s1 * u + (double)this.s2 * v + (double)this.s3 * w, (double)this.t1 * u + (double)this.t2 * v + (double)this.t3 * w, size * (double)this.texScaleR, size * (double)this.texScaleS, size * (double)this.texScaleT, angle, time, this.getParameters(u, v, w));
        if (this.bumpMapped) {
            double r = spec.bumpGrad.x;
            double s = spec.bumpGrad.y;
            double t = spec.bumpGrad.z;
            spec.bumpGrad.set(r * (double)this.drdx + s * (double)this.dsdx + t * (double)this.dtdx, r * (double)this.drdy + s * (double)this.dsdy + t * (double)this.dtdy, r * (double)this.drdz + s * (double)this.dsdz + t * (double)this.dtdz);
        }
    }

    public void getTransparency(RGBColor trans, double angle, double u, double v, double w, double size, double time) {
        if (!this.theMesh.mapping.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        ((Texture3D)this.theMesh.mapping.getTexture()).getTransparency(trans, (double)this.r1 * u + (double)this.r2 * v + (double)this.r3 * w, (double)this.s1 * u + (double)this.s2 * v + (double)this.s3 * w, (double)this.t1 * u + (double)this.t2 * v + (double)this.t3 * w, size * (double)this.texScaleR, size * (double)this.texScaleS, size * (double)this.texScaleT, angle, time, this.getParameters(u, v, w));
    }

    public double getDisplacement(double u, double v, double w, double size, double time) {
        return ((Texture3D)this.theMesh.mapping.getTexture()).getDisplacement((double)this.r1 * u + (double)this.r2 * v + (double)this.r3 * w, (double)this.s1 * u + (double)this.s2 * v + (double)this.s3 * w, (double)this.t1 * u + (double)this.t2 * v + (double)this.t3 * w, size * (double)this.texScaleR, size * (double)this.texScaleS, size * (double)this.texScaleT, time, this.getParameters(u, v, w));
    }
}

