/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.MeshViewer;
import artofillusion.ModelEvent;
import artofillusion.ModelListener;
import artofillusion.MoveViewTool;
import artofillusion.ReshapeMeshTool;
import artofillusion.RotateMeshTool;
import artofillusion.RotateViewTool;
import artofillusion.ScaleMeshTool;
import artofillusion.Scene;
import artofillusion.SkewMeshTool;
import artofillusion.SplineMeshViewer;
import artofillusion.TaperMeshTool;
import artofillusion.TextureParameter;
import artofillusion.TriMeshViewer;
import artofillusion.UndoRecord;
import artofillusion.Utilities;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.LayeredTexture;
import artofillusion.texture.MoveUVViewTool;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.UVMapping;
import artofillusion.texture.UVMappingViewer;
import artofillusion.texture.UVPinningDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.GenericTool;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.CommandEvent;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BSplitPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;

public class UVMappingWindow
extends BDialog
implements EditingWindow,
ModelListener {
    private Object3D oldObj;
    private Mesh editObj;
    private UVMapping map;
    private Vec2[] coord;
    private UVMappingViewer mapView;
    private MeshViewer meshView;
    private MaterialPreviewer preview;
    private ValueField minuField;
    private ValueField minvField;
    private ValueField maxuField;
    private ValueField maxvField;
    private ValueField uField;
    private ValueField vField;
    private BComboBox componentChoice;
    private BComboBox resChoice;
    private BCheckBox faceBox;
    private boolean[] selectedVertices;
    Vec2[] startCoord;
    boolean startPerFace;
    BCheckBox pinnedCheck;
    BButton moveVerticesButton;
    BButton moveOptionsButton;
    boolean[] pinnedVertices;
    public static final int PINDIST_3D = 0;
    public static final int PINDIST_2D = 1;
    public static final int PINDIST_MESH = 2;
    int pinningDistanceMode = 0;
    public static final int PINWEIGHT_QUADNORM = 0;
    public static final int PINWEIGHT_LINNORM = 1;
    public static final int PINWEIGHT_SQRTNORM = 2;
    int pinningWeightMode = 0;

    public UVMappingWindow(BDialog parent, Object3D obj, UVMapping map) {
        super(parent, Translate.text("uvCoordsTitle"), true);
        Object3D meshObj = this.oldObj = obj;
        while (meshObj instanceof ObjectWrapper) {
            meshObj = ((ObjectWrapper)meshObj).getWrappedObject();
        }
        this.editObj = (Mesh)((Object)meshObj.duplicate());
        this.map = map;
        ObjectInfo editInfo = new ObjectInfo((Object3D)((Object)this.editObj), new CoordinateSystem(), "");
        this.faceBox = new BCheckBox(Translate.text("mapFacesIndependently"), false);
        this.findTextureVertices();
        this.selectedVertices = new boolean[0];
        double minu = Double.MAX_VALUE;
        double maxu = -1.7976931348623157E308;
        double minv = Double.MAX_VALUE;
        double maxv = -1.7976931348623157E308;
        for (int i = 0; i < this.coord.length; ++i) {
            if (this.coord[i].x < minu) {
                minu = this.coord[i].x;
            }
            if (this.coord[i].x > maxu) {
                maxu = this.coord[i].x;
            }
            if (this.coord[i].y < minv) {
                minv = this.coord[i].y;
            }
            if (!(this.coord[i].y > maxv)) continue;
            maxv = this.coord[i].y;
        }
        double padu = 0.1 * (maxu - minu);
        double padv = 0.1 * (maxv - minv);
        minu -= padu;
        maxu += padu;
        minv -= padv;
        maxv += padv;
        Texture tex = obj.getTexture();
        if (tex instanceof LayeredTexture) {
            LayeredMapping layered = (LayeredMapping)obj.getTextureMapping();
            for (int i = 0; i < layered.getNumLayers(); ++i) {
                if (layered.getLayerMapping(i) != map) continue;
                tex = layered.getLayer(i);
                break;
            }
        }
        TextureParameter[] param = map.getParameters();
        double[] paramVal = null;
        if (param != null) {
            paramVal = new double[param.length];
            for (int i = 0; i < param.length; ++i) {
                paramVal[i] = param[i].defaultVal;
            }
        }
        FormContainer content = new FormContainer(new double[]{1.0, 1.0}, new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null));
        this.setContent(content);
        BorderContainer mapViewPanel = new BorderContainer();
        this.mapView = new UVMappingViewer((Texture2D)tex, this, minu, maxu, minv, maxv, 0, 4, 0.0, paramVal);
        mapViewPanel.add(this.mapView, BorderContainer.CENTER);
        this.mapView.setVisible(true);
        this.mapView.setPreferredSize(new Dimension(200, 200));
        ToolPalette tools = new ToolPalette(6, 1);
        mapViewPanel.add(tools, BorderContainer.NORTH);
        tools.setBackground(this.getBackground());
        ReshapeMeshTool defaultTool = new ReshapeMeshTool(this);
        tools.addTool(defaultTool);
        tools.addTool(new ScaleMeshTool(this));
        tools.addTool(new RotateMeshTool(this, true));
        tools.addTool(new SkewMeshTool(this));
        tools.addTool(new TaperMeshTool(this));
        MoveUVViewTool metaTool = new MoveUVViewTool(this);
        tools.addTool(metaTool);
        this.mapView.setTool(defaultTool);
        this.mapView.setMetaTool(metaTool);
        this.meshView = this.editObj instanceof TriangleMesh ? new TriMeshViewer(editInfo, new RowContainer()) : new SplineMeshViewer(editInfo, new RowContainer());
        this.meshView.setPreferredSize(new Dimension(150, 150));
        this.meshView.setTool(new GenericTool(this, "movePoints.gif", "selected/movePoints.gif", Translate.text("reshapeMeshTool.tipText")));
        this.meshView.setMetaTool(new MoveViewTool(this));
        this.meshView.setAltTool(new RotateViewTool(this));
        this.meshView.setVisible(true);
        this.preview = new MaterialPreviewer(editInfo, 150, 150);
        BSplitPane meshViewPanel = new BSplitPane(BSplitPane.VERTICAL, this.meshView, this.preview);
        meshViewPanel.setResizeWeight(0.7);
        BSplitPane div = new BSplitPane(BSplitPane.HORIZONTAL, mapViewPanel, meshViewPanel);
        div.setResizeWeight(0.5);
        content.add(div, 0, 0, 2, 1);
        RowContainer row = new RowContainer();
        content.add(row, 0, 1);
        row.add(Translate.label("displayedComponent"));
        this.componentChoice = new BComboBox(new String[]{Translate.text("Diffuse"), Translate.text("Specular"), Translate.text("Transparent"), Translate.text("Hilight"), Translate.text("Emissive")});
        row.add(this.componentChoice);
        this.componentChoice.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        content.add(Translate.label("selectedVertexCoords"), 0, 2);
        row = new RowContainer();
        content.add(row, 0, 3);
        row.add(new BLabel("U:"));
        this.uField = new ValueField(Double.NaN, 0, 5);
        row.add(this.uField);
        row.add(new BLabel(" V:"));
        this.vField = new ValueField(Double.NaN, 0, 5);
        row.add(this.vField);
        if (this.editObj instanceof TriangleMesh) {
            this.faceBox.setState(map.isPerFaceVertex((TriangleMesh)this.editObj));
            if (this.faceBox.getState()) {
                ((TriMeshViewer)this.meshView).setSelectionMode(2);
            }
            content.add(this.faceBox, 0, 4);
        }
        this.faceBox.addEventLink(ValueChangedEvent.class, (Object)this, "faceModeChanged");
        row = new RowContainer();
        content.add(row, 1, 1);
        row.add(new BLabel(Translate.text("Resolution") + ":"));
        this.resChoice = new BComboBox(new String[]{Translate.text("Low"), Translate.text("Medium"), Translate.text("High")});
        row.add(this.resChoice);
        this.resChoice.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        content.add(Translate.label("displayedCoordRange"), 1, 2);
        row = new RowContainer();
        content.add(row, 1, 3);
        row.add(new BLabel("U:"));
        this.minuField = new ValueField(minu, 0, 5);
        row.add(this.minuField);
        row.add(Translate.label("to"), new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 5, 0, 5), null));
        this.maxuField = new ValueField(maxu, 0, 5);
        row.add(this.maxuField);
        row = new RowContainer();
        content.add(row, 1, 4);
        row.add(new BLabel("V:"));
        this.minvField = new ValueField(minv, 0, 5);
        row.add(this.minvField);
        row.add(Translate.label("to"), new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 5, 0, 5), null));
        this.maxvField = new ValueField(maxv, 0, 5);
        row.add(this.maxvField);
        this.minuField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        this.minvField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        this.maxuField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        this.maxvField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
        this.uField.addEventLink(ValueChangedEvent.class, (Object)this, "coordsChanged");
        this.vField.addEventLink(ValueChangedEvent.class, (Object)this, "coordsChanged");
        row = new RowContainer();
        content.add(row, 0, 5, 2, 1);
        this.pinnedCheck = new BCheckBox("Pinned", false);
        row.add(this.pinnedCheck);
        this.pinnedCheck.addEventLink(ValueChangedEvent.class, (Object)this, "pinnedCheckValueChanged");
        this.moveOptionsButton = Translate.button("moveOptions", this, "actionPerformed");
        row.add(this.moveOptionsButton);
        this.moveVerticesButton = Translate.button("moveVertices", this, "actionPerformed");
        row.add(this.moveVerticesButton);
        this.pinnedVertices = new boolean[this.meshView.getSelectionDistance().length];
        row = new RowContainer();
        content.add(row, 0, 6, 2, 1, new LayoutInfo());
        row.add(Translate.button("ok", this, "doOk"));
        row.add(Translate.button("cancel", this, "dispose"));
        this.pack();
        UIUtilities.centerWindow(this);
        this.setVisible(true);
    }

    private void findTextureVertices() {
        boolean isPerFace = false;
        if (this.editObj instanceof TriangleMesh) {
            isPerFace = this.map.isPerFaceVertex((TriangleMesh)this.editObj);
        }
        if (isPerFace) {
            TriangleMesh tri = (TriangleMesh)this.editObj;
            Vec2[][] faceCoord = this.map.findFaceTextureCoordinates(tri);
            int faces = tri.getFaces().length;
            this.coord = new Vec2[3 * faces];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < faces; ++j) {
                    this.coord[j * 3 + i] = faceCoord[i][j];
                }
            }
        } else {
            this.coord = this.map.findTextureCoordinates(this.editObj);
        }
        this.checkStartCoordinates();
    }

    private boolean findSelectedVertices() {
        int i;
        boolean[] newSelection;
        Object[] sel;
        if (this.faceBox.getState()) {
            sel = ((TriMeshViewer)this.meshView).getSelection();
            int faces = ((TriangleMesh)this.editObj).getFaces().length;
            newSelection = new boolean[faces * 3];
            for (int i2 = 0; i2 < sel.length; ++i2) {
                if (sel[i2] == 0) continue;
                newSelection[3 * i2 + 2] = true;
                newSelection[3 * i2 + 1] = true;
                newSelection[3 * i2] = true;
            }
        } else {
            sel = this.meshView.getSelectionDistance();
            newSelection = new boolean[sel.length];
            for (i = 0; i < sel.length; ++i) {
                newSelection[i] = sel[i] == 0;
            }
        }
        boolean changed = this.selectedVertices.length != newSelection.length;
        for (i = 0; i < newSelection.length && !changed; ++i) {
            if (this.selectedVertices[i] == newSelection[i]) continue;
            changed = true;
        }
        this.selectedVertices = newSelection;
        return changed;
    }

    private void rebuildImage() {
        int res = 1 << 2 - this.resChoice.getSelectedIndex();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.mapView.setParameters(this.minuField.getValue(), this.maxuField.getValue(), this.minvField.getValue(), this.maxvField.getValue(), this.componentChoice.getSelectedIndex(), res);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void doOk() {
        if (this.faceBox.getState()) {
            int faces = ((TriangleMesh)this.editObj).getFaces().length;
            Vec2[][] texCoord = new Vec2[3][faces];
            for (int i = 0; i < faces; ++i) {
                texCoord[0][i] = this.coord[i * 3];
                texCoord[1][i] = this.coord[i * 3 + 1];
                texCoord[2][i] = this.coord[i * 3 + 2];
            }
            this.map.setFaceTextureCoordinates(this.oldObj, texCoord);
        } else {
            this.map.setTextureCoordinates(this.oldObj, this.coord);
        }
        this.dispose();
    }

    protected void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        if ("cancel".equals(command)) {
            this.dispose();
        } else if ("moveOptions".equals(command)) {
            new UVPinningDialog(this);
        } else if ("moveVertices".equals(command)) {
            this.moveVerticesCommand();
        }
    }

    private void faceModeChanged() {
        TriangleMesh mesh = (TriangleMesh)this.editObj;
        TriangleMesh.Face[] face = mesh.getFaces();
        if (this.faceBox.getState()) {
            Vec2[] newcoord = new Vec2[face.length * 3];
            for (int i = 0; i < face.length; ++i) {
                newcoord[i * 3] = new Vec2(this.coord[face[i].v1]);
                newcoord[i * 3 + 1] = new Vec2(this.coord[face[i].v2]);
                newcoord[i * 3 + 2] = new Vec2(this.coord[face[i].v3]);
            }
            this.setTextureCoords(newcoord);
        } else {
            boolean consistent = true;
            Vec2[] newcoord = new Vec2[mesh.getVertices().length];
            for (int i = 0; i < face.length; ++i) {
                int[] index = new int[]{face[i].v1, face[i].v2, face[i].v3};
                for (int j = 0; j < 3; ++j) {
                    Vec2 v = new Vec2(this.coord[i * 3 + j]);
                    if (newcoord[index[j]] != null && !newcoord[index[j]].equals(v)) {
                        consistent = false;
                    }
                    newcoord[index[j]] = v;
                }
            }
            if (!consistent) {
                String[] options = new String[]{Translate.text("button.ok"), Translate.text("button.cancel")};
                int choice = new BStandardDialog("", UIUtilities.breakString("Disabling per-face mapping will cause some mapping information to be lost.  Are you sure you want to do this?"), BStandardDialog.QUESTION).showOptionDialog(this, options, options[1]);
                if (choice == 1) {
                    this.faceBox.setState(true);
                    return;
                }
            }
            this.setTextureCoords(newcoord);
        }
        this.mapView.setDisplayedVertices(this.coord, new boolean[this.coord.length]);
        ((TriMeshViewer)this.meshView).setSelectionMode(this.faceBox.getState() ? 2 : 0);
        this.mapView.informSelection(this, "object editor");
        this.pinnedCheck.setEnabled(!this.faceBox.getState());
        this.moveOptionsButton.setEnabled(!this.faceBox.getState());
        this.moveVerticesButton.setEnabled(!this.faceBox.getState());
        this.findSelectedVertices();
        this.rebuildImage();
    }

    protected void pinnedCheckValueChanged() {
        boolean[] selverts = this.mapView.getSelection();
        boolean[] pinnedverts = this.getPinnedVertices();
        boolean pinned = this.pinnedCheck.getState();
        for (int i = 0; i < selverts.length; ++i) {
            if (!selverts[i]) continue;
            pinnedverts[i] = pinned;
        }
    }

    private void coordsChanged(WidgetEvent ev) {
        Widget source = ev.getWidget();
        boolean[] sel = this.mapView.getSelection();
        for (int i = 0; i < sel.length; ++i) {
            if (!sel[i]) continue;
            if (source == this.uField && !Double.isNaN(this.uField.getValue())) {
                this.coord[i].x = this.uField.getValue();
            }
            if (source != this.vField || Double.isNaN(this.vField.getValue())) continue;
            this.coord[i].y = this.vField.getValue();
        }
        this.setTextureCoords(this.coord);
        this.mapView.updateVertexPositions(this.coord);
        this.mapView.repaint();
    }

    public void displayRangeChanged() {
        if (this.mapView == null) {
            return;
        }
        this.minuField.setValue(this.mapView.getMinU());
        this.minvField.setValue(this.mapView.getMinV());
        this.maxuField.setValue(this.mapView.getMaxU());
        this.maxvField.setValue(this.mapView.getMaxV());
    }

    public void modelEventHappened(ModelEvent event) {
        if (event.getSource() == this.mapView) {
            if (event.hasKey("parameter changed") && event.getCause() != this) {
                this.minuField.removeEventLink(ValueChangedEvent.class, this);
                this.minvField.removeEventLink(ValueChangedEvent.class, this);
                this.maxuField.removeEventLink(ValueChangedEvent.class, this);
                this.maxvField.removeEventLink(ValueChangedEvent.class, this);
                this.minuField.setValue(this.mapView.getMinU());
                this.maxuField.setValue(this.mapView.getMaxU());
                this.minvField.setValue(this.mapView.getMinV());
                this.maxvField.setValue(this.mapView.getMaxV());
                this.minuField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
                this.minvField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
                this.maxuField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
                this.maxvField.addEventLink(ValueChangedEvent.class, (Object)this, "rebuildImage");
            } else if (event.hasKey("selection changed")) {
                boolean[] pinnedVerts = this.getPinnedVertices();
                boolean[] selVerts = this.mapView.getSelection();
                boolean pinned = pinnedVerts.length > 0;
                for (int i = 0; i < pinnedVerts.length; ++i) {
                    if (!selVerts[i] || pinnedVerts[i]) continue;
                    pinned = false;
                    break;
                }
                this.pinnedCheck.removeEventLink(ValueChangedEvent.class, this);
                this.pinnedCheck.setState(pinned);
                this.pinnedCheck.addEventLink(ValueChangedEvent.class, (Object)this, "pinnedCheckValueChanged");
            }
        }
    }

    public void setTextureCoords(Vec2[] coords) {
        this.coord = coords;
        if (this.faceBox.getState()) {
            int faces = ((TriangleMesh)this.editObj).getFaces().length;
            Vec2[][] texCoord = new Vec2[3][faces];
            for (int i = 0; i < faces; ++i) {
                texCoord[0][i] = this.coord[i * 3];
                texCoord[1][i] = this.coord[i * 3 + 1];
                texCoord[2][i] = this.coord[i * 3 + 2];
            }
            this.map.setFaceTextureCoordinates((Object3D)((Object)this.editObj), texCoord);
            this.map.setFaceTextureCoordinates(this.preview.getObject().object, texCoord);
        } else {
            this.map.setTextureCoordinates((Object3D)((Object)this.editObj), coords);
            this.map.setTextureCoordinates(this.preview.getObject().object, coords);
        }
        this.preview.render();
        this.checkStartCoordinates();
    }

    public void setTool(EditingTool tool) {
        this.mapView.setTool(tool);
    }

    public void setHelpText(String text) {
    }

    public BFrame getFrame() {
        return UIUtilities.findFrame(this);
    }

    public boolean[] getPinnedVertices() {
        return this.pinnedVertices;
    }

    public void updateImage() {
    }

    public void updateMenus() {
        boolean selChanged = this.findSelectedVertices();
        if (selChanged) {
            this.mapView.setDisplayedVertices(this.coord, this.selectedVertices);
            this.mapView.informSelection(this, "");
        }
        this.updateTextFields();
    }

    public void updateTextFields() {
        boolean[] sel = this.mapView.getSelection();
        boolean any = false;
        double u = 0.0;
        double v = 0.0;
        for (int i = 0; i < sel.length; ++i) {
            if (!sel[i]) continue;
            if (!any) {
                u = this.coord[i].x;
                v = this.coord[i].y;
                any = true;
                continue;
            }
            if (u != this.coord[i].x) {
                u = Double.NaN;
            }
            if (v == this.coord[i].y) continue;
            v = Double.NaN;
        }
        this.uField.setValue(any ? u : Double.NaN);
        this.vField.setValue(any ? v : Double.NaN);
        this.uField.setEnabled(any);
        this.vField.setEnabled(any);
    }

    public void checkStartCoordinates() {
        if (this.startCoord == null || this.startCoord.length != this.coord.length || this.startPerFace != this.faceBox.getState()) {
            this.startCoord = (Vec2[])Utilities.deepArrayCopy(this.coord);
            this.startPerFace = this.faceBox.getState();
        }
    }

    public Vec2[] calcMovementsForPinning() {
        Vec2[] result = new Vec2[this.coord.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.coord[i].minus(this.startCoord[i]);
        }
        return result;
    }

    public double calcDistanceForPinning(int vi1, int vi2) {
        switch (this.pinningDistanceMode) {
            case 1: {
                Vec2 v1 = this.startCoord[vi1];
                Vec2 v2 = this.startCoord[vi2];
                return v1.distance(v2);
            }
            case 0: {
                Vec3 v1 = this.editObj.getVertices()[vi1].r;
                Vec3 v2 = this.editObj.getVertices()[vi2].r;
                return v1.distance(v2);
            }
        }
        return -1.0;
    }

    public void moveVerticesCommand() {
        int vi;
        int i;
        Vec2[] movements = this.calcMovementsForPinning();
        boolean[] pinnedverts = this.getPinnedVertices();
        boolean[] selverts = this.mapView.getSelection();
        int[] pinnedlist = Utilities.createIndexList(pinnedverts);
        Vec2[] pinnedstarts = new Vec2[pinnedlist.length];
        Vec2[] pinnedmovs = new Vec2[pinnedlist.length];
        Object pinnedMeshDists = null;
        double[] weights = new double[pinnedlist.length];
        for (i = 0; i < pinnedlist.length; ++i) {
            pinnedstarts[i] = this.startCoord[pinnedlist[i]];
            pinnedmovs[i] = movements[pinnedlist[i]];
        }
        if (this.pinningDistanceMode == 2) {
            pinnedMeshDists = new int[pinnedlist.length][];
            for (i = 0; i < pinnedlist.length; ++i) {
                int[] meshdists = new int[movements.length];
                for (vi = 0; vi < meshdists.length; ++vi) {
                    meshdists[i] = vi == pinnedlist[i] ? 0 : -1;
                }
                ((TriMeshViewer)this.meshView).extendDistance(meshdists, -1);
                pinnedMeshDists[i] = meshdists;
            }
        }
        for (vi = 0; vi < movements.length; ++vi) {
            if (pinnedverts[vi] || !selverts[vi]) continue;
            boolean infiniteweight = false;
            double weightsum = 0.0;
            for (i = 0; i < pinnedlist.length; ++i) {
                double dist = this.pinningDistanceMode == 2 ? (double)pinnedMeshDists[i][vi] : this.calcDistanceForPinning(vi, pinnedlist[i]);
                if (dist == 0.0) {
                    infiniteweight = true;
                    weights[i] = -1.0;
                    continue;
                }
                if (dist == -1.0) {
                    weights[i] = 0.0;
                    continue;
                }
                switch (this.pinningWeightMode) {
                    case 1: {
                        weights[i] = 1.0 / dist;
                        break;
                    }
                    case 0: {
                        weights[i] = 1.0 / (dist * dist);
                        break;
                    }
                    case 2: {
                        weights[i] = 1.0 / Math.sqrt(dist);
                        break;
                    }
                    default: {
                        weights[i] = 0.0;
                    }
                }
                weightsum += weights[i];
            }
            if (infiniteweight) {
                weightsum = 0.0;
                for (i = 0; i < pinnedlist.length; ++i) {
                    if (weights[i] == -1.0) {
                        weights[i] = 1.0;
                        weightsum += 1.0;
                        continue;
                    }
                    weights[i] = 0.0;
                }
            }
            if (weightsum > 0.0) {
                i = 0;
                while (i < pinnedlist.length) {
                    int n = i++;
                    weights[n] = weights[n] / weightsum;
                }
            }
            Vec2 finalmove = new Vec2();
            for (i = 0; i < pinnedlist.length; ++i) {
                finalmove.add(pinnedmovs[i].times(weights[i]));
            }
            this.coord[vi] = this.startCoord[vi].plus(finalmove);
        }
        this.setTextureCoords(this.coord);
        this.mapView.updateVertexPositions(this.coord);
        this.mapView.repaint();
    }

    public void setUndoRecord(UndoRecord command) {
    }

    public Scene getScene() {
        return null;
    }

    public ViewerCanvas getView() {
        return this.mapView;
    }

    public Mesh getMesh() {
        return this.editObj;
    }

    public boolean confirmClose() {
        return true;
    }
}

