/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.TextureMappingDialog;
import artofillusion.TextureParameter;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectWrapper;
import artofillusion.object.SplineMesh;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.FaceVertexParameterValue;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UVMappedTriangle;
import artofillusion.texture.UVMappingWindow;
import artofillusion.texture.VertexParameterValue;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class UVMapping
extends Mapping2D {
    int numTextureParams;
    TextureParameter uparam;
    TextureParameter vparam;
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;

    public UVMapping(Texture theTexture) {
        super(theTexture);
    }

    public static String getName() {
        return "UV";
    }

    public static boolean legalMapping(Object3D obj, Texture tex) {
        while (obj instanceof ObjectWrapper) {
            obj = ((ObjectWrapper)obj).getWrappedObject();
        }
        return tex instanceof Texture2D && (obj instanceof TriangleMesh || obj instanceof SplineMesh);
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        return new UVMappedTriangle(v1, v2, v3, n1, n2, n3);
    }

    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        UVMappedTriangle uv = (UVMappedTriangle)tri;
        uv.setTextureCoordinates((float)p1[this.numTextureParams], (float)p1[this.numTextureParams + 1], (float)p2[this.numTextureParams], (float)p2[this.numTextureParams + 1], (float)p3[this.numTextureParams], (float)p3[this.numTextureParams + 1], mesh.vert[uv.v1], mesh.vert[uv.v2], mesh.vert[uv.v3]);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, double angle, double size, double time, double[] param) {
        if (!this.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        this.texture.getTextureSpec(spec, pos.x, pos.y, size, size, angle, time, param);
        if (this.texture.hasComponent(5)) {
            double s = spec.bumpGrad.x;
            double t = spec.bumpGrad.y;
            spec.bumpGrad.set(s, t, 0.0);
        }
    }

    public void getTransparency(Vec3 pos, RGBColor trans, double angle, double size, double time, double[] param) {
        if (!this.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
        } else {
            this.texture.getTransparency(trans, pos.x, pos.y, size, size, angle, time, param);
        }
    }

    public double getDisplacement(Vec3 pos, double size, double time, double[] param) {
        return this.texture.getDisplacement(pos.x, pos.y, size, size, time, param);
    }

    public Vec2[] findTextureCoordinates(Mesh mesh) {
        TextureParameter[] param = mesh.getParameters();
        ParameterValue[] values = mesh.getParameterValues();
        if (mesh instanceof TriangleMesh && this.isPerFaceVertex((TriangleMesh)mesh)) {
            double[][] uval = null;
            double[][] vval = null;
            for (int i = 0; i < param.length; ++i) {
                if (param[i].equals(this.uparam)) {
                    uval = ((FaceVertexParameterValue)values[i]).getValue();
                    continue;
                }
                if (!param[i].equals(this.vparam)) continue;
                vval = ((FaceVertexParameterValue)values[i]).getValue();
            }
            TriangleMesh.Face[] face = ((TriangleMesh)mesh).getFaces();
            Vec2[] uv = new Vec2[mesh.getVertices().length];
            for (int i = 0; i < face.length; ++i) {
                uv[face[i].v1] = new Vec2(uval[0][i], vval[0][i]);
                uv[face[i].v2] = new Vec2(uval[1][i], vval[1][i]);
                uv[face[i].v3] = new Vec2(uval[2][i], vval[2][i]);
            }
            return uv;
        }
        double[] uval = null;
        double[] vval = null;
        for (int i = 0; i < param.length; ++i) {
            if (param[i].equals(this.uparam)) {
                uval = ((VertexParameterValue)values[i]).getValue();
                continue;
            }
            if (!param[i].equals(this.vparam)) continue;
            vval = ((VertexParameterValue)values[i]).getValue();
        }
        Vec2[] uv = new Vec2[uval.length];
        for (int i = 0; i < uv.length; ++i) {
            uv[i] = new Vec2(uval[i], vval[i]);
        }
        return uv;
    }

    public Vec2[][] findFaceTextureCoordinates(TriangleMesh mesh) {
        int faces = mesh.getFaces().length;
        TextureParameter[] param = mesh.getParameters();
        ParameterValue[] values = mesh.getParameterValues();
        double[][] uval = null;
        double[][] vval = null;
        for (int i = 0; i < param.length; ++i) {
            if (param[i].equals(this.uparam)) {
                uval = ((FaceVertexParameterValue)values[i]).getValue();
                continue;
            }
            if (!param[i].equals(this.vparam)) continue;
            vval = ((FaceVertexParameterValue)values[i]).getValue();
        }
        Vec2[][] uv = new Vec2[3][faces];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < faces; ++j) {
                uv[i][j] = new Vec2(uval[i][j], vval[i][j]);
            }
        }
        return uv;
    }

    public void setTextureCoordinates(Object3D obj, Vec2[] uv) {
        double[] uval = new double[uv.length];
        double[] vval = new double[uv.length];
        for (int i = 0; i < uv.length; ++i) {
            uval[i] = uv[i].x;
            vval[i] = uv[i].y;
        }
        obj.setParameterValue(this.uparam, new VertexParameterValue(uval));
        obj.setParameterValue(this.vparam, new VertexParameterValue(vval));
    }

    public void setFaceTextureCoordinates(Object3D obj, Vec2[][] uv) {
        while (obj instanceof ObjectWrapper) {
            obj = ((ObjectWrapper)obj).getWrappedObject();
        }
        TriangleMesh mesh = (TriangleMesh)obj;
        int faces = mesh.getFaces().length;
        double[][] uval = new double[3][faces];
        double[][] vval = new double[3][faces];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < faces; ++j) {
                uval[i][j] = uv[i][j].x;
                vval[i][j] = uv[i][j].y;
            }
        }
        obj.setParameterValue(this.uparam, new FaceVertexParameterValue(uval));
        obj.setParameterValue(this.vparam, new FaceVertexParameterValue(vval));
    }

    public boolean isPerFaceVertex(TriangleMesh mesh) {
        TextureParameter[] param = mesh.getParameters();
        for (int i = 0; i < param.length; ++i) {
            if (param[i] != this.uparam && param[i] != this.vparam) continue;
            return mesh.getParameterValues()[i] instanceof FaceVertexParameterValue;
        }
        return false;
    }

    public TextureMapping duplicate() {
        return this.duplicate(this.texture);
    }

    public TextureMapping duplicate(Texture tex) {
        UVMapping map = new UVMapping(tex);
        map.numTextureParams = this.numTextureParams;
        map.uparam = this.uparam;
        map.vparam = this.vparam;
        return map;
    }

    public void copy(TextureMapping mapping) {
        UVMapping map = (UVMapping)mapping;
        this.numTextureParams = map.numTextureParams;
        this.uparam = map.uparam;
        this.vparam = map.vparam;
    }

    public TextureParameter[] getParameters() {
        TextureParameter[] tp = this.getTexture().getParameters();
        this.numTextureParams = tp.length;
        TextureParameter[] p = new TextureParameter[this.numTextureParams + 2];
        System.arraycopy(tp, 0, p, 0, this.numTextureParams);
        if (this.uparam == null) {
            this.uparam = new TextureParameter(this, "U", -1.7976931348623157E308, Double.MAX_VALUE, 0.0);
            this.vparam = new TextureParameter(this, "V", -1.7976931348623157E308, Double.MAX_VALUE, 0.0);
            this.uparam.type = 1;
            this.vparam.type = 2;
            this.uparam.assignNewID();
            this.vparam.assignNewID();
        }
        p[this.numTextureParams] = this.uparam;
        p[this.numTextureParams + 1] = this.vparam;
        return p;
    }

    public Widget getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public UVMapping(DataInputStream in, Texture theTexture) throws IOException, InvalidObjectException {
        super(theTexture);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setAppliesTo(in.readShort());
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(0);
        out.writeShort(this.appliesTo());
    }

    class Editor
    extends FormContainer {
        BComboBox applyToChoice;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            super(1, 2);
            this.theObject = obj;
            this.preview = preview;
            this.add(Translate.button("editUVCoords", this, "doEdit"), 0, 0);
            RowContainer applyRow = new RowContainer();
            applyRow.add(new BLabel(Translate.text("applyTo") + ":"));
            this.applyToChoice = new BComboBox(new String[]{Translate.text("frontAndBackFaces"), Translate.text("frontFacesOnly"), Translate.text("backFacesOnly")});
            applyRow.add(this.applyToChoice);
            this.add(applyRow, 0, 1);
            this.applyToChoice.setSelectedIndex(UVMapping.this.appliesTo());
            this.applyToChoice.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = UVMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "applyToChanged");
        }

        private void doEdit() {
            WidgetContainer parent;
            new UVMappingWindow((BDialog)UIUtilities.findWindow(this), this.theObject, UVMapping.this);
            for (parent = this.getParent(); !(parent instanceof TextureMappingDialog) && parent != null; parent = parent.getParent()) {
            }
            if (parent != null) {
                ((TextureMappingDialog)parent).setPreviewMapping(UVMapping.this);
            }
            this.preview.render();
        }

        private void applyToChanged() {
            UVMapping.this.setAppliesTo((short)this.applyToChoice.getSelectedIndex());
            this.preview.setTexture(UVMapping.this.getTexture(), UVMapping.this);
            this.preview.render();
        }
    }
}

