/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.texture.Texture2D;
import artofillusion.texture.TextureSpec;

public class UVMappedTriangle
extends RenderingTriangle {
    float s1;
    float s2;
    float s3;
    float t1;
    float t2;
    float t3;
    float dsdx;
    float dsdy;
    float dsdz;
    float dtdx;
    float dtdy;
    float dtdz;
    float texScaleS;
    float texScaleT;
    boolean bumpMapped;

    public UVMappedTriangle(int v1, int v2, int v3, int n1, int n2, int n3) {
        super(v1, v2, v3, n1, n2, n3);
    }

    public void setMesh(RenderingMesh mesh, int index) {
        super.setMesh(mesh, index);
        this.bumpMapped = this.theMesh.mapping.getTexture().hasComponent(5);
    }

    public void setTextureCoordinates(float s1, float t1, float s2, float t2, float s3, float t3, Vec3 vert1, Vec3 vert2, Vec3 vert3) {
        this.s1 = s1;
        this.t1 = t1;
        this.s2 = s2;
        this.t2 = t2;
        this.s3 = s3;
        this.t3 = t3;
        Vec3 a = vert2.minus(vert1);
        Vec3 b = vert3.minus(vert1);
        double inva = 1.0 / a.length();
        double invb = 1.0 / b.length();
        a.scale(inva);
        b.scale(invb);
        double adotb = a.dot(b);
        a.set(a.x - adotb * b.x, a.y - adotb * b.y, a.z - adotb * b.z);
        double aprimeinv2 = 1.0 / (1.0 - adotb * adotb);
        double scaleaa = aprimeinv2 * inva;
        double scaleab = aprimeinv2 * adotb * invb;
        double scalea = scaleaa * (double)(s2 - s1) - scaleab * (double)(s3 - s1);
        double scaleb = invb * (double)(s3 - s1);
        this.dsdx = (float)(scalea * a.x + scaleb * b.x);
        this.dsdy = (float)(scalea * a.y + scaleb * b.y);
        this.dsdz = (float)(scalea * a.z + scaleb * b.z);
        scalea = scaleaa * (double)(t2 - t1) - scaleab * (double)(t3 - t1);
        scaleb = invb * (double)(t3 - t1);
        this.dtdx = (float)(scalea * a.x + scaleb * b.x);
        this.dtdy = (float)(scalea * a.y + scaleb * b.y);
        this.dtdz = (float)(scalea * a.z + scaleb * b.z);
        this.texScaleS = (float)Math.sqrt(this.dsdx * this.dsdx + this.dsdy * this.dsdy + this.dsdz * this.dsdz);
        this.texScaleT = (float)Math.sqrt(this.dtdx * this.dtdx + this.dtdy * this.dtdy + this.dtdz * this.dtdz);
    }

    public void getTextureSpec(TextureSpec spec, double angle, double u, double v, double w, double size, double time) {
        if (!this.theMesh.mapping.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        ((Texture2D)this.theMesh.mapping.getTexture()).getTextureSpec(spec, (double)this.s1 * u + (double)this.s2 * v + (double)this.s3 * w, (double)this.t1 * u + (double)this.t2 * v + (double)this.t3 * w, size * (double)this.texScaleS, size * (double)this.texScaleT, angle, time, this.getParameters(u, v, w));
        if (this.bumpMapped) {
            double s = spec.bumpGrad.x;
            double t = spec.bumpGrad.y;
            spec.bumpGrad.set(s * (double)this.dsdx + t * (double)this.dtdx, s * (double)this.dsdy + t * (double)this.dtdy, s * (double)this.dsdz + t * (double)this.dtdz);
        }
    }

    public void getTransparency(RGBColor trans, double angle, double u, double v, double w, double size, double time) {
        if (!this.theMesh.mapping.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        ((Texture2D)this.theMesh.mapping.getTexture()).getTransparency(trans, (double)this.s1 * u + (double)this.s2 * v + (double)this.s3 * w, (double)this.t1 * u + (double)this.t2 * v + (double)this.t3 * w, size * (double)this.texScaleS, size * (double)this.texScaleT, angle, time, this.getParameters(u, v, w));
    }

    public double getDisplacement(double u, double v, double w, double size, double time) {
        return ((Texture2D)this.theMesh.mapping.getTexture()).getDisplacement((double)this.s1 * u + (double)this.s2 * v + (double)this.s3 * w, (double)this.t1 * u + (double)this.t2 * v + (double)this.t3 * w, size * (double)this.texScaleS, size * (double)this.texScaleT, time, this.getParameters(u, v, w));
    }
}

