/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.Camera;
import artofillusion.UndoRecord;
import artofillusion.ViewerCanvas;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.texture.UVMappingViewer;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import buoy.event.WidgetMouseEvent;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class MoveUVViewTool
extends EditingTool {
    private static Image icon;
    private static Image selectedIcon;
    private Point clickPoint;
    private Mat4 viewToWorld;
    private Vec3 clickPos;
    private boolean controlDown;
    private CoordinateSystem oldCoords;
    private double oldScale;
    private double minu;
    private double maxu;
    private double minv;
    private double maxv;
    private int vwidth;
    private int vheight;

    public MoveUVViewTool(EditingWindow fr) {
        super(fr);
        icon = this.loadImage("moveView.gif");
        selectedIcon = this.loadImage("selected/moveView.gif");
    }

    public void activate() {
        super.activate();
        this.theWindow.setHelpText(Translate.text("moveViewTool.helpText"));
    }

    public int whichClicks() {
        return 0;
    }

    public boolean hilightSelection() {
        return true;
    }

    public Image getIcon() {
        return icon;
    }

    public Image getSelectedIcon() {
        return selectedIcon;
    }

    public String getToolTipText() {
        return Translate.text("moveViewTool.tipText");
    }

    public void mousePressed(WidgetMouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        UVMappingViewer uvview = (UVMappingViewer)view;
        this.controlDown = e.isControlDown();
        this.clickPoint = e.getPoint();
        this.minu = uvview.getMinU();
        this.maxu = uvview.getMaxU();
        this.minv = uvview.getMinV();
        this.maxv = uvview.getMaxV();
        Rectangle d = uvview.getBounds();
        this.vwidth = d.width;
        this.vheight = d.height;
        this.viewToWorld = cam.getViewToWorld();
    }

    public void mouseDragged(WidgetMouseEvent e, ViewerCanvas view) {
        Camera cam = view.getCamera();
        Point dragPoint = e.getPoint();
        UVMappingViewer uvview = (UVMappingViewer)view;
        int dx = dragPoint.x - this.clickPoint.x;
        int dy = dragPoint.y - this.clickPoint.y;
        if (this.controlDown) {
            if (view.isPerspective()) {
                Vec3 move = cam.findDragVector(this.clickPos, 0, dy);
                double dist = dy > 0 ? -move.length() : move.length();
                move = this.viewToWorld.timesDirection(Vec3.vz()).times(dist * 2.0);
            } else {
                double factor = Math.pow(1.01, dy);
                double midu = (this.minu + this.maxu) / 2.0;
                double midv = (this.minv + this.maxv) / 2.0;
                double newminu = (this.minu - midu) / factor + midu;
                double newmaxu = (this.maxu - midu) / factor + midu;
                double newminv = (this.minv - midv) / factor + midv;
                double newmaxv = (this.maxv - midv) / factor + midv;
                uvview.setParameters(newminu, newmaxu, newminv, newmaxv);
                uvview.informChanged(this, "dont know");
                Vec3 move = new Vec3();
            }
        } else {
            if (e.isShiftDown()) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
            }
            double du = (this.minu - this.maxu) * (double)dx / (double)this.vwidth;
            double dv = (this.maxv - this.minv) * (double)dy / (double)this.vheight;
            uvview.setParameters(this.minu + du, this.maxu + du, this.minv + dv, this.maxv + dv);
            uvview.informChanged(this, "dont know");
        }
    }

    public void mouseReleased(WidgetMouseEvent e, ViewerCanvas view) {
        this.mouseDragged(e, view);
        this.theWindow.updateImage();
        ObjectInfo bound = view.getBoundCamera();
        if (bound != null) {
            this.theWindow.setUndoRecord(new UndoRecord(this.theWindow, false, 1, new Object[]{bound.coords, this.oldCoords}));
        }
    }
}

