/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.TextureParameter;
import artofillusion.animation.Actor;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.SplineMesh;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Linear3DTriangle;
import artofillusion.texture.Mapping3D;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UVWMappedTriangle;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class LinearMapping3D
extends Mapping3D {
    CoordinateSystem coords;
    double ax;
    double bx;
    double cx;
    double dx;
    double ay;
    double by;
    double cy;
    double dy;
    double az;
    double bz;
    double cz;
    double dz;
    double xscale;
    double yscale;
    double zscale;
    double matScaleX;
    double matScaleY;
    double matScaleZ;
    Mat4 fromLocal;
    boolean transform;
    boolean coordsFromParams;
    int numTextureParams;
    TextureParameter xparam;
    TextureParameter yparam;
    TextureParameter zparam;
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;

    public LinearMapping3D(Texture theTexture) {
        super(theTexture);
        this.coords = new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
        this.zscale = 1.0;
        this.yscale = 1.0;
        this.xscale = 1.0;
        this.dz = 0.0;
        this.dy = 0.0;
        this.dx = 0.0;
        this.findCoefficients();
    }

    public static String getName() {
        return "Linear";
    }

    void findCoefficients() {
        Vec3 zdir = this.coords.getZDirection();
        Vec3 ydir = this.coords.getUpDirection();
        Vec3 xdir = ydir.cross(zdir);
        this.ax = xdir.x / this.xscale;
        this.bx = xdir.y / this.xscale;
        this.cx = xdir.z / this.xscale;
        this.ay = ydir.x / this.yscale;
        this.by = ydir.y / this.yscale;
        this.cy = ydir.z / this.yscale;
        this.az = zdir.x / this.zscale;
        this.bz = zdir.y / this.zscale;
        this.cz = zdir.z / this.zscale;
        this.matScaleX = 1.0 / this.xscale;
        this.matScaleY = 1.0 / this.yscale;
        this.matScaleZ = 1.0 / this.zscale;
        this.fromLocal = this.coords.fromLocal();
        this.transform = this.fromLocal.m11 != 1.0 || this.fromLocal.m22 != 1.0 || this.fromLocal.m33 != 1.0;
    }

    public Vec3 getCenter() {
        return new Vec3(this.dx, this.dy, this.dz);
    }

    public void setCenter(Vec3 center) {
        this.dx = center.x;
        this.dy = center.y;
        this.dz = center.z;
        this.findCoefficients();
    }

    public Vec3 getScale() {
        return new Vec3(this.xscale, this.yscale, this.zscale);
    }

    public void setScale(Vec3 scale) {
        this.xscale = scale.x;
        this.yscale = scale.y;
        this.zscale = scale.z;
        this.findCoefficients();
    }

    public Vec3 getRotations() {
        double[] angles = this.coords.getRotationAngles();
        return new Vec3(angles[0], angles[1], angles[2]);
    }

    public void setRotations(Vec3 angles) {
        this.coords.setOrientation(angles.x, angles.y, angles.z);
        this.findCoefficients();
    }

    public boolean isBoundToSurface() {
        return this.coordsFromParams;
    }

    public void setBoundToSurface(boolean bound) {
        this.coordsFromParams = bound;
    }

    public RenderingTriangle mapTriangle(int v1, int v2, int v3, int n1, int n2, int n3, Vec3[] vert) {
        Vec3 c1 = vert[v1];
        Vec3 c2 = vert[v2];
        Vec3 c3 = vert[v3];
        if (this.coordsFromParams) {
            return new UVWMappedTriangle(v1, v2, v3, n1, n2, n3);
        }
        return new Linear3DTriangle(v1, v2, v3, n1, n2, n3, c1.x * this.ax + c1.y * this.bx + c1.z * this.cx - this.dx, c1.x * this.ay + c1.y * this.by + c1.z * this.cy - this.dy, c1.x * this.az + c1.y * this.bz + c1.z * this.cz - this.dz, c2.x * this.ax + c2.y * this.bx + c2.z * this.cx - this.dx, c2.x * this.ay + c2.y * this.by + c2.z * this.cy - this.dy, c2.x * this.az + c2.y * this.bz + c2.z * this.cz - this.dz, c3.x * this.ax + c3.y * this.bx + c3.z * this.cx - this.dx, c3.x * this.ay + c3.y * this.by + c3.z * this.cy - this.dy, c3.x * this.az + c3.y * this.bz + c3.z * this.cz - this.dz);
    }

    public void setParameters(RenderingTriangle tri, double[] p1, double[] p2, double[] p3, RenderingMesh mesh) {
        if (!(tri instanceof UVWMappedTriangle)) {
            return;
        }
        UVWMappedTriangle uvw = (UVWMappedTriangle)tri;
        double x1 = p1[this.numTextureParams];
        double y1 = p1[this.numTextureParams + 1];
        double z1 = p1[this.numTextureParams + 2];
        double x2 = p2[this.numTextureParams];
        double y2 = p2[this.numTextureParams + 1];
        double z2 = p2[this.numTextureParams + 2];
        double x3 = p3[this.numTextureParams];
        double y3 = p3[this.numTextureParams + 1];
        double z3 = p3[this.numTextureParams + 2];
        uvw.setTextureCoordinates((float)(x1 * this.ax + y1 * this.bx + z1 * this.cx - this.dx), (float)(x1 * this.ay + y1 * this.by + z1 * this.cy - this.dy), (float)(x1 * this.az + y1 * this.bz + z1 * this.cz - this.dz), (float)(x2 * this.ax + y2 * this.bx + z2 * this.cx - this.dx), (float)(x2 * this.ay + y2 * this.by + z2 * this.cy - this.dy), (float)(x2 * this.az + y2 * this.bz + z2 * this.cz - this.dz), (float)(x3 * this.ax + y3 * this.bx + z3 * this.cx - this.dx), (float)(x3 * this.ay + y3 * this.by + z3 * this.cy - this.dy), (float)(x3 * this.az + y3 * this.bz + z3 * this.cz - this.dz), mesh.vert[uvw.v1], mesh.vert[uvw.v2], mesh.vert[uvw.v3]);
    }

    public void getTextureSpec(Vec3 pos, TextureSpec spec, double angle, double size, double time, double[] param) {
        if (!this.appliesToFace(angle > 0.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 0.0;
            spec.roughness = 0.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        if (this.coordsFromParams && this.numTextureParams < param.length && param[this.numTextureParams] != Double.MAX_VALUE) {
            double x = param[this.numTextureParams];
            double y = param[this.numTextureParams + 1];
            double z = param[this.numTextureParams + 2];
            this.texture.getTextureSpec(spec, x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, x * this.az + y * this.bz + z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, angle, time, param);
        } else {
            this.texture.getTextureSpec(spec, pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, pos.x * this.az + pos.y * this.bz + pos.z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, angle, time, param);
        }
        if (this.transform && this.texture.hasComponent(5)) {
            this.fromLocal.transformDirection(spec.bumpGrad);
        }
    }

    public void getTransparency(Vec3 pos, RGBColor trans, double angle, double size, double time, double[] param) {
        if (!this.appliesToFace(angle > 0.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        if (this.coordsFromParams && this.numTextureParams < param.length && param[this.numTextureParams] != Double.MAX_VALUE) {
            double x = param[this.numTextureParams];
            double y = param[this.numTextureParams + 1];
            double z = param[this.numTextureParams + 2];
            this.texture.getTransparency(trans, x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, x * this.az + y * this.bz + z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, angle, time, param);
        } else {
            this.texture.getTransparency(trans, pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, pos.x * this.az + pos.y * this.bz + pos.z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, angle, time, param);
        }
    }

    public double getDisplacement(Vec3 pos, double size, double time, double[] param) {
        if (this.coordsFromParams && this.numTextureParams < param.length && param[this.numTextureParams] != Double.MAX_VALUE) {
            double x = param[this.numTextureParams];
            double y = param[this.numTextureParams + 1];
            double z = param[this.numTextureParams + 2];
            return this.texture.getDisplacement(x * this.ax + y * this.bx + z * this.cx - this.dx, x * this.ay + y * this.by + z * this.cy - this.dy, x * this.az + y * this.bz + z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time, param);
        }
        return this.texture.getDisplacement(pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, pos.x * this.az + pos.y * this.bz + pos.z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time, param);
    }

    public TextureMapping duplicate() {
        return this.duplicate(this.texture);
    }

    public TextureMapping duplicate(Texture tex) {
        LinearMapping3D map = new LinearMapping3D(tex);
        map.coords = this.coords.duplicate();
        map.dx = this.dx;
        map.dy = this.dy;
        map.dz = this.dz;
        map.xscale = this.xscale;
        map.yscale = this.yscale;
        map.zscale = this.zscale;
        map.findCoefficients();
        map.coordsFromParams = this.coordsFromParams;
        map.numTextureParams = this.numTextureParams;
        map.setAppliesTo(this.appliesTo());
        map.xparam = this.xparam;
        map.yparam = this.yparam;
        map.zparam = this.zparam;
        return map;
    }

    public void copy(TextureMapping mapping) {
        LinearMapping3D map = (LinearMapping3D)mapping;
        this.coords = map.coords.duplicate();
        this.dx = map.dx;
        this.dy = map.dy;
        this.dz = map.dz;
        this.xscale = map.xscale;
        this.yscale = map.yscale;
        this.zscale = map.zscale;
        this.findCoefficients();
        this.coordsFromParams = map.coordsFromParams;
        this.numTextureParams = map.numTextureParams;
        this.setAppliesTo(map.appliesTo());
        this.xparam = map.xparam;
        this.yparam = map.yparam;
        this.zparam = map.zparam;
    }

    public TextureParameter[] getParameters() {
        if (!this.coordsFromParams) {
            return this.getTexture().getParameters();
        }
        TextureParameter[] tp = this.getTexture().getParameters();
        this.numTextureParams = tp.length;
        TextureParameter[] p = new TextureParameter[this.numTextureParams + 3];
        System.arraycopy(tp, 0, p, 0, this.numTextureParams);
        if (this.xparam == null) {
            this.xparam = new TextureParameter(this, "X", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.yparam = new TextureParameter(this, "Y", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.zparam = new TextureParameter(this, "Z", -1.7976931348623157E308, Double.MAX_VALUE, Double.MAX_VALUE);
            this.xparam.type = 1;
            this.yparam.type = 2;
            this.zparam.type = 3;
            this.xparam.assignNewID();
            this.yparam.assignNewID();
            this.zparam.assignNewID();
        }
        p[this.numTextureParams] = this.xparam;
        p[this.numTextureParams + 1] = this.yparam;
        p[this.numTextureParams + 2] = this.zparam;
        return p;
    }

    public Widget getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public LinearMapping3D(DataInputStream in, Texture theTexture) throws IOException, InvalidObjectException {
        super(theTexture);
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.coords = new CoordinateSystem(in);
        this.dx = in.readDouble();
        this.dy = in.readDouble();
        this.dz = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.zscale = in.readDouble();
        this.findCoefficients();
        this.coordsFromParams = in.readBoolean();
        if (version == 1) {
            this.setAppliesTo(in.readShort());
        }
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(1);
        this.coords.writeToFile(out);
        out.writeDouble(this.dx);
        out.writeDouble(this.dy);
        out.writeDouble(this.dz);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeDouble(this.zscale);
        out.writeBoolean(this.coordsFromParams);
        out.writeShort(this.appliesTo());
    }

    class Editor
    extends FormContainer {
        ValueField xrotField;
        ValueField yrotField;
        ValueField zrotField;
        ValueField xscaleField;
        ValueField yscaleField;
        ValueField zscaleField;
        ValueField xtransField;
        ValueField ytransField;
        ValueField ztransField;
        BCheckBox coordsFromParamsBox;
        BComboBox applyToChoice;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            super(6, 8);
            this.theObject = obj;
            this.preview = preview;
            this.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
            this.add(new BLabel(Translate.text("Scale") + ":"), 0, 0, 6, 1);
            this.add(new BLabel("X"), 0, 1);
            this.xscaleField = new ValueField(LinearMapping3D.this.xscale, 2, 5);
            this.add(this.xscaleField, 1, 1);
            this.add(new BLabel("Y"), 2, 1);
            this.yscaleField = new ValueField(LinearMapping3D.this.yscale, 2, 5);
            this.add(this.yscaleField, 3, 1);
            this.add(new BLabel("Z"), 4, 1);
            this.zscaleField = new ValueField(LinearMapping3D.this.zscale, 2, 5);
            this.add(this.zscaleField, 5, 1);
            this.add(new BLabel(Translate.text("Center") + ":"), 0, 2, 6, 1);
            this.add(new BLabel("X"), 0, 3);
            this.xtransField = new ValueField(LinearMapping3D.this.dx, 0, 5);
            this.add(this.xtransField, 1, 3);
            this.add(new BLabel("Y"), 2, 3);
            this.ytransField = new ValueField(LinearMapping3D.this.dy, 0, 5);
            this.add(this.ytransField, 3, 3);
            this.add(new BLabel("Z"), 4, 3);
            this.ztransField = new ValueField(LinearMapping3D.this.dz, 0, 5);
            this.add(this.ztransField, 5, 3);
            double[] angles = LinearMapping3D.this.coords.getRotationAngles();
            this.add(new BLabel(Translate.text("Rotation") + ":"), 0, 4, 6, 1);
            this.add(new BLabel("X"), 0, 5);
            this.xrotField = new ValueField(angles[0], 0, 5);
            this.add(this.xrotField, 1, 5);
            this.add(new BLabel("Y"), 2, 5);
            this.yrotField = new ValueField(angles[1], 0, 5);
            this.add(this.yrotField, 3, 5);
            this.add(new BLabel("Z"), 4, 5);
            this.zrotField = new ValueField(angles[2], 0, 5);
            this.add(this.zrotField, 5, 5);
            RowContainer applyRow = new RowContainer();
            applyRow.add(new BLabel(Translate.text("applyTo") + ":"));
            this.applyToChoice = new BComboBox(new String[]{Translate.text("frontAndBackFaces"), Translate.text("frontFacesOnly"), Translate.text("backFacesOnly")});
            applyRow.add(this.applyToChoice);
            this.add(applyRow, 0, 6, 6, 1);
            this.applyToChoice.setSelectedIndex(LinearMapping3D.this.appliesTo());
            this.coordsFromParamsBox = new BCheckBox("Bind Texture Coordinates to Surface", LinearMapping3D.this.coordsFromParams);
            this.add(this.coordsFromParamsBox, 0, 7, 6, 1);
            this.coordsFromParamsBox.setEnabled(this.theObject instanceof TriangleMesh || this.theObject instanceof SplineMesh || this.theObject instanceof Actor);
            this.xscaleField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.yscaleField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.zscaleField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.xtransField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.ytransField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.ztransField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.xrotField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.yrotField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.zrotField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.coordsFromParamsBox.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.applyToChoice.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMapping3D.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
        }

        private void processEvent() {
            LinearMapping3D.this.xscale = this.xscaleField.getValue();
            LinearMapping3D.this.yscale = this.yscaleField.getValue();
            LinearMapping3D.this.zscale = this.zscaleField.getValue();
            LinearMapping3D.this.dx = this.xtransField.getValue();
            LinearMapping3D.this.dy = this.ytransField.getValue();
            LinearMapping3D.this.dz = this.ztransField.getValue();
            LinearMapping3D.this.coords.setOrientation(this.xrotField.getValue(), this.yrotField.getValue(), this.zrotField.getValue());
            LinearMapping3D.this.findCoefficients();
            LinearMapping3D.this.coordsFromParams = this.coordsFromParamsBox.getState();
            LinearMapping3D.this.setAppliesTo((short)this.applyToChoice.getSelectedIndex());
            this.preview.setTexture(LinearMapping3D.this.getTexture(), LinearMapping3D.this);
            this.preview.render();
        }
    }
}

