/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.texture.LayeredMapping;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import buoy.widget.BFrame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class LayeredTexture
extends Texture {
    LayeredMapping mapping;

    public LayeredTexture() {
        this.mapping = new LayeredMapping(this);
        this.name = "";
    }

    public LayeredTexture(LayeredMapping map) {
        this.mapping = map;
        this.name = "";
    }

    public boolean usesImage(ImageMap image) {
        Texture[] tex = this.mapping.getLayers();
        for (int i = 0; i < tex.length; ++i) {
            if (!tex[i].usesImage(image)) continue;
            return true;
        }
        return false;
    }

    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        this.mapping.getAverageSpec(spec, time, param);
    }

    public TextureMapping getDefaultMapping() {
        return this.mapping;
    }

    public void setMapping(LayeredMapping map) {
        this.mapping = map;
    }

    public Texture duplicate() {
        return null;
    }

    public boolean hasComponent(int component) {
        Texture[] tex = this.mapping.getLayers();
        if (tex.length == 0) {
            return component == 2;
        }
        for (int i = 0; i < tex.length; ++i) {
            if (!tex[i].hasComponent(component)) continue;
            return true;
        }
        return false;
    }

    public void edit(BFrame fr, Scene sc) {
    }

    public LayeredTexture(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(0);
        out.writeUTF(this.name);
    }
}

