/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.MaterialPreviewer;
import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.image.ImageMap;
import artofillusion.image.ImageOrColor;
import artofillusion.image.ImageOrValue;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec2;
import artofillusion.texture.Texture;
import artofillusion.texture.Texture2D;
import artofillusion.texture.TextureSpec;
import artofillusion.ui.ActionProcessor;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BOutline;
import buoy.widget.BTextField;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.GridContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class ImageMapTexture
extends Texture2D {
    public ImageOrColor diffuseColor;
    public ImageOrColor specularColor;
    public ImageOrColor transparentColor;
    public ImageOrColor emissiveColor;
    public ImageOrValue roughness;
    public ImageOrValue cloudiness;
    public ImageOrValue transparency;
    public ImageOrValue specularity;
    public ImageOrValue shininess;
    public ImageOrValue bump;
    public ImageOrValue displacement;
    public boolean tileX;
    public boolean tileY;
    public boolean mirrorX;
    public boolean mirrorY;
    private Vec2 tempGrad;
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;

    public ImageMapTexture() {
        RGBColor white = new RGBColor(1.0f, 1.0f, 1.0f);
        this.diffuseColor = new ImageOrColor(white);
        this.specularColor = new ImageOrColor(white);
        this.transparentColor = new ImageOrColor(white);
        this.emissiveColor = new ImageOrColor(new RGBColor(0.0f, 0.0f, 0.0f));
        this.transparency = new ImageOrValue(0.0f);
        this.specularity = new ImageOrValue(0.0f);
        this.shininess = new ImageOrValue(0.0f);
        this.roughness = new ImageOrValue(0.2f);
        this.cloudiness = new ImageOrValue(0.0f);
        this.bump = new ImageOrValue(0.0f);
        this.displacement = new ImageOrValue(0.0f);
        this.tileY = true;
        this.tileX = true;
        this.name = "";
        this.tempGrad = new Vec2();
    }

    public static String getTypeName() {
        return "Image Mapped";
    }

    public void getTextureSpec(TextureSpec spec, double x, double y, double xsize, double ysize, double angle, double t, double[] param) {
        double f;
        if (!this.tileX && (x < 0.0 || x > 1.0) || !this.tileY && (y < 0.0 || y > 1.0)) {
            spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
            spec.specular.setRGB(0.0f, 0.0f, 0.0f);
            spec.hilight.setRGB(0.0f, 0.0f, 0.0f);
            spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
            spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
            spec.cloudiness = 1.0;
            spec.roughness = 1.0;
            spec.bumpGrad.set(0.0, 0.0, 0.0);
            return;
        }
        x = this.mirrorX ? (((int)(f = Math.floor(x)) & 1) == 0 ? 1.0 + f - x : (x -= f)) : (x -= Math.floor(x));
        y = this.mirrorY ? (((int)(f = Math.floor(y)) & 1) == 0 ? 1.0 + f - y : (y -= f)) : (y -= Math.floor(y));
        boolean wrapx = this.tileX && !this.mirrorX;
        boolean wrapy = this.tileY && !this.mirrorY;
        float transVal = this.transparency.getValue(wrapx, wrapy, x, y, xsize, ysize);
        float specVal = this.specularity.getValue(wrapx, wrapy, x, y, xsize, ysize);
        this.diffuseColor.getColor(spec.diffuse, wrapx, wrapy, x, y, xsize, ysize);
        spec.diffuse.scale((1.0f - transVal) * (1.0f - specVal));
        this.specularColor.getColor(spec.specular, wrapx, wrapy, x, y, xsize, ysize);
        spec.hilight.copy(spec.specular);
        spec.specular.scale((1.0f - transVal) * specVal);
        spec.hilight.scale((1.0f - transVal) * this.shininess.getValue(wrapx, wrapy, x, y, xsize, ysize));
        this.transparentColor.getColor(spec.transparent, wrapx, wrapy, x, y, xsize, ysize);
        spec.transparent.scale(transVal);
        this.emissiveColor.getColor(spec.emissive, wrapx, wrapy, x, y, xsize, ysize);
        spec.roughness = this.roughness.getValue(wrapx, wrapy, x, y, xsize, ysize);
        spec.cloudiness = this.cloudiness.getValue(wrapx, wrapy, x, y, xsize, ysize);
        this.bump.getGradient(this.tempGrad, wrapx, wrapy, x, y, xsize, ysize);
        spec.bumpGrad.set(this.tempGrad.x * 0.04, this.tempGrad.y * 0.04, 0.0);
    }

    public void getTransparency(RGBColor trans, double x, double y, double xsize, double ysize, double angle, double t, double[] param) {
        double f;
        if (!this.tileX && (x < 0.0 || x > 1.0) || !this.tileY && (y < 0.0 || y > 1.0)) {
            trans.setRGB(1.0f, 1.0f, 1.0f);
            return;
        }
        x = this.mirrorX ? (((int)(f = Math.floor(x)) & 1) == 0 ? 1.0 + f - x : (x -= f)) : (x -= Math.floor(x));
        y = this.mirrorY ? (((int)(f = Math.floor(y)) & 1) == 0 ? 1.0 + f - y : (y -= f)) : (y -= Math.floor(y));
        boolean wrapx = this.tileX && !this.mirrorX;
        boolean wrapy = this.tileY && !this.mirrorY;
        float transVal = this.transparency.getValue(wrapx, wrapy, x, y, xsize, ysize);
        this.transparentColor.getColor(trans, wrapx, wrapy, x, y, xsize, ysize);
        trans.scale(transVal);
    }

    public double getDisplacement(double x, double y, double xsize, double ysize, double t, double[] param) {
        double f;
        if (!this.tileX && (x < 0.0 || x > 1.0) || !this.tileY && (y < 0.0 || y > 1.0)) {
            return 0.0;
        }
        x = this.mirrorX ? (((int)(f = Math.floor(x)) & 1) == 0 ? 1.0 + f - x : (x -= f)) : (x -= Math.floor(x));
        y = this.mirrorY ? (((int)(f = Math.floor(y)) & 1) == 0 ? 1.0 + f - y : (y -= f)) : (y -= Math.floor(y));
        boolean wrapx = this.tileX && !this.mirrorX;
        boolean wrapy = this.tileY && !this.mirrorY;
        return this.displacement.getValue(wrapx, wrapy, x, y, xsize, ysize);
    }

    public void getAverageSpec(TextureSpec spec, double time, double[] param) {
        float transVal = this.transparency.getAverageValue();
        float specVal = this.specularity.getAverageValue();
        this.diffuseColor.getAverageColor(spec.diffuse);
        spec.diffuse.scale((1.0f - transVal) * (1.0f - specVal));
        this.specularColor.getAverageColor(spec.specular);
        spec.hilight.copy(spec.specular);
        spec.specular.scale((1.0f - transVal) * specVal);
        spec.hilight.scale((1.0f - transVal) * this.shininess.getAverageValue());
        this.transparentColor.getAverageColor(spec.transparent);
        spec.transparent.scale(transVal);
        this.emissiveColor.getAverageColor(spec.emissive);
        spec.roughness = this.roughness.getAverageValue();
        spec.cloudiness = this.cloudiness.getAverageValue();
        spec.bumpGrad.set(0.0, 0.0, 0.0);
    }

    public boolean usesImage(ImageMap image) {
        return this.diffuseColor.getImage() == image || this.specularColor.getImage() == image || this.transparentColor.getImage() == image || this.emissiveColor.getImage() == image || this.roughness.getImage() == image || this.cloudiness.getImage() == image || this.transparency.getImage() == image || this.specularity.getImage() == image || this.shininess.getImage() == image || this.bump.getImage() == image || this.displacement.getImage() == image;
    }

    public Texture duplicate() {
        ImageMapTexture m = new ImageMapTexture();
        m.name = this.name;
        m.diffuseColor.copy(this.diffuseColor);
        m.specularColor.copy(this.specularColor);
        m.transparentColor.copy(this.transparentColor);
        m.emissiveColor.copy(this.emissiveColor);
        m.transparency = this.transparency.duplicate();
        m.specularity = this.specularity.duplicate();
        m.shininess = this.shininess.duplicate();
        m.roughness = this.roughness.duplicate();
        m.cloudiness = this.cloudiness.duplicate();
        m.bump = this.bump.duplicate();
        m.displacement = this.displacement.duplicate();
        m.tileX = this.tileX;
        m.tileY = this.tileY;
        m.mirrorX = this.mirrorX;
        m.mirrorY = this.mirrorY;
        return m;
    }

    public boolean hasComponent(int component) {
        switch (component) {
            case 0: {
                return (this.transparency.getValue() < 1.0f || this.transparency.getImage() != null) && (this.specularity.getValue() < 1.0f || this.specularity.getImage() != null) && (double)this.diffuseColor.getColor().getMaxComponent() > 0.0;
            }
            case 1: {
                return (this.transparency.getValue() < 1.0f || this.transparency.getImage() != null) && this.specularity.getValue() > 0.0f && (double)this.specularColor.getColor().getMaxComponent() > 0.0;
            }
            case 2: {
                if (!this.tileX || !this.tileY) {
                    return true;
                }
                return this.transparency.getValue() > 0.0f && (double)this.transparentColor.getColor().getMaxComponent() > 0.0;
            }
            case 3: {
                return (this.transparency.getValue() < 1.0f || this.transparency.getImage() != null) && this.shininess.getValue() > 0.0f && (double)this.specularColor.getColor().getMaxComponent() > 0.0;
            }
            case 4: {
                return (double)this.emissiveColor.getColor().getMaxComponent() > 0.0;
            }
            case 5: {
                return this.bump.getImage() != null;
            }
            case 6: {
                return this.displacement.getValue() != 0.0f;
            }
        }
        return false;
    }

    public void edit(BFrame fr, Scene sc) {
        new Editor(fr, sc);
    }

    public ImageMapTexture(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.name = in.readUTF();
        this.diffuseColor = new ImageOrColor(in, theScene);
        this.specularColor = new ImageOrColor(in, theScene);
        this.transparentColor = new ImageOrColor(in, theScene);
        this.emissiveColor = new ImageOrColor(in, theScene);
        this.roughness = new ImageOrValue(in, theScene);
        this.cloudiness = new ImageOrValue(in, theScene);
        this.transparency = new ImageOrValue(in, theScene);
        this.specularity = new ImageOrValue(in, theScene);
        this.shininess = version == 0 ? this.specularity.duplicate() : new ImageOrValue(in, theScene);
        this.bump = new ImageOrValue(in, theScene);
        this.displacement = new ImageOrValue(in, theScene);
        this.tileX = in.readBoolean();
        this.tileY = in.readBoolean();
        this.mirrorX = in.readBoolean();
        this.mirrorY = in.readBoolean();
        this.tempGrad = new Vec2();
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        out.writeShort(1);
        out.writeUTF(this.name);
        this.diffuseColor.writeToFile(out, theScene);
        this.specularColor.writeToFile(out, theScene);
        this.transparentColor.writeToFile(out, theScene);
        this.emissiveColor.writeToFile(out, theScene);
        this.roughness.writeToFile(out, theScene);
        this.cloudiness.writeToFile(out, theScene);
        this.transparency.writeToFile(out, theScene);
        this.specularity.writeToFile(out, theScene);
        this.shininess.writeToFile(out, theScene);
        this.bump.writeToFile(out, theScene);
        this.displacement.writeToFile(out, theScene);
        out.writeBoolean(this.tileX);
        out.writeBoolean(this.tileY);
        out.writeBoolean(this.mirrorX);
        out.writeBoolean(this.mirrorY);
    }

    private class Editor
    extends BDialog {
        BTextField nameField;
        Widget transPanel;
        Widget specPanel;
        Widget shinPanel;
        Widget roughPanel;
        Widget cloudPanel;
        Widget bumpPanel;
        Widget displacePanel;
        Widget diffColorPanel;
        Widget specColorPanel;
        Widget transColorPanel;
        Widget emissColorPanel;
        BCheckBox tileXBox;
        BCheckBox tileYBox;
        BCheckBox mirrorXBox;
        BCheckBox mirrorYBox;
        MaterialPreviewer preview;
        ActionProcessor renderProcessor;
        ImageMapTexture newTexture;
        BFrame parent;

        public Editor(BFrame fr, Scene sc) {
            super(fr, true);
            this.parent = fr;
            this.newTexture = (ImageMapTexture)ImageMapTexture.this.duplicate();
            BorderContainer content = new BorderContainer();
            this.setContent(BOutline.createEmptyBorder(content, ModellingApp.standardDialogInsets));
            RowContainer buttons = new RowContainer();
            buttons.add(Translate.button("ok", this, "doOk"));
            buttons.add(Translate.button("cancel", this, "dispose"));
            content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
            FormContainer left = new FormContainer(2, 6);
            this.preview = new MaterialPreviewer(this.newTexture, null, 200, 160);
            left.add(this.preview, 0, 0, 2, 1);
            LayoutInfo leftGapLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
            left.add(Translate.label("Name"), 0, 1);
            left.add(Translate.label("DiffuseColor"), 0, 2, leftGapLayout);
            left.add(Translate.label("SpecularColor"), 0, 3, leftGapLayout);
            left.add(Translate.label("TransparentColor"), 0, 4, leftGapLayout);
            left.add(Translate.label("EmissiveColor"), 0, 5, leftGapLayout);
            LayoutInfo justLeftLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
            this.nameField = new BTextField(ImageMapTexture.this.name, 15);
            left.add(this.nameField, 1, 1, new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.HORIZONTAL, null, null));
            this.diffColorPanel = this.newTexture.diffuseColor.getEditingPanel(this.parent, sc);
            left.add(this.diffColorPanel, 1, 2, justLeftLayout);
            this.specColorPanel = this.newTexture.specularColor.getEditingPanel(this.parent, sc);
            left.add(this.specColorPanel, 1, 3, justLeftLayout);
            this.transColorPanel = this.newTexture.transparentColor.getEditingPanel(this.parent, sc);
            left.add(this.transColorPanel, 1, 4, justLeftLayout);
            this.emissColorPanel = this.newTexture.emissiveColor.getEditingPanel(this.parent, sc);
            left.add(this.emissColorPanel, 1, 5, justLeftLayout);
            content.add(left, BorderContainer.WEST);
            FormContainer right = new FormContainer(2, 8);
            GridContainer boxes = new GridContainer(2, 2);
            right.add(boxes, 0, 0, 2, 1);
            boxes.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
            this.tileXBox = new BCheckBox("Tile Horizontally", ImageMapTexture.this.tileX);
            boxes.add(this.tileXBox, 0, 0);
            this.mirrorXBox = new BCheckBox("Mirror Horizontally", ImageMapTexture.this.mirrorX);
            boxes.add(this.mirrorXBox, 0, 1);
            this.tileYBox = new BCheckBox("Tile Vertically", ImageMapTexture.this.tileY);
            boxes.add(this.tileYBox, 1, 0);
            this.mirrorYBox = new BCheckBox("Mirror Vertically", ImageMapTexture.this.mirrorY);
            boxes.add(this.mirrorYBox, 1, 1);
            right.add(Translate.label("Transparency"), 0, 1, leftGapLayout);
            right.add(Translate.label("Specularity"), 0, 2, leftGapLayout);
            right.add(Translate.label("Shininess"), 0, 3, leftGapLayout);
            right.add(Translate.label("Roughness"), 0, 4, leftGapLayout);
            right.add(Translate.label("Cloudiness"), 0, 5, leftGapLayout);
            right.add(Translate.label("BumpHeight"), 0, 6, leftGapLayout);
            right.add(Translate.label("Displacement"), 0, 7, leftGapLayout);
            this.transPanel = this.newTexture.transparency.getEditingPanel(this.parent, sc);
            right.add(this.transPanel, 1, 1);
            this.specPanel = this.newTexture.specularity.getEditingPanel(this.parent, sc);
            right.add(this.specPanel, 1, 2);
            this.shinPanel = this.newTexture.shininess.getEditingPanel(this.parent, sc);
            right.add(this.shinPanel, 1, 3);
            this.roughPanel = this.newTexture.roughness.getEditingPanel(this.parent, sc);
            right.add(this.roughPanel, 1, 4);
            this.cloudPanel = this.newTexture.cloudiness.getEditingPanel(this.parent, sc);
            right.add(this.cloudPanel, 1, 5);
            this.bumpPanel = this.newTexture.bump.getEditingPanel(this.parent, sc);
            right.add(this.bumpPanel, 1, 6);
            this.displacePanel = this.newTexture.displacement.getEditingPanel(this.parent, sc);
            right.add(this.displacePanel, 1, 7);
            content.add(right, BorderContainer.EAST);
            this.diffColorPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.specColorPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.transColorPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.emissColorPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.transPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.specPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.shinPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.roughPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.cloudPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.bumpPanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.displacePanel.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.tileXBox.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.tileYBox.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.mirrorXBox.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.mirrorYBox.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = ImageMapTexture.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, (Object)this, "valueChanged");
            this.renderProcessor = new ActionProcessor();
            this.pack();
            this.setResizable(false);
            UIUtilities.centerWindow(this);
            this.setVisible(true);
        }

        private void doOk() {
            ImageMapTexture.this.transparency.copy(this.newTexture.transparency);
            ImageMapTexture.this.specularity.copy(this.newTexture.specularity);
            ImageMapTexture.this.shininess.copy(this.newTexture.shininess);
            ImageMapTexture.this.roughness.copy(this.newTexture.roughness);
            ImageMapTexture.this.cloudiness.copy(this.newTexture.cloudiness);
            ImageMapTexture.this.bump.copy(this.newTexture.bump);
            ImageMapTexture.this.displacement.copy(this.newTexture.displacement);
            ImageMapTexture.this.name = this.nameField.getText();
            ImageMapTexture.this.diffuseColor.copy(this.newTexture.diffuseColor);
            ImageMapTexture.this.specularColor.copy(this.newTexture.specularColor);
            ImageMapTexture.this.transparentColor.copy(this.newTexture.transparentColor);
            ImageMapTexture.this.emissiveColor.copy(this.newTexture.emissiveColor);
            ImageMapTexture.this.tileX = this.newTexture.tileX;
            ImageMapTexture.this.tileY = this.newTexture.tileY;
            ImageMapTexture.this.mirrorX = this.newTexture.mirrorX;
            ImageMapTexture.this.mirrorY = this.newTexture.mirrorY;
            this.dispose();
        }

        public void dispose() {
            this.renderProcessor.stopProcessing();
            super.dispose();
        }

        private void valueChanged() {
            this.newTexture.tileX = this.tileXBox.getState();
            this.newTexture.tileY = this.tileYBox.getState();
            this.newTexture.mirrorX = this.mirrorXBox.getState();
            this.newTexture.mirrorY = this.mirrorYBox.getState();
            this.renderProcessor.addEvent(new Runnable(){

                public void run() {
                    Editor.this.preview.render();
                }
            });
        }
    }
}

