/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.TextureParameter;
import artofillusion.object.MeshVertex;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ParameterValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FaceVertexParameterValue
implements ParameterValue {
    private double[][] value;

    public FaceVertexParameterValue(double[][] val) {
        this.value = val;
    }

    public FaceVertexParameterValue(TriangleMesh mesh, TextureParameter param) {
        int i;
        MeshVertex[] vert = mesh.getVertices();
        TriangleMesh.Face[] face = mesh.getFaces();
        this.value = new double[3][face.length];
        if (param.type == 0) {
            for (i = 0; i < this.value.length; ++i) {
                for (int j = 0; j < this.value[i].length; ++j) {
                    this.value[i][j] = param.defaultVal;
                }
            }
        }
        if (param.type == 1) {
            for (i = 0; i < face.length; ++i) {
                this.value[0][i] = vert[face[i].v1].r.x;
                this.value[1][i] = vert[face[i].v2].r.x;
                this.value[2][i] = vert[face[i].v3].r.x;
            }
        }
        if (param.type == 2) {
            for (i = 0; i < face.length; ++i) {
                this.value[0][i] = vert[face[i].v1].r.y;
                this.value[1][i] = vert[face[i].v2].r.y;
                this.value[2][i] = vert[face[i].v3].r.y;
            }
        }
        if (param.type == 3) {
            for (i = 0; i < face.length; ++i) {
                this.value[0][i] = vert[face[i].v1].r.z;
                this.value[1][i] = vert[face[i].v2].r.z;
                this.value[2][i] = vert[face[i].v3].r.z;
            }
        }
    }

    public double[][] getValue() {
        return this.value;
    }

    public void setValue(double[][] val) {
        this.value = val;
    }

    public double getValue(int tri, int v1, int v2, int v3, double u, double v, double w) {
        return u * this.value[0][tri] + v * this.value[1][tri] + w * this.value[2][tri];
    }

    public double getAverageValue() {
        double avg = 0.0;
        int n = 0;
        for (int i = 0; i < this.value.length; ++i) {
            for (int j = 0; j < this.value[i].length; ++j) {
                avg += this.value[i][j];
                ++n;
            }
        }
        return avg / (double)n;
    }

    public ParameterValue duplicate() {
        double[][] d = new double[this.value.length][];
        for (int i = 0; i < d.length; ++i) {
            d[i] = new double[this.value[i].length];
            System.arraycopy(this.value[i], 0, d[i], 0, this.value[i].length);
        }
        return new FaceVertexParameterValue(d);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FaceVertexParameterValue)) {
            return false;
        }
        FaceVertexParameterValue v = (FaceVertexParameterValue)o;
        if (v.value[0].length != this.value[0].length) {
            return false;
        }
        for (int i = 0; i < this.value.length; ++i) {
            for (int j = 0; j < this.value[i].length; ++j) {
                if (v.value[i][j] == this.value[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.value[0].length);
        for (int i = 0; i < this.value.length; ++i) {
            for (int j = 0; j < this.value[i].length; ++j) {
                out.writeDouble(this.value[i][j]);
            }
        }
    }

    public FaceVertexParameterValue(DataInputStream in) throws IOException {
        int len = in.readInt();
        this.value = new double[3][len];
        for (int i = 0; i < this.value.length; ++i) {
            for (int j = 0; j < this.value[i].length; ++j) {
                this.value[i][j] = in.readDouble();
            }
        }
    }
}

