/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.texture;

import artofillusion.TextureParameter;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.ParameterValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FaceParameterValue
implements ParameterValue {
    private double[] value;

    public FaceParameterValue(double[] val) {
        this.value = val;
    }

    public FaceParameterValue(TriangleMesh mesh, TextureParameter param) {
        this.value = new double[mesh.getFaces().length];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = param.defaultVal;
        }
    }

    public double[] getValue() {
        return this.value;
    }

    public void setValue(double[] val) {
        this.value = val;
    }

    public double getValue(int tri, int v1, int v2, int v3, double u, double v, double w) {
        return this.value[tri];
    }

    public double getAverageValue() {
        double avg = 0.0;
        for (int i = 0; i < this.value.length; ++i) {
            avg += this.value[i];
        }
        return avg / (double)this.value.length;
    }

    public ParameterValue duplicate() {
        double[] d = new double[this.value.length];
        System.arraycopy(this.value, 0, d, 0, this.value.length);
        return new FaceParameterValue(d);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FaceParameterValue)) {
            return false;
        }
        FaceParameterValue v = (FaceParameterValue)o;
        if (v.value.length != this.value.length) {
            return false;
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (v.value[i] == this.value[i]) continue;
            return false;
        }
        return true;
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            out.writeDouble(this.value[i]);
        }
    }

    public FaceParameterValue(DataInputStream in) throws IOException {
        this.value = new double[in.readInt()];
        for (int i = 0; i < this.value.length; ++i) {
            this.value[i] = in.readDouble();
        }
    }
}

