/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.script.IterAnimationScript;
import artofillusion.script.IterAnimationScriptDialog;
import artofillusion.script.ScriptRunner;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IterAnimationScriptHolder {
    static final String TEMPLATE = "";
    public static final byte INITSTATETYPE_SERIALIZABLE = 0;
    protected String sourceCode;
    protected IterAnimationScript theScript;
    protected Serializable initialState;
    protected double initialTime;
    protected Object lastState;
    protected double lastTime;

    public IterAnimationScriptHolder() {
        this.sourceCode = TEMPLATE;
    }

    public IterAnimationScriptHolder(DataInputStream in) throws IOException {
        this.initFromStream(in);
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sc) {
        this.sourceCode = sc;
        this.theScript = null;
        this.initialState = null;
        this.lastState = null;
    }

    public void buildScript() {
        if (this.theScript == null) {
            this.initialState = null;
            this.lastState = null;
            try {
                this.theScript = ScriptRunner.parseIterAnimationScript(this.sourceCode);
            }
            catch (Exception ex) {
                this.theScript = null;
                ScriptRunner.displayError(ex, 1);
            }
        }
    }

    public void rebuildInitialState(LayoutWindow window) {
        this.buildScript();
        if (this.theScript == null) {
            this.initialState = null;
            return;
        }
        try {
            this.initialState = this.theScript.createInitialState(window);
        }
        catch (Exception e) {
            ScriptRunner.displayError(e, 1);
            this.initialState = null;
            this.lastState = null;
            return;
        }
        this.initialTime = window.getScene().getTime();
        this.lastState = null;
    }

    public void applyToScene(Scene scene) {
        if (this.theScript == null || this.initialState == null) {
            return;
        }
        double destTime = scene.getTime();
        try {
            if (this.initialTime == destTime) {
                this.theScript.realizeState(this.initialState, this.initialState, scene);
                return;
            }
            if (this.lastState != null) {
                if (this.lastTime == destTime) {
                    this.theScript.realizeState(this.initialState, this.lastState, scene);
                    return;
                }
                if (this.lastTime > destTime && !this.theScript.isBackwardTimeAllowed(this.initialState, this.lastState, destTime - this.lastTime, scene)) {
                    this.lastState = this.initialState;
                    this.lastTime = this.initialTime;
                }
            } else {
                this.lastState = this.initialState;
                this.lastTime = this.initialTime;
            }
            double currtime = this.lastTime;
            Object currstate = this.lastState;
            double timestep = 1.0 / (double)scene.getFramesPerSecond();
            if (currtime > destTime) {
                timestep = -timestep;
            }
            while (Math.abs(currtime - destTime) > Math.abs(timestep)) {
                currstate = this.theScript.executeTimeStep(this.initialState, currstate, timestep, scene);
                currtime += timestep;
            }
            if (currtime != destTime) {
                currstate = this.theScript.executeTimeStep(this.initialState, currstate, destTime - currtime, scene);
                currtime = destTime;
            }
            this.lastState = currstate;
            this.lastTime = currtime;
            this.theScript.realizeState(this.initialState, this.lastState, scene);
        }
        catch (Exception ex) {
            this.lastState = null;
            ScriptRunner.displayError(ex, 1);
        }
    }

    public void edit(LayoutWindow parent) {
        IterAnimationScriptDialog d = new IterAnimationScriptDialog(parent, this.sourceCode);
        String source = d.getScriptSource();
        if (source == null) {
            return;
        }
        this.sourceCode = source;
        this.theScript = null;
        this.lastState = null;
        if (d.getAutoIterInit()) {
            if (this.initialState == null) {
                this.initialTime = 0.0;
            }
            parent.setTime(this.initialTime);
            this.rebuildInitialState(parent);
        } else {
            this.initialState = null;
        }
    }

    public void initFromStream(DataInputStream in) throws IOException, InvalidObjectException {
        System.out.println("IterAnimationScriptHolder.initFromStream1");
        short version = in.readShort();
        if (version < 0 || version > 0) {
            throw new InvalidObjectException(TEMPLATE);
        }
        this.sourceCode = in.readUTF();
        this.theScript = null;
        this.buildScript();
        byte statetype = in.readByte();
        if (statetype != 0) {
            throw new InvalidObjectException(TEMPLATE);
        }
        System.out.println("IterAnimationScriptHolder.initFromStream2");
        ObjectInputStream ois = new ObjectInputStream(in);
        try {
            this.initialState = (Serializable)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new InvalidObjectException(TEMPLATE);
        }
        System.out.println("IterAnimationScriptHolder.initFromStream3");
        this.initialTime = in.readDouble();
        System.out.println("IterAnimationScriptHolder.initFromStream4");
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        System.out.println("IterAnimationScriptHolder.writeToStream1");
        int version = 0;
        out.writeShort(version);
        out.writeUTF(this.sourceCode);
        System.out.println("IterAnimationScriptHolder.writeToStream2");
        int statetype = 0;
        out.writeByte(statetype);
        ObjectOutputStream oos = new ObjectOutputStream(out);
        System.out.println("IterAnimationScriptHolder.writeToStream3");
        try {
            oos.writeObject(this.initialState);
        }
        catch (NotSerializableException ne) {
            ne.printStackTrace();
            throw new IOException("The initial state of iterAnimation couldn't be serialized");
        }
        oos.flush();
        System.out.println("IterAnimationScriptHolder.writeToStream4");
        out.writeDouble(this.initialTime);
    }
}

