/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.LayoutWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.KeyTypedEvent;
import buoy.widget.BDialog;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BTextArea;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Font;

public class IterAnimationScriptDialog
extends BDialog {
    protected LayoutWindow window;
    protected BTextArea scriptText;
    protected String scriptSource;
    protected boolean autoIterInit;

    public IterAnimationScriptDialog(LayoutWindow parent, String script) {
        super(parent, "Iterative Animation Script", true);
        BorderContainer content = new BorderContainer();
        this.setContent(content);
        this.window = parent;
        this.scriptText = new BTextArea(25, 80);
        this.scriptText.setText(script);
        this.scriptSource = script;
        this.scriptText.setFont(new Font("Monospaced", 0, 11));
        this.scriptText.setTabSize(2);
        this.scriptText.addEventLink(KeyTypedEvent.class, (Object)this, "keyTyped");
        BScrollPane sp = new BScrollPane(this.scriptText, BScrollPane.SCROLLBAR_ALWAYS, BScrollPane.SCROLLBAR_ALWAYS);
        content.add(BOutline.createBevelBorder(sp, false), BorderContainer.CENTER);
        RowContainer buttons = new RowContainer();
        content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        buttons.add(Translate.button("ok", this, "doOk"));
        buttons.add(Translate.button("okWithAutoInit", this, "closeWindowWithAutoInit"));
        buttons.add(Translate.button("cancel", this, "cancelWindow"));
        this.pack();
        UIUtilities.centerDialog(this, parent);
        this.setVisible(true);
    }

    private void doOk() {
        this.scriptSource = this.scriptText.getText();
        this.autoIterInit = false;
        this.dispose();
    }

    private void closeWindowWithAutoInit() {
        this.scriptSource = this.scriptText.getText();
        this.autoIterInit = true;
        this.dispose();
    }

    private void cancelWindow() {
        this.scriptSource = null;
        this.dispose();
    }

    public String getScriptSource() {
        return this.scriptSource;
    }

    public boolean getAutoIterInit() {
        return this.autoIterInit;
    }

    private void keyTyped(KeyTypedEvent e) {
        char c;
        boolean extraIndent;
        int pos;
        if (e.getKeyChar() != '\r' && e.getKeyChar() != '\n') {
            return;
        }
        String text = this.scriptText.getText();
        int endWhiteSpace = pos = this.scriptText.getCaretPosition() - 1;
        int startLine = pos;
        boolean bl = extraIndent = startLine > 0 && text.charAt(startLine - 1) == '{';
        while (startLine > 0 && (c = text.charAt(startLine - 1)) != '\r' && c != '\n') {
            --startLine;
            if (Character.isWhitespace(c)) continue;
            endWhiteSpace = startLine;
        }
        String insert = text.substring(startLine, endWhiteSpace);
        if (extraIndent) {
            insert = insert + "\t";
        }
        this.scriptText.insert(insert, pos + 1);
    }
}

