/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.script;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.script.ScriptRunner;
import artofillusion.script.ToolScript;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.KeyTypedEvent;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BOutline;
import buoy.widget.BScrollPane;
import buoy.widget.BStandardDialog;
import buoy.widget.BTextArea;
import buoy.widget.BorderContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import java.awt.Cursor;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class ExecuteScriptWindow
extends BFrame {
    private LayoutWindow window;
    private BTextArea scriptText;
    private String scriptName = lastScriptName;
    private static File scriptDir;
    private static String lastScript;
    private static String lastScriptName;

    public ExecuteScriptWindow(LayoutWindow win) {
        super(lastScriptName);
        BorderContainer content = new BorderContainer();
        this.setContent(content);
        this.window = win;
        if (scriptDir == null) {
            scriptDir = new File(ModellingApp.TOOL_SCRIPT_DIRECTORY);
        }
        this.scriptText = new BTextArea(25, 80);
        if (lastScript != null) {
            this.scriptText.setText(lastScript);
        }
        this.scriptText.setFont(new Font("Monospaced", 0, 11));
        this.scriptText.setTabSize(2);
        this.scriptText.addEventLink(KeyTypedEvent.class, (Object)this, "keyTyped");
        BScrollPane sp = new BScrollPane(this.scriptText, BScrollPane.SCROLLBAR_ALWAYS, BScrollPane.SCROLLBAR_ALWAYS);
        content.add(BOutline.createBevelBorder(sp, false), BorderContainer.CENTER);
        RowContainer buttons = new RowContainer();
        content.add(buttons, BorderContainer.SOUTH, new LayoutInfo());
        buttons.add(Translate.button("executeScript", this, "executeScript"));
        buttons.add(Translate.button("Load", "...", this, "loadScript"));
        buttons.add(Translate.button("Save", "...", this, "saveScript"));
        buttons.add(Translate.button("close", this, "closeWindow"));
        this.pack();
        UIUtilities.centerWindow(this);
        this.setVisible(true);
    }

    private void closeWindow() {
        lastScript = this.scriptText.getText();
        this.dispose();
    }

    private void loadScript() {
        BFileChooser fc = new BFileChooser(BFileChooser.OPEN_FILE, Translate.text("selectScriptToLoad"));
        fc.setDirectory(scriptDir);
        fc.showDialog(this);
        if (fc.getSelectedFile() == null) {
            return;
        }
        scriptDir = fc.getDirectory();
        this.setCursor(Cursor.getPredefinedCursor(3));
        File f = fc.getSelectedFile();
        try {
            int c;
            BufferedReader in = new BufferedReader(new FileReader(f));
            StringBuffer buf = new StringBuffer();
            while ((c = in.read()) != -1) {
                buf.append((char)c);
            }
            in.close();
            this.scriptText.setText(buf.toString());
        }
        catch (Exception ex) {
            new BStandardDialog(null, new String[]{Translate.text("errorReadingScript"), ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
        }
        lastScriptName = this.scriptName = fc.getSelectedFile().getName();
        this.setTitle(this.scriptName);
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void saveScript() {
        BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text("saveScriptToFile"));
        fc.setDirectory(scriptDir);
        fc.setSelectedFile(new File(scriptDir, this.scriptName));
        fc.showDialog(this);
        if (fc.getSelectedFile() == null) {
            return;
        }
        scriptDir = fc.getDirectory();
        this.setCursor(Cursor.getPredefinedCursor(3));
        File f = fc.getSelectedFile();
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(this.scriptText.getText().toCharArray());
            out.close();
        }
        catch (Exception ex) {
            new BStandardDialog(null, new String[]{Translate.text("errorWritingScript"), ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog(this);
        }
        lastScriptName = this.scriptName = fc.getSelectedFile().getName();
        this.setTitle(this.scriptName);
        EditingWindow[] allWindows = ModellingApp.getWindows();
        for (int i = 0; i < allWindows.length; ++i) {
            if (!(allWindows[i] instanceof LayoutWindow)) continue;
            ((LayoutWindow)allWindows[i]).rebuildMenuBar();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void executeScript() {
        block5: {
            try {
                ToolScript script = ScriptRunner.parseToolScript(this.scriptText.getText());
                script.execute(this.window);
            }
            catch (Exception e) {
                int line = ScriptRunner.displayError(e, 1);
                if (line <= -1) break block5;
                String text = this.scriptText.getText();
                int index = 0;
                for (int i = 0; i < line - 1; ++i) {
                    int next = text.indexOf(10, index);
                    if (next == -1) {
                        index = -1;
                        break;
                    }
                    index = next + 1;
                }
                if (index > -1) {
                    this.scriptText.setCaretPosition(index);
                }
                this.scriptText.requestFocus();
            }
        }
        this.window.updateImage();
        this.scriptText.requestFocus();
    }

    private void keyTyped(KeyTypedEvent e) {
        char c;
        boolean extraIndent;
        int pos;
        if (e.getKeyChar() != '\r' && e.getKeyChar() != '\n') {
            return;
        }
        String text = this.scriptText.getText();
        int endWhiteSpace = pos = this.scriptText.getCaretPosition() - 1;
        int startLine = pos;
        boolean bl = extraIndent = startLine > 0 && text.charAt(startLine - 1) == '{';
        while (startLine > 0 && (c = text.charAt(startLine - 1)) != '\r' && c != '\n') {
            --startLine;
            if (Character.isWhitespace(c)) continue;
            endWhiteSpace = startLine;
        }
        String insert = text.substring(startLine, endWhiteSpace);
        if (extraIndent) {
            insert = insert + "\t";
        }
        this.scriptText.insert(insert, pos + 1);
    }

    static {
        lastScriptName = "Untitled.bsh";
    }
}

