/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.Utilities;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Module;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.KeyPressedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BorderContainer;
import buoy.widget.FormContainer;
import buoy.widget.RowContainer;
import buoy.widget.WindowWidget;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ScaleShiftModule
extends Module {
    private double scale = 1.0;
    private double shift = 0.0;
    transient double from1 = 0.0;
    transient double from2 = 1.0;
    transient double to1 = 0.0;
    transient double to2 = 1.0;
    ValueField scaleField;
    ValueField shiftField;
    ValueField from1Field;
    ValueField from2Field;
    ValueField to1Field;
    ValueField to2Field;
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;
    static /* synthetic */ Class class$buoy$event$KeyPressedEvent;

    public ScaleShiftModule(Point position) {
        super("\u00d7 1.0 + 0.0", new IOPort[]{new IOPort(0, 0, 2, new String[]{"Input", "(0)"})}, new IOPort[]{new IOPort(0, 1, 3, new String[]{"Output"})}, position);
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double val) {
        this.scale = val;
    }

    public double getShift() {
        return this.shift;
    }

    public void setShift(double val) {
        this.shift = val;
    }

    public double getAverageValue(int which, double blur) {
        if (this.linkFrom[0] == null) {
            return this.shift;
        }
        return this.linkFrom[0].getAverageValue(this.linkFromIndex[0], blur) * this.scale + this.shift;
    }

    public double getValueError(int which, double blur) {
        if (this.linkFrom[0] == null) {
            return 0.0;
        }
        return this.linkFrom[0].getValueError(this.linkFromIndex[0], blur) * Math.abs(this.scale);
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        if (this.linkFrom[0] == null) {
            grad.set(0.0, 0.0, 0.0);
            return;
        }
        this.linkFrom[0].getValueGradient(this.linkFromIndex[0], grad, blur);
        grad.set(grad.x * this.scale + this.shift, grad.y * this.scale + this.shift, grad.z * this.scale + this.shift);
    }

    public boolean edit(BFrame fr, Scene theScene) {
        this.scaleField = new ValueField(this.scale, 0, 5);
        this.shiftField = new ValueField(this.shift, 0, 5);
        this.from1Field = new ValueField(this.from1, 0, 5);
        this.from2Field = new ValueField(this.from2, 0, 5);
        this.to1Field = new ValueField(this.to1, 0, 5);
        this.to2Field = new ValueField(this.to2, 0, 5);
        RowContainer upper = new RowContainer();
        upper.add(new BLabel(Translate.text("scaleShiftEquation")));
        upper.add(this.scaleField);
        upper.add(new BLabel(" + "));
        upper.add(this.shiftField);
        FormContainer lower = new FormContainer(2, 3);
        lower.add(new BLabel("Input"), 0, 0);
        lower.add(new BLabel("Output"), 1, 0);
        lower.add(this.from1Field, 0, 1);
        lower.add(this.to1Field, 1, 1);
        lower.add(this.from2Field, 0, 2);
        lower.add(this.to2Field, 1, 2);
        BorderContainer content = new BorderContainer();
        content.add(upper, BorderContainer.NORTH);
        content.add(lower, BorderContainer.SOUTH);
        EditListener edl = new EditListener();
        ValueField[] fvarr = new ValueField[]{this.scaleField, this.shiftField, this.from1Field, this.from2Field, this.to1Field, this.to2Field};
        for (int i = 0; i < fvarr.length; ++i) {
            fvarr[i].addEventLink(class$buoy$event$ValueChangedEvent == null ? ScaleShiftModule.class$("buoy.event.ValueChangedEvent") : class$buoy$event$ValueChangedEvent, (Object)edl, "valueChanged");
            fvarr[i].addEventLink(class$buoy$event$KeyPressedEvent == null ? ScaleShiftModule.class$("buoy.event.KeyPressedEvent") : class$buoy$event$KeyPressedEvent, (Object)edl, "keyPressed");
        }
        PanelDialog dlg = new PanelDialog((WindowWidget)fr, Translate.text("selectScaleShiftProperties"), content);
        if (!dlg.clickedOk()) {
            return false;
        }
        this.scale = this.scaleField.getValue();
        this.shift = this.shiftField.getValue();
        this.from1 = this.from1Field.getValue();
        this.to1 = this.to1Field.getValue();
        this.from2 = this.from2Field.getValue();
        this.to2 = this.to2Field.getValue();
        this.name = "\u00d7 " + this.scale + " + " + this.shift;
        this.layout();
        return true;
    }

    public Module duplicate() {
        ScaleShiftModule mod = new ScaleShiftModule(new Point(this.bounds.x, this.bounds.y));
        mod.scale = this.scale;
        mod.shift = this.shift;
        mod.name = this.name;
        mod.from1 = this.from1;
        mod.from2 = this.from2;
        mod.to1 = this.to1;
        mod.to2 = this.to2;
        return mod;
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.scale);
        out.writeDouble(this.shift);
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.scale = in.readDouble();
        this.shift = in.readDouble();
        this.from1 = 0.0;
        this.from2 = 1.0;
        this.to1 = this.from1 * this.scale + this.shift;
        this.to2 = this.from2 * this.scale + this.shift;
        this.name = "\u00d7 " + this.scale + " + " + this.shift;
        this.layout();
    }

    protected class EditListener {
        boolean processEvents = false;
        ValueField[] uppers;

        public EditListener() {
            this.uppers = new ValueField[]{ScaleShiftModule.this.scaleField, ScaleShiftModule.this.shiftField};
        }

        protected boolean isUpper(Object f) {
            return Utilities.findIndexIdent(this.uppers, f) > -1;
        }

        public void keyPressed(KeyPressedEvent e) {
            this.processEvents = true;
        }

        public void valueChanged(ValueChangedEvent evt) {
            if (!this.processEvents) {
                return;
            }
            this.processEvents = false;
            double scale = ScaleShiftModule.this.scaleField.getValue();
            double shift = ScaleShiftModule.this.shiftField.getValue();
            double from1 = ScaleShiftModule.this.from1Field.getValue();
            double to1 = ScaleShiftModule.this.to1Field.getValue();
            double from2 = ScaleShiftModule.this.from2Field.getValue();
            double to2 = ScaleShiftModule.this.to2Field.getValue();
            if (this.isUpper(evt.getSource())) {
                ScaleShiftModule.this.to1Field.setValue(from1 * scale + shift);
                ScaleShiftModule.this.to2Field.setValue(from2 * scale + shift);
            } else {
                if (from1 == from2) {
                    return;
                }
                scale = (to2 - to1) / (from2 - from1);
                shift = to1 - scale * from1;
                ScaleShiftModule.this.scaleField.setValue(scale);
                ScaleShiftModule.this.shiftField.setValue(shift);
            }
        }
    }
}

