/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.Utilities;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.Link;
import artofillusion.procedural.Module;
import artofillusion.procedural.OutputModule;
import artofillusion.procedural.ParameterModule;
import artofillusion.procedural.PointInfo;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;

public class Procedure {
    protected OutputModule[] output;
    protected Module[] module;
    protected Link[] link;
    static /* synthetic */ Class class$java$awt$Point;

    public Procedure(OutputModule[] output) {
        this.output = output;
        this.module = new Module[0];
        this.link = new Link[0];
    }

    public OutputModule[] getOutputModules() {
        return this.output;
    }

    public Module[] getModules() {
        return this.module;
    }

    public int getModuleIndex(Module mod) {
        for (int i = 0; i < this.module.length; ++i) {
            if (this.module[i] != mod) continue;
            return i;
        }
        return -1;
    }

    public int getOutputIndex(Module mod) {
        for (int i = 0; i < this.output.length; ++i) {
            if (this.output[i] != mod) continue;
            return i;
        }
        return -1;
    }

    public void addModule(Module mod) {
        Module[] newmod = new Module[this.module.length + 1];
        for (int i = 0; i < this.module.length; ++i) {
            newmod[i] = this.module[i];
        }
        newmod[this.module.length] = mod;
        this.module = newmod;
    }

    public void deleteModule(int which) {
        Module[] newmod = new Module[this.module.length - 1];
        int j = 0;
        for (int i = 0; i < this.module.length; ++i) {
            if (i == which) continue;
            newmod[j++] = this.module[i];
        }
        this.module = newmod;
    }

    public void deleteModulesAndLinks(boolean[] moduleselection, boolean[] linkselection) {
        int i;
        boolean[] modsel = moduleselection;
        boolean[] linksel = linkselection == null ? new boolean[this.link.length] : (boolean[])linkselection.clone();
        boolean num = false;
        for (i = 0; i < linksel.length; ++i) {
            for (int j = 0; j < modsel.length; ++j) {
                if ((this.module[j] != this.link[i].from.getModule() || !modsel[j]) && (this.module[j] != this.link[i].to.getModule() || !modsel[j])) continue;
                linksel[i] = true;
            }
        }
        for (i = linksel.length - 1; i >= 0; --i) {
            if (!linksel[i]) continue;
            this.deleteLink(i);
        }
        for (i = modsel.length - 1; i >= 0; --i) {
            if (!modsel[i]) continue;
            this.deleteModule(i);
        }
    }

    public static Object mapArrayIdent(Object[] fromarr, Object fromobj, Object[] toarr) {
        int i = Utilities.findIndexIdent(fromarr, fromobj);
        if (i == -1) {
            return null;
        }
        return toarr[i];
    }

    public Procedure createModuleGroup(int[] which) {
        Procedure result = new Procedure(new OutputModule[0]);
        Vector<Link> linkdst = new Vector<Link>();
        Object[] modulesrc = new Module[which.length];
        Object[] moduledst = new Module[which.length];
        for (int m = 0; m < which.length; ++m) {
            modulesrc[m] = this.module[which[m]];
            moduledst[m] = modulesrc[m].duplicate();
            moduledst[m].clearLinks();
        }
        for (int i = 0; i < this.link.length; ++i) {
            Module toModuleDst;
            Module fromModuleSrc = this.link[i].from.getModule();
            Module toModuleSrc = this.link[i].to.getModule();
            Module fromModuleDst = (Module)Procedure.mapArrayIdent(modulesrc, fromModuleSrc, moduledst);
            if (fromModuleDst == null || (toModuleDst = (Module)Procedure.mapArrayIdent(modulesrc, toModuleSrc, moduledst)) == null) continue;
            IOPort from = (IOPort)Procedure.mapArrayIdent(fromModuleSrc.getOutputPorts(), this.link[i].from, fromModuleDst.getOutputPorts());
            IOPort to = (IOPort)Procedure.mapArrayIdent(toModuleSrc.getInputPorts(), this.link[i].to, toModuleDst.getInputPorts());
            linkdst.add(new Link(from, to));
            toModuleDst.setInput(to, from);
        }
        result.module = moduledst;
        result.link = linkdst.toArray(new Link[0]);
        return result;
    }

    public void removeForbidden(boolean allowParameters) {
        boolean[] modsel = new boolean[this.module.length];
        for (int i = 0; i < this.module.length; ++i) {
            if (!(this.module[i] instanceof ParameterModule) || allowParameters) continue;
            modsel[i] = true;
        }
        this.deleteModulesAndLinks(modsel, null);
    }

    public int insertGroup(Procedure group, boolean allowParameters) {
        int i;
        Procedure insert = new Procedure(new OutputModule[0]);
        insert.copy(group);
        insert.removeForbidden(allowParameters);
        for (i = 0; i < insert.module.length; ++i) {
            this.addModule(insert.module[i]);
        }
        for (i = 0; i < insert.link.length; ++i) {
            this.addLink(insert.link[i]);
        }
        return insert.module.length;
    }

    public Link[] getLinks() {
        return this.link;
    }

    public void addLink(Link ln) {
        Link[] newlink = new Link[this.link.length + 1];
        for (int i = 0; i < this.link.length; ++i) {
            newlink[i] = this.link[i];
        }
        newlink[this.link.length] = ln;
        this.link = newlink;
    }

    public void deleteLink(int which) {
        Link[] newlink = new Link[this.link.length - 1];
        if (this.link[which].to.getType() == 0) {
            this.link[which].to.getModule().setInput(this.link[which].to, null);
        } else {
            this.link[which].from.getModule().setInput(this.link[which].from, null);
        }
        int j = 0;
        for (int i = 0; i < this.link.length; ++i) {
            if (i == which) continue;
            newlink[j++] = this.link[i];
        }
        this.link = newlink;
    }

    public boolean checkFeedback() {
        for (int i = 0; i < this.output.length; ++i) {
            int j;
            for (j = 0; j < this.output.length; ++j) {
                this.output[j].checked = false;
            }
            for (j = 0; j < this.module.length; ++j) {
                this.module[j].checked = false;
            }
            if (!this.output[i].checkFeedback()) continue;
            return true;
        }
        return false;
    }

    public void initForPoint(PointInfo p) {
        for (int i = 0; i < this.module.length; ++i) {
            this.module[i].init(p);
        }
    }

    public double getOutputValue(int which) {
        return this.output[which].getAverageValue(0, 0.0);
    }

    public void getOutputGradient(int which, Vec3 grad) {
        this.output[which].getValueGradient(0, grad, 0.0);
    }

    public void getOutputColor(int which, RGBColor color) {
        this.output[which].getColor(0, color, 0.0);
    }

    public void copy(Procedure proc) {
        int i;
        this.module = new Module[proc.module.length];
        for (i = 0; i < this.module.length; ++i) {
            this.module[i] = proc.module[i].duplicate();
            this.module[i].clearLinks();
        }
        this.link = new Link[proc.link.length];
        for (i = 0; i < this.link.length; ++i) {
            Module fromModule = proc.link[i].from.getModule();
            Module toModule = proc.link[i].to.getModule();
            int fromIndex = proc.getModuleIndex(fromModule);
            int toIndex = toModule instanceof OutputModule ? proc.getOutputIndex(toModule) : proc.getModuleIndex(toModule);
            IOPort from = this.module[fromIndex].getOutputPorts()[proc.module[fromIndex].getOutputIndex(proc.link[i].from)];
            IOPort to = toModule instanceof OutputModule ? this.output[toIndex].getInputPorts()[proc.output[toIndex].getInputIndex(proc.link[i].to)] : this.module[toIndex].getInputPorts()[proc.module[toIndex].getInputIndex(proc.link[i].to)];
            this.link[i] = new Link(from, to);
            to.getModule().setInput(to, from);
        }
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        int i;
        out.writeShort(0);
        out.writeInt(this.module.length);
        for (i = 0; i < this.module.length; ++i) {
            out.writeUTF(this.module[i].getClass().getName());
            out.writeInt(this.module[i].getBounds().x);
            out.writeInt(this.module[i].getBounds().y);
            this.module[i].writeToStream(out, theScene);
        }
        out.writeInt(this.link.length);
        for (i = 0; i < this.link.length; ++i) {
            out.writeInt(this.getModuleIndex(this.link[i].from.getModule()));
            out.writeInt(this.link[i].from.getModule().getOutputIndex(this.link[i].from));
            if (this.link[i].to.getModule() instanceof OutputModule) {
                out.writeInt(-this.getOutputIndex(this.link[i].to.getModule()) - 1);
                continue;
            }
            out.writeInt(this.getModuleIndex(this.link[i].to.getModule()));
            out.writeInt(this.link[i].to.getModule().getInputIndex(this.link[i].to));
        }
    }

    public void readFromStream(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        int i;
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        for (i = 0; i < this.output.length; ++i) {
            this.output[i].setInput(this.output[i].getInputPorts()[0], null);
        }
        this.module = new Module[in.readInt()];
        try {
            for (i = 0; i < this.module.length; ++i) {
                String classname = in.readUTF();
                Point p = new Point(in.readInt(), in.readInt());
                Class cls = ModellingApp.getClass(classname);
                Constructor con = cls.getConstructor(class$java$awt$Point == null ? Procedure.class$("java.awt.Point") : class$java$awt$Point);
                this.module[i] = (Module)con.newInstance(p);
                this.module[i].readFromStream(in, theScene);
            }
        }
        catch (InvocationTargetException ex) {
            ex.getTargetException().printStackTrace();
            throw new IOException();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
        this.link = new Link[in.readInt()];
        for (i = 0; i < this.link.length; ++i) {
            IOPort from = this.module[in.readInt()].getOutputPorts()[in.readInt()];
            int j = in.readInt();
            IOPort to = j < 0 ? this.output[-j - 1].getInputPorts()[0] : this.module[j].getInputPorts()[in.readInt()];
            this.link[i] = new Link(from, to);
            to.getModule().setInput(to, from);
        }
    }
}

