/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.procedural;

import artofillusion.Scene;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.procedural.IOPort;
import artofillusion.procedural.PointInfo;
import buoy.widget.BFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class Module {
    protected IOPort[] input;
    protected IOPort[] output;
    public Module[] linkFrom;
    public int[] linkFromIndex;
    protected String name;
    protected Rectangle bounds;
    protected boolean checked;
    protected static final Font defaultFont = Font.decode("Serif");
    protected static final FontMetrics defaultMetrics = Toolkit.getDefaultToolkit().getFontMetrics(defaultFont);

    public Module(String name, IOPort[] input, IOPort[] output, Point position) {
        int i;
        this.name = name;
        this.input = input;
        this.output = output;
        this.linkFrom = new Module[input.length];
        this.linkFromIndex = new int[input.length];
        for (i = 0; i < input.length; ++i) {
            input[i].setModule(this);
        }
        for (i = 0; i < output.length; ++i) {
            output[i].setModule(this);
        }
        this.bounds = new Rectangle(position.x, position.y, 0, 0);
        this.layout();
    }

    public String getName() {
        return this.name;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setPosition(int x, int y) {
        this.bounds.x = x;
        this.bounds.y = y;
        this.layout();
    }

    public IOPort[] getInputPorts() {
        return this.input;
    }

    public IOPort[] getOutputPorts() {
        return this.output;
    }

    public int getInputIndex(IOPort port) {
        for (int i = 0; i < this.input.length; ++i) {
            if (this.input[i] != port) continue;
            return i;
        }
        return -1;
    }

    public int getOutputIndex(IOPort port) {
        for (int i = 0; i < this.output.length; ++i) {
            if (this.output[i] != port) continue;
            return i;
        }
        return -1;
    }

    public boolean inputConnected(int which) {
        return this.linkFrom[which] != null;
    }

    public IOPort getClickedPort(Point pos) {
        int i;
        for (i = 0; i < this.input.length; ++i) {
            if (!this.input[i].contains(pos)) continue;
            return this.input[i];
        }
        for (i = 0; i < this.output.length; ++i) {
            if (!this.output[i].contains(pos)) continue;
            return this.output[i];
        }
        return null;
    }

    public void setInput(IOPort which, IOPort port) {
        for (int i = 0; i < this.input.length; ++i) {
            if (this.input[i] != which) continue;
            if (port == null) {
                this.linkFrom[i] = null;
                return;
            }
            Module module = port.getModule();
            for (int j = 0; j < module.output.length; ++j) {
                if (module.output[j] != port) continue;
                this.linkFrom[i] = module;
                this.linkFromIndex[i] = j;
            }
        }
    }

    public void clearLinks() {
        this.linkFrom = new Module[this.input.length];
        this.linkFromIndex = new int[this.input.length];
    }

    public void calcSize() {
        this.bounds.width = defaultMetrics.stringWidth(this.name) + 20;
        this.bounds.height = defaultMetrics.getMaxAscent() + defaultMetrics.getMaxDescent() + 20;
        int numtop = 0;
        int numbottom = 0;
        int numleft = 0;
        for (int i = 0; i < this.input.length; ++i) {
            int j = this.input[i].getLocation();
            if (j == 0) {
                ++numtop;
                continue;
            }
            if (j == 1) {
                ++numbottom;
                continue;
            }
            ++numleft;
        }
        if (Math.max(numtop, numbottom) * 5 * 4 > this.bounds.width) {
            this.bounds.width = Math.max(numtop, numbottom) * 5 * 4;
        }
        if (Math.max(numleft, this.output.length) * 5 * 4 > this.bounds.height) {
            this.bounds.height = Math.max(numleft, this.output.length) * 5 * 4;
        }
    }

    public void layout() {
        int j;
        int i;
        this.calcSize();
        int numtop = 0;
        int numbottom = 0;
        int numleft = 0;
        int top = 0;
        int bottom = 0;
        int left = 0;
        for (i = 0; i < this.input.length; ++i) {
            j = this.input[i].getLocation();
            if (j == 0) {
                ++numtop;
                continue;
            }
            if (j == 1) {
                ++numbottom;
                continue;
            }
            ++numleft;
        }
        for (i = 0; i < this.input.length; ++i) {
            j = this.input[i].getLocation();
            if (j == 0) {
                this.input[i].setPosition(this.bounds.x + this.bounds.width * ++top / (numtop + 1), this.bounds.y);
                continue;
            }
            if (j == 1) {
                this.input[i].setPosition(this.bounds.x + this.bounds.width * ++bottom / (numbottom + 1), this.bounds.y + this.bounds.height);
                continue;
            }
            this.input[i].setPosition(this.bounds.x, this.bounds.y + this.bounds.height * ++left / (numleft + 1));
        }
        for (i = 0; i < this.output.length; ++i) {
            this.output[i].setPosition(this.bounds.x + this.bounds.width + 5, this.bounds.y + this.bounds.height * (i + 1) / (this.output.length + 1));
        }
    }

    public void draw(Graphics2D g) {
        int i;
        g.setColor(Color.lightGray);
        g.fill3DRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, true);
        for (i = 0; i < this.input.length; ++i) {
            this.input[i].draw(g);
        }
        for (i = 0; i < this.output.length; ++i) {
            this.output[i].draw(g);
        }
        this.drawContents(g);
    }

    protected void drawContents(Graphics2D g) {
        g.setColor(Color.black);
        g.setFont(defaultFont);
        g.drawString(this.name, this.bounds.x + (this.bounds.width - defaultMetrics.stringWidth(this.name)) / 2, this.bounds.y + this.bounds.height / 2 + defaultMetrics.getAscent() / 2);
    }

    public boolean checkFeedback() {
        if (this.checked) {
            return true;
        }
        this.checked = true;
        for (int i = 0; i < this.linkFrom.length; ++i) {
            if (this.linkFrom[i] == null || !this.linkFrom[i].checkFeedback()) continue;
            return true;
        }
        this.checked = false;
        return false;
    }

    public boolean edit(BFrame fr, Scene theScene) {
        return false;
    }

    public void init(PointInfo p) {
    }

    public double getAverageValue(int which, double blur) {
        return 0.0;
    }

    public double getValueError(int which, double blur) {
        return 0.0;
    }

    public void getValueGradient(int which, Vec3 grad, double blur) {
        grad.set(0.0, 0.0, 0.0);
    }

    public void getColor(int which, RGBColor color, double blur) {
    }

    public Module duplicate() {
        try {
            Constructor<?> con = this.getClass().getConstructor(Point.class);
            return (Module)con.newInstance(new Point(this.bounds.x, this.bounds.y));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
    }

    public void readFromStream(DataInputStream out, Scene theScene) throws IOException {
    }
}

