/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Scene;
import artofillusion.Utilities;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.math.BoundingBox;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Light;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.MouseClickedEvent;
import buoy.event.RepaintEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.CustomWidget;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class SpotLight
extends Light {
    double radius;
    double angle;
    double falloff;
    double cosangle;
    double exponent;
    static BoundingBox bounds;
    static WireframeMesh mesh;
    static final int SEGMENTS = 8;
    static /* synthetic */ Class class$buoy$event$RepaintEvent;

    public SpotLight(RGBColor theColor, float theIntensity, double theAngle, double falloffRate, double theRadius) {
        this(theColor, theIntensity, theAngle, falloffRate, theRadius, false, 0.25f);
    }

    public SpotLight(RGBColor theColor, float theIntensity, double theAngle, double falloffRate, double theRadius, boolean isAmbient, float decay) {
        this.setParameters(theColor.duplicate(), theIntensity, isAmbient, decay);
        this.setRadius(theRadius);
        this.setAngle(theAngle);
        this.setFalloff(falloffRate);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double a) {
        this.angle = a;
        this.cosangle = Math.cos(this.angle * Math.PI / 360.0);
    }

    public double getFalloff() {
        return this.falloff;
    }

    public void setFalloff(double f) {
        this.falloff = f;
        this.exponent = f * f * 128.0;
    }

    public double getAngleCosine() {
        return this.cosangle;
    }

    public double getExponent() {
        return this.exponent;
    }

    public Object3D duplicate() {
        return new SpotLight(this.color, this.intensity, this.angle, this.falloff, this.radius, this.ambient, this.decayRate);
    }

    public void copyObject(Object3D obj) {
        SpotLight lt = (SpotLight)obj;
        this.setParameters(lt.color.duplicate(), lt.intensity, lt.ambient, lt.decayRate);
        this.setRadius(lt.radius);
        this.setAngle(lt.angle);
        this.setFalloff(lt.falloff);
    }

    public BoundingBox getBounds() {
        return bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public boolean canSetTexture() {
        return false;
    }

    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    public boolean isEditable() {
        return true;
    }

    public SpotLight(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setParameters(new RGBColor(in), in.readFloat(), in.readBoolean(), in.readFloat());
        this.setRadius(in.readDouble());
        this.setAngle(in.readDouble());
        this.setFalloff(in.readDouble());
        bounds = new BoundingBox(-0.2, 0.2, -0.2, 0.2, -0.2, 0.2);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        this.color.writeToFile(out);
        out.writeFloat(this.intensity);
        out.writeBoolean(this.ambient);
        out.writeFloat(this.decayRate);
        out.writeDouble(this.radius);
        out.writeDouble(this.angle);
        out.writeDouble(this.falloff);
    }

    public void edit(EditingWindow parent, ObjectInfo info, final Runnable cb) {
        final Widget patch = this.color.getSample(50, 30);
        final ValueField intensityField = new ValueField(this.intensity, 0);
        final ValueField radiusField = new ValueField(this.radius, 1);
        final ValueField decayField = new ValueField(this.decayRate, 1);
        final ValueSlider angleSlider = new ValueSlider(0.0, 180.0, 180, this.angle);
        final ValueSlider falloffSlider = new ValueSlider(0.0, 1.0, 100, this.falloff);
        final BCheckBox ambientBox = new BCheckBox(Translate.text("Ambient"), this.ambient);
        final Preview preview = new Preview(100);
        final RGBColor oldColor = this.color.duplicate();
        final BFrame parentFrame = parent.getFrame();
        final BDialog dlg = new BDialog(parentFrame, "", true);
        FormContainer content = new FormContainer(3, 9);
        dlg.setContent(content);
        LayoutInfo labelLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        content.add(Translate.label("editSpotLightTitle"), 0, 0, 3, 1);
        content.add(Translate.label("coneAngle"), 0, 1, labelLayout);
        content.add(Translate.label("falloffRate"), 0, 2, labelLayout);
        content.add(Translate.label("Color"), 0, 3, labelLayout);
        content.add(Translate.label("Intensity"), 0, 4, labelLayout);
        content.add(Translate.label("Radius"), 0, 5, labelLayout);
        content.add(Translate.label("decayRate"), 0, 6, labelLayout);
        content.add(angleSlider, 1, 1);
        content.add(falloffSlider, 1, 2);
        content.add(patch, 1, 3);
        content.add(intensityField, 1, 4);
        content.add(radiusField, 1, 5);
        content.add(decayField, 1, 6);
        content.add(ambientBox, 1, 7);
        content.add(preview, 2, 1, 1, 7);
        RowContainer buttons = new RowContainer();
        content.add(buttons, 0, 8, 3, 1);
        BButton okButton = Translate.button("ok", new Object(){

            void processEvent() {
                SpotLight.this.setParameters(SpotLight.this.color, (float)intensityField.getValue(), ambientBox.getState(), (float)decayField.getValue());
                SpotLight.this.setRadius(radiusField.getValue());
                SpotLight.this.setAngle(angleSlider.getValue());
                SpotLight.this.setFalloff(falloffSlider.getValue());
                dlg.dispose();
                cb.run();
            }
        }, "processEvent");
        buttons.add(okButton);
        BButton cancelButton = Translate.button("cancel", new Object(){

            void processEvent() {
                SpotLight.this.color.copy(oldColor);
                dlg.dispose();
            }
        }, "processEvent");
        buttons.add(cancelButton);
        BButton applyButton = Translate.button("apply", new Object(){

            void processEvent() {
                SpotLight.this.setParameters(SpotLight.this.color, (float)intensityField.getValue(), ambientBox.getState(), (float)decayField.getValue());
                SpotLight.this.setRadius(radiusField.getValue());
                SpotLight.this.setAngle(angleSlider.getValue());
                SpotLight.this.setFalloff(falloffSlider.getValue());
                SpotLight.this.informChanged(this, "object editor");
            }
        }, "processEvent");
        buttons.add(applyButton);
        patch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(parentFrame, Translate.text("lightColor"), SpotLight.this.color);
                patch.setBackground(SpotLight.this.color.getColor());
                preview.updateImage(angleSlider.getValue(), falloffSlider.getValue());
            }
        });
        Object listener = new Object(){

            void processEvent() {
                preview.updateImage(angleSlider.getValue(), falloffSlider.getValue());
            }
        };
        angleSlider.addEventLink(ValueChangedEvent.class, listener);
        falloffSlider.addEventLink(ValueChangedEvent.class, listener);
        dlg.pack();
        UIUtilities.centerWindow(dlg);
        dlg.setVisible(true);
    }

    public Keyframe getPoseKeyframe() {
        return new SpotLightKeyframe(this.color, this.intensity, this.decayRate, this.radius, this.angle, this.falloff);
    }

    public void applyPoseKeyframe(Keyframe k) {
        SpotLightKeyframe key = (SpotLightKeyframe)k;
        this.setParameters(key.color.duplicate(), key.intensity, this.ambient, key.decayRate);
        this.setRadius(key.radius);
        this.setAngle(key.angle);
        this.setFalloff(key.falloff);
    }

    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[]{"Intensity", "Decay Rate", "Radius", "Cone Angle", "Falloff Rate"}, new double[]{this.intensity, this.decayRate, this.radius, this.angle, this.falloff}, new double[][]{{-1.7976931348623157E308, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, 180.0}, {0.0, 1.0}});
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        final SpotLightKeyframe key = (SpotLightKeyframe)k;
        final Widget patch = key.color.getSample(50, 30);
        final ValueField intensityField = new ValueField(key.intensity, 0);
        final ValueField radiusField = new ValueField(key.radius, 1);
        final ValueField decayField = new ValueField(key.decayRate, 1);
        final ValueSlider angleSlider = new ValueSlider(0.0, 180.0, 180, key.angle);
        final ValueSlider falloffSlider = new ValueSlider(0.0, 1.0, 100, key.falloff);
        final Preview preview = new Preview(100);
        final RGBColor oldColor = key.color.duplicate();
        final BFrame parentFrame = parent.getFrame();
        final BDialog dlg = new BDialog(parentFrame, "", true);
        FormContainer content = new FormContainer(3, 8);
        dlg.setContent(content);
        LayoutInfo labelLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        content.add(Translate.label("editSpotLightTitle"), 0, 0, 3, 1);
        content.add(Translate.label("coneAngle"), 0, 1, labelLayout);
        content.add(Translate.label("falloffRate"), 0, 2, labelLayout);
        content.add(Translate.label("Color"), 0, 3, labelLayout);
        content.add(Translate.label("Intensity"), 0, 4, labelLayout);
        content.add(Translate.label("Radius"), 0, 5, labelLayout);
        content.add(Translate.label("decayRate"), 0, 6, labelLayout);
        content.add(angleSlider, 1, 1);
        content.add(falloffSlider, 1, 2);
        content.add(patch, 1, 3);
        content.add(intensityField, 1, 4);
        content.add(radiusField, 1, 5);
        content.add(decayField, 1, 6);
        content.add(preview, 2, 1, 1, 6);
        RowContainer buttons = new RowContainer();
        content.add(buttons, 0, 7, 3, 1);
        BButton okButton = Translate.button("ok", new Object(){

            void processEvent() {
                key.intensity = (float)intensityField.getValue();
                key.decayRate = (float)decayField.getValue();
                key.radius = radiusField.getValue();
                key.angle = angleSlider.getValue();
                key.falloff = falloffSlider.getValue();
                dlg.dispose();
            }
        }, "processEvent");
        buttons.add(okButton);
        BButton cancelButton = Translate.button("cancel", new Object(){

            void processEvent() {
                key.color.copy(oldColor);
                dlg.dispose();
            }
        }, "processEvent");
        buttons.add(cancelButton);
        patch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(parentFrame, Translate.text("lightColor"), key.color);
                patch.setBackground(key.color.getColor());
                preview.updateImage(angleSlider.getValue(), falloffSlider.getValue());
            }
        });
        Object listener = new Object(){

            void processEvent() {
                preview.updateImage(angleSlider.getValue(), falloffSlider.getValue());
            }
        };
        angleSlider.addEventLink(ValueChangedEvent.class, listener);
        falloffSlider.addEventLink(ValueChangedEvent.class, listener);
        dlg.pack();
        UIUtilities.centerWindow(dlg);
        dlg.setVisible(true);
    }

    static {
        int i;
        double[] sine = new double[8];
        double[] cosine = new double[8];
        bounds = new BoundingBox(-0.2, 0.2, -0.2, 0.2, -0.2, 0.2);
        for (i = 0; i < 8; ++i) {
            sine[i] = Math.sin((double)i * 2.0 * Math.PI / 8.0);
            cosine[i] = Math.cos((double)i * 2.0 * Math.PI / 8.0);
        }
        Vec3[] vert = new Vec3[25];
        int[] from = new int[24];
        int[] to = new int[24];
        vert[24] = new Vec3(0.0, 0.0, -0.2);
        for (i = 0; i < 8; ++i) {
            vert[i] = new Vec3(0.075 * cosine[i], 0.075 * sine[i], -0.05);
            vert[i + 8] = new Vec3(0.1 * cosine[i], 0.1 * sine[i], 0.0);
            vert[i + 16] = new Vec3(0.2 * cosine[i], 0.2 * sine[i], 0.2);
            from[i] = 24;
            to[i] = i;
            from[i + 8] = i;
            to[i + 8] = (i + 1) % 8;
            from[i + 16] = i + 8;
            to[i + 16] = i + 16;
        }
        mesh = new WireframeMesh(vert, from, to);
    }

    private class Preview
    extends CustomWidget {
        MemoryImageSource imageSource;
        int[] pixel;
        int size;
        Image img;

        public Preview(int size) {
            this.size = size;
            this.setPreferredSize(new Dimension(size, size));
            this.pixel = new int[size * size];
            this.imageSource = new MemoryImageSource(size, size, this.pixel, 0, size);
            this.imageSource.setAnimated(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.imageSource);
            this.addEventLink(class$buoy$event$RepaintEvent == null ? (class$buoy$event$RepaintEvent = SpotLight.class$("buoy.event.RepaintEvent")) : class$buoy$event$RepaintEvent, (Object)this, "paint");
            this.updateImage(SpotLight.this.angle, SpotLight.this.falloff);
        }

        public synchronized void updateImage(double ang, double fall) {
            double center = (double)this.size / 2.0;
            double tn = Math.tan(ang * Math.PI / 360.0);
            double ex = fall * fall * 128.0;
            RGBColor col = new RGBColor(0.0f, 0.0f, 0.0f);
            for (int i = 0; i < this.size; ++i) {
                int j;
                int first = (int)Math.abs(((double)i - center) / tn);
                if (first > this.size) {
                    first = this.size;
                }
                for (j = 0; j < first; ++j) {
                    this.pixel[i * this.size + j] = -16777216;
                }
                for (j = first; j < this.size; ++j) {
                    double cs = (double)j / Math.sqrt((double)(j * j) + ((double)i - center) * ((double)i - center));
                    col.copy(SpotLight.this.color);
                    col.scale(Math.pow(cs, ex));
                    this.pixel[i * this.size + j] = col.getARGB();
                }
            }
            this.imageSource.newPixels();
            this.repaint();
        }

        private void paint(RepaintEvent ev) {
            ev.getGraphics().drawImage(this.img, 0, 0, this.getComponent());
        }
    }

    public static class SpotLightKeyframe
    extends Light.LightKeyframe {
        public double radius;
        public double angle;
        public double falloff;

        public SpotLightKeyframe(RGBColor color, float intensity, float decayRate, double radius, double angle, double falloff) {
            super(color, intensity, decayRate);
            this.radius = radius;
            this.angle = angle;
            this.falloff = falloff;
        }

        public Keyframe duplicate() {
            return new SpotLightKeyframe(this.color, this.intensity, this.decayRate, this.radius, this.angle, this.falloff);
        }

        public double[] getGraphValues() {
            return Utilities.arrayConcat(super.getGraphValues(), new double[]{this.radius, this.angle, this.falloff});
        }

        public void setGraphValues(double[] values) {
            super.setGraphValues(values);
            int shift = super.getGraphValueCount();
            this.radius = values[shift + 0];
            this.angle = values[shift + 1];
            this.falloff = values[shift + 2];
        }

        public int getGraphValueCount() {
            return super.getGraphValueCount() + 3;
        }

        protected void blendInplace(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            super.blendInplace(o2, o3, o4, weight1, weight2, weight3, weight4);
            SpotLightKeyframe k2 = (SpotLightKeyframe)o2;
            SpotLightKeyframe k3 = (SpotLightKeyframe)o3;
            SpotLightKeyframe k4 = (SpotLightKeyframe)o4;
            this.radius = weight1 * this.radius + weight2 * k2.radius;
            this.angle = weight1 * this.angle + weight2 * k2.angle;
            this.falloff = weight1 * this.falloff + weight2 * k2.falloff;
            if (k3 != null) {
                this.radius += weight3 * k3.radius;
                this.angle += weight3 * k3.angle;
                this.falloff += weight3 * k3.falloff;
                if (k4 != null) {
                    this.radius += weight4 * k4.radius;
                    this.angle += weight4 * k4.angle;
                    this.falloff += weight4 * k4.falloff;
                }
            }
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof SpotLightKeyframe)) {
                return false;
            }
            SpotLightKeyframe key = (SpotLightKeyframe)k;
            return super.equals(k) && key.radius == this.radius && key.angle == this.angle && key.falloff == this.falloff;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            this.color.writeToFile(out);
            out.writeFloat(this.intensity);
            out.writeFloat(this.decayRate);
            out.writeDouble(this.radius);
            out.writeDouble(this.angle);
            out.writeDouble(this.falloff);
        }

        public SpotLightKeyframe(DataInputStream in, Object parent) throws IOException {
            this(new RGBColor(in), in.readFloat(), in.readFloat(), in.readDouble(), in.readDouble(), in.readDouble());
        }
    }
}

