/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.VectorKeyframe;
import artofillusion.math.BoundingBox;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class Sphere
extends Object3D {
    static final int SEGMENTS = 16;
    static double[] sine = new double[16];
    static double[] cosine = new double[16];
    double rx;
    double ry;
    double rz;
    BoundingBox bounds;
    RenderingMesh cachedMesh;
    WireframeMesh cachedWire;

    public Sphere(double xradius, double yradius, double zradius) {
        this.rx = xradius;
        this.ry = yradius;
        this.rz = zradius;
        this.bounds = new BoundingBox(-this.rx, this.rx, -this.ry, this.ry, -this.rz, this.rz);
    }

    public Object3D duplicate() {
        Sphere obj = new Sphere(this.rx, this.ry, this.rz);
        obj.copyTextureAndMaterial(this);
        return obj;
    }

    public void copyObject(Object3D obj) {
        Sphere s = (Sphere)obj;
        Vec3 size = s.getBounds().getSize();
        this.setSize(size.x, size.y, size.z);
        this.copyTextureAndMaterial(obj);
        this.cachedMesh = null;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
        this.rx = xsize / 2.0;
        this.ry = ysize / 2.0;
        this.rz = zsize / 2.0;
        this.bounds = new BoundingBox(-this.rx, this.rx, -this.ry, this.ry, -this.rz, this.rz);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public Vec3 getRadii() {
        return new Vec3(this.rx, this.ry, this.rz);
    }

    public WireframeMesh getWireframeMesh() {
        if (this.cachedWire != null) {
            return this.cachedWire;
        }
        int numvert = 114;
        int numedge = 240;
        Vec3[] vert = new Vec3[numvert];
        int[] from = new int[numedge];
        int[] to = new int[numedge];
        vert[numvert - 2] = new Vec3(0.0, this.ry, 0.0);
        vert[numvert - 1] = new Vec3(0.0, -this.ry, 0.0);
        for (int i = 0; i < 16; ++i) {
            int j;
            from[i] = numvert - 2;
            to[i] = i;
            for (j = 0; j < 7; ++j) {
                vert[j * 16 + i] = new Vec3(this.rx * sine[j + 1] * cosine[i], this.ry * cosine[j + 1], this.rz * sine[j + 1] * sine[i]);
                from[2 * (j + 1) * 16 + i] = j * 16 + i;
                to[2 * (j + 1) * 16 + i] = j * 16 + (i + 1) % 16;
            }
            for (j = 0; j < 6; ++j) {
                from[(2 * j + 1) * 16 + i] = j * 16 + i;
                to[(2 * j + 1) * 16 + i] = (j + 1) * 16 + i;
            }
            from[(2 * j + 1) * 16 + i] = j * 16 + i;
            to[(2 * j + 1) * 16 + i] = numvert - 1;
        }
        this.cachedWire = new WireframeMesh(vert, from, to);
        return this.cachedWire;
    }

    public int canConvertToTriangleMesh() {
        return 2;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        int[][][] index = new int[8][][];
        Vec3[] vertices = this.subdivideSphere(index, tol);
        int size = index[0].length;
        int[][] faces = new int[8 * (size - 1) * (size - 1)][];
        int m = 0;
        for (int i = 0; i < 8; ++i) {
            int k;
            int j;
            if (i == 0 || i == 2 || i == 5 || i == 7) {
                for (j = 1; j < size; ++j) {
                    for (k = 0; k < j - 1; ++k) {
                        faces[m++] = new int[]{index[i][j - 1][k], index[i][j][k], index[i][j][k + 1]};
                        faces[m++] = new int[]{index[i][j - 1][k], index[i][j][k + 1], index[i][j - 1][k + 1]};
                    }
                    faces[m++] = new int[]{index[i][j - 1][k], index[i][j][k], index[i][j][k + 1]};
                }
                continue;
            }
            for (j = 1; j < size; ++j) {
                for (k = 0; k < j - 1; ++k) {
                    faces[m++] = new int[]{index[i][j - 1][k], index[i][j][k + 1], index[i][j][k]};
                    faces[m++] = new int[]{index[i][j - 1][k], index[i][j - 1][k + 1], index[i][j][k + 1]};
                }
                faces[m++] = new int[]{index[i][j - 1][k], index[i][j][k + 1], index[i][j][k]};
            }
        }
        TriangleMesh mesh = new TriangleMesh(vertices, (int[][])faces);
        mesh.copyTextureAndMaterial(this);
        mesh.modelevent = this.modelevent;
        return mesh;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        if (interactive && this.cachedMesh != null) {
            return this.cachedMesh;
        }
        int[][][] index = new int[8][][];
        Vec3[] vertices = this.subdivideSphere(index, tol);
        Vec3[] norm = this.findNormals(vertices);
        int size = index[0].length;
        RenderingTriangle[] tri = new RenderingTriangle[8 * (size - 1) * (size - 1)];
        int m = 0;
        for (int i = 0; i < 8; ++i) {
            int k;
            int j;
            if (i == 0 || i == 2 || i == 5 || i == 7) {
                for (j = 1; j < size; ++j) {
                    for (k = 0; k < j - 1; ++k) {
                        tri[m++] = this.texMapping.mapTriangle(index[i][j - 1][k], index[i][j][k], index[i][j][k + 1], index[i][j - 1][k], index[i][j][k], index[i][j][k + 1], vertices);
                        tri[m++] = this.texMapping.mapTriangle(index[i][j - 1][k], index[i][j][k + 1], index[i][j - 1][k + 1], index[i][j - 1][k], index[i][j][k + 1], index[i][j - 1][k + 1], vertices);
                    }
                    tri[m++] = this.texMapping.mapTriangle(index[i][j - 1][k], index[i][j][k], index[i][j][k + 1], index[i][j - 1][k], index[i][j][k], index[i][j][k + 1], vertices);
                }
                continue;
            }
            for (j = 1; j < size; ++j) {
                for (k = 0; k < j - 1; ++k) {
                    tri[m++] = this.texMapping.mapTriangle(index[i][j - 1][k], index[i][j][k + 1], index[i][j][k], index[i][j - 1][k], index[i][j][k + 1], index[i][j][k], vertices);
                    tri[m++] = this.texMapping.mapTriangle(index[i][j - 1][k], index[i][j - 1][k + 1], index[i][j][k + 1], index[i][j - 1][k], index[i][j - 1][k + 1], index[i][j][k + 1], vertices);
                }
                tri[m++] = this.texMapping.mapTriangle(index[i][j - 1][k], index[i][j][k + 1], index[i][j][k], index[i][j - 1][k], index[i][j][k + 1], index[i][j][k], vertices);
            }
        }
        RenderingMesh mesh = new RenderingMesh(vertices, norm, tri, this.texMapping, this.matMapping);
        mesh.setParameters(this.paramValue);
        if (interactive) {
            this.cachedMesh = mesh;
        }
        return mesh;
    }

    public void setTexture(Texture tex, TextureMapping mapping) {
        super.setTexture(tex, mapping);
        this.cachedMesh = null;
    }

    Vec3[] subdivideSphere(int[][][] index, double tol) {
        int j;
        int i;
        double max;
        int size = 2;
        Vec3[][] vert = new Vec3[][]{{new Vec3(this.rx, 0.0, 0.0)}, {new Vec3(0.0, this.ry, 0.0), new Vec3(0.0, 0.0, this.rz)}};
        do {
            max = 0.0;
            for (i = 1; i < size; ++i) {
                double error;
                for (j = 0; j < i - 1; ++j) {
                    error = this.faceError(vert[i - 1][j], vert[i][j], vert[i][j + 1]);
                    if (error > max) {
                        max = error;
                    }
                    if (!((error = this.faceError(vert[i - 1][j], vert[i - 1][j + 1], vert[i][j + 1])) > max)) continue;
                    max = error;
                }
                error = this.faceError(vert[i - 1][j], vert[i][j], vert[i][j + 1]);
                if (error > max) {
                    max = error;
                }
                if (max > tol) break;
            }
            if (!(max > tol)) continue;
            Vec3[][] newvert = new Vec3[2 * size - 1][];
            for (i = 0; i < 2 * size - 1; ++i) {
                newvert[i] = new Vec3[i + 1];
            }
            for (i = 0; i < size; ++i) {
                for (j = 0; j <= i; ++j) {
                    newvert[2 * i][2 * j] = vert[i][j];
                }
            }
            for (i = 1; i < size; ++i) {
                for (j = 0; j < i; ++j) {
                    newvert[2 * i][2 * j] = vert[i][j];
                    newvert[2 * i - 1][2 * j] = this.newVertex(vert[i][j].plus(vert[i - 1][j]));
                    newvert[2 * i][2 * j + 1] = this.newVertex(vert[i][j].plus(vert[i][j + 1]));
                    newvert[2 * i - 1][2 * j + 1] = this.newVertex(vert[i - 1][j].plus(vert[i][j + 1]));
                }
            }
            vert = newvert;
            size = 2 * size - 1;
        } while (max > tol);
        Vec3[] v = new Vec3[4 * size * size - 8 * size + 6];
        for (i = 0; i < 8; ++i) {
            index[i] = new int[size][];
            for (j = 0; j < size; ++j) {
                index[i][j] = new int[j + 1];
            }
        }
        int k = 0;
        for (i = 1; i < size - 1; ++i) {
            for (j = 1; j < i; ++j) {
                v[k] = vert[i][j];
                index[0][i][j] = k++;
                v[k] = new Vec3(-vert[i][j].x, vert[i][j].y, vert[i][j].z);
                index[1][i][j] = k++;
                v[k] = new Vec3(-vert[i][j].x, -vert[i][j].y, vert[i][j].z);
                index[2][i][j] = k++;
                v[k] = new Vec3(vert[i][j].x, -vert[i][j].y, vert[i][j].z);
                index[3][i][j] = k++;
                v[k] = new Vec3(vert[i][j].x, vert[i][j].y, -vert[i][j].z);
                index[4][i][j] = k++;
                v[k] = new Vec3(-vert[i][j].x, vert[i][j].y, -vert[i][j].z);
                index[5][i][j] = k++;
                v[k] = new Vec3(-vert[i][j].x, -vert[i][j].y, -vert[i][j].z);
                index[6][i][j] = k++;
                v[k] = new Vec3(vert[i][j].x, -vert[i][j].y, -vert[i][j].z);
                index[7][i][j] = k++;
            }
        }
        for (i = 1; i < size - 1; ++i) {
            v[k] = vert[i][0];
            int n = k++;
            index[4][i][0] = n;
            index[0][i][0] = n;
            v[k] = new Vec3(-vert[i][0].x, vert[i][0].y, vert[i][0].z);
            int n2 = k++;
            index[5][i][0] = n2;
            index[1][i][0] = n2;
            v[k] = new Vec3(vert[i][0].x, -vert[i][0].y, vert[i][0].z);
            int n3 = k++;
            index[7][i][0] = n3;
            index[3][i][0] = n3;
            v[k] = new Vec3(-vert[i][0].x, -vert[i][0].y, vert[i][0].z);
            int n4 = k++;
            index[6][i][0] = n4;
            index[2][i][0] = n4;
            v[k] = vert[size - 1][i];
            int n5 = k++;
            index[1][size - 1][i] = n5;
            index[0][size - 1][i] = n5;
            v[k] = new Vec3(vert[size - 1][i].x, -vert[size - 1][i].y, vert[size - 1][i].z);
            int n6 = k++;
            index[3][size - 1][i] = n6;
            index[2][size - 1][i] = n6;
            v[k] = new Vec3(vert[size - 1][i].x, vert[size - 1][i].y, -vert[size - 1][i].z);
            int n7 = k++;
            index[5][size - 1][i] = n7;
            index[4][size - 1][i] = n7;
            v[k] = new Vec3(vert[size - 1][i].x, -vert[size - 1][i].y, -vert[size - 1][i].z);
            int n8 = k++;
            index[7][size - 1][i] = n8;
            index[6][size - 1][i] = n8;
            v[k] = vert[i][i];
            int n9 = k++;
            index[3][i][i] = n9;
            index[0][i][i] = n9;
            v[k] = new Vec3(-vert[i][i].x, vert[i][i].y, vert[i][i].z);
            int n10 = k++;
            index[2][i][i] = n10;
            index[1][i][i] = n10;
            v[k] = new Vec3(vert[i][i].x, vert[i][i].y, -vert[i][i].z);
            int n11 = k++;
            index[7][i][i] = n11;
            index[4][i][i] = n11;
            v[k] = new Vec3(-vert[i][i].x, vert[i][i].y, -vert[i][i].z);
            int n12 = k++;
            index[6][i][i] = n12;
            index[5][i][i] = n12;
        }
        v[k] = vert[0][0];
        int n = k++;
        index[7][0][0] = n;
        index[4][0][0] = n;
        index[3][0][0] = n;
        index[0][0][0] = n;
        v[k] = new Vec3(-vert[0][0].x, vert[0][0].y, vert[0][0].z);
        int n13 = k++;
        index[6][0][0] = n13;
        index[5][0][0] = n13;
        index[2][0][0] = n13;
        index[1][0][0] = n13;
        v[k] = vert[size - 1][0];
        int n14 = k++;
        index[5][size - 1][0] = n14;
        index[4][size - 1][0] = n14;
        index[1][size - 1][0] = n14;
        index[0][size - 1][0] = n14;
        v[k] = new Vec3(vert[size - 1][0].x, -vert[size - 1][0].y, vert[size - 1][0].z);
        int n15 = k++;
        index[7][size - 1][0] = n15;
        index[6][size - 1][0] = n15;
        index[3][size - 1][0] = n15;
        index[2][size - 1][0] = n15;
        v[k] = vert[size - 1][size - 1];
        int n16 = k++;
        index[3][size - 1][size - 1] = n16;
        index[2][size - 1][size - 1] = n16;
        index[1][size - 1][size - 1] = n16;
        index[0][size - 1][size - 1] = n16;
        v[k] = new Vec3(vert[size - 1][size - 1].x, vert[size - 1][size - 1].y, -vert[size - 1][size - 1].z);
        int n17 = k++;
        index[7][size - 1][size - 1] = n17;
        index[6][size - 1][size - 1] = n17;
        index[5][size - 1][size - 1] = n17;
        index[4][size - 1][size - 1] = n17;
        return v;
    }

    double faceError(Vec3 v1, Vec3 v2, Vec3 v3) {
        Vec3 v = new Vec3(v1.x + v2.x + v3.x, v1.y + v2.y + v3.y, v1.z + v2.z + v3.z);
        v.normalize();
        double dist1 = Math.sqrt(1.0 / (v.x * v.x / (this.rx * this.rx) + v.y * v.y / (this.ry * this.ry) + v.z * v.z / (this.rz * this.rz)));
        Vec3 n = v2.minus(v1).cross(v3.minus(v1));
        n.normalize();
        double d = v1.dot(n);
        double dist2 = d / v.dot(n);
        return dist1 - dist2;
    }

    Vec3 newVertex(Vec3 v) {
        v.normalize();
        double dist = Math.sqrt(1.0 / (v.x * v.x / (this.rx * this.rx) + v.y * v.y / (this.ry * this.ry) + v.z * v.z / (this.rz * this.rz)));
        v.scale(dist);
        return v;
    }

    Vec3[] findNormals(Vec3[] v) {
        Vec3[] n = new Vec3[v.length];
        for (int i = 0; i < v.length; ++i) {
            n[i] = new Vec3(v[i].x / (this.rx * this.rx), v[i].y / (this.ry * this.ry), v[i].z / (this.rz * this.rz));
            n[i].normalize();
        }
        return n;
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        ValueField xField = new ValueField(this.rx, 3, 5);
        ValueField yField = new ValueField(this.ry, 3, 5);
        ValueField zField = new ValueField(this.rz, 3, 5);
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editSphereTitle"), new Widget[]{xField, yField, zField}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        this.setSize(2.0 * xField.getValue(), 2.0 * yField.getValue(), 2.0 * zField.getValue());
        cb.run();
    }

    public Sphere(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.rx = in.readDouble();
        this.ry = in.readDouble();
        this.rz = in.readDouble();
        this.bounds = new BoundingBox(-this.rx, this.rx, -this.ry, this.ry, -this.rz, this.rz);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeDouble(this.rx);
        out.writeDouble(this.ry);
        out.writeDouble(this.rz);
    }

    public Keyframe getPoseKeyframe() {
        return new VectorKeyframe(this.rx, this.ry, this.rz);
    }

    public void applyPoseKeyframe(Keyframe k) {
        VectorKeyframe key = (VectorKeyframe)k;
        this.setSize(2.0 * key.x, 2.0 * key.y, 2.0 * key.z);
    }

    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[]{"X Radius", "Y Radius", "Z Radius"}, new double[]{this.rx, this.ry, this.rz}, new double[][]{{0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}});
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        VectorKeyframe key = (VectorKeyframe)k;
        ValueField xField = new ValueField(key.x, 3, 5);
        ValueField yField = new ValueField(key.y, 3, 5);
        ValueField zField = new ValueField(key.z, 3, 5);
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editSphereTitle"), new Widget[]{xField, yField, zField}, new String[]{"X", "Y", "Z"});
        if (!dlg.clickedOk()) {
            return;
        }
        key.set(xField.getValue(), yField.getValue(), zField.getValue());
    }

    static {
        for (int i = 0; i < 16; ++i) {
            Sphere.sine[i] = Math.sin((double)i * 2.0 * Math.PI / 16.0);
            Sphere.cosine[i] = Math.cos((double)i * 2.0 * Math.PI / 16.0);
        }
    }
}

