/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Camera;
import artofillusion.CameraFilterDialog;
import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.RenderListener;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.FilterParameterTrack;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.animation.Track;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.widget.BButton;
import buoy.widget.Widget;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class SceneCamera
extends Object3D {
    private double fov;
    private double depthOfField;
    private double focalDist;
    private ImageFilter[] filter;
    private static BoundingBox bounds;
    private static WireframeMesh mesh;
    private static final int SEGMENTS = 8;

    public SceneCamera() {
        this.fov = 30.0;
        this.depthOfField = 10.0;
        this.focalDist = 20.0;
        this.filter = new ImageFilter[0];
    }

    public double getFieldOfView() {
        return this.fov;
    }

    public double getDepthOfField() {
        return this.depthOfField;
    }

    public double getFocalDistance() {
        return this.focalDist;
    }

    public ImageFilter[] getImageFilters() {
        ImageFilter[] filt = new ImageFilter[this.filter.length];
        for (int i = 0; i < this.filter.length; ++i) {
            filt[i] = this.filter[i];
        }
        return filt;
    }

    public void setImageFilters(ImageFilter[] filters) {
        this.filter = filters;
    }

    public int getComponentsForFilters() {
        int components = 0;
        for (int i = 0; i < this.filter.length; ++i) {
            components |= this.filter[i].getDesiredComponents();
        }
        return components;
    }

    public void applyImageFilters(ComplexImage image, Scene scene, CoordinateSystem coords) {
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i].filterImage(image, scene, this, coords);
        }
        image.rebuildImage();
    }

    public Object3D duplicate() {
        SceneCamera sc = new SceneCamera();
        sc.fov = this.fov;
        sc.depthOfField = this.depthOfField;
        sc.focalDist = this.focalDist;
        sc.filter = new ImageFilter[this.filter.length];
        for (int i = 0; i < this.filter.length; ++i) {
            sc.filter[i] = this.filter[i].duplicate();
        }
        return sc;
    }

    public void copyObject(Object3D obj) {
        SceneCamera sc = (SceneCamera)obj;
        this.fov = sc.fov;
        this.depthOfField = sc.depthOfField;
        this.focalDist = sc.focalDist;
        this.filter = new ImageFilter[sc.filter.length];
        for (int i = 0; i < this.filter.length; ++i) {
            this.filter[i] = sc.filter[i].duplicate();
        }
    }

    public BoundingBox getBounds() {
        return bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public boolean canSetTexture() {
        return false;
    }

    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    public Camera createCamera(int width, int height, CoordinateSystem coords) {
        Camera cam = new Camera();
        cam.setCameraCoordinates(coords.duplicate());
        cam.setSize(width, height);
        cam.setDistToScreen((double)height / 200.0 / Math.tan(this.fov * Math.PI / 360.0));
        return cam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComplexImage renderScene(Scene theScene, int width, int height, Renderer rend, CoordinateSystem cameraPos) {
        Camera cam = this.createCamera(width, height, cameraPos);
        final ComplexImage[] theImage = new ComplexImage[1];
        RenderListener rl = new RenderListener(){

            public void imageUpdated(Image image) {
            }

            public void statusChanged(String status) {
            }

            public synchronized void imageComplete(ComplexImage image) {
                theImage[0] = image;
                this.notify();
            }

            public void renderingCanceled() {
                this.notify();
            }
        };
        rend.renderScene(theScene, cam, rl, this);
        RenderListener renderListener = rl;
        synchronized (renderListener) {
            try {
                rl.wait();
            }
            catch (InterruptedException ex) {
                rend.cancelRendering(theScene);
                return null;
            }
        }
        this.applyImageFilters(theImage[0], theScene, cameraPos);
        return theImage[0];
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(final EditingWindow parent, final ObjectInfo info, Runnable cb) {
        ValueSlider fovSlider = new ValueSlider(0.0, 180.0, 90, this.fov);
        ValueField dofField = new ValueField(this.depthOfField, 3);
        ValueField fdField = new ValueField(this.focalDist, 3);
        BButton filtersButton = Translate.button("filters", new Object(){

            void processEvent() {
                new CameraFilterDialog(parent, SceneCamera.this, info.coords);
            }
        }, "processEvent");
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editCameraTitle"), new Widget[]{fovSlider, dofField, fdField, filtersButton}, new String[]{Translate.text("fieldOfView"), Translate.text("depthOfField"), Translate.text("focalDist"), null});
        if (dlg.clickedOk()) {
            this.fov = fovSlider.getValue();
            this.depthOfField = dofField.getValue();
            this.focalDist = fdField.getValue();
        }
        Scene sc = parent.getScene();
        for (int i = 0; i < sc.getNumObjects(); ++i) {
            if (sc.getObject((int)i).object != this) continue;
            ObjectInfo obj = sc.getObject(i);
            for (int j = 0; j < obj.tracks.length; ++j) {
                if (!(obj.tracks[j] instanceof PoseTrack)) continue;
                PoseTrack pose = (PoseTrack)obj.tracks[j];
                Track[] old = pose.getSubtracks();
                Track[] newtracks = new Track[this.filter.length];
                for (int k = 0; k < this.filter.length; ++k) {
                    Track existing = null;
                    for (int m = 0; m < old.length && existing == null; ++m) {
                        if (!(old[m] instanceof FilterParameterTrack) || ((FilterParameterTrack)old[m]).getFilter() != this.filter[k]) continue;
                        existing = old[m];
                    }
                    if (existing == null) {
                        existing = new FilterParameterTrack(pose, this.filter[k]);
                    }
                    newtracks[k] = existing;
                }
                pose.setSubtracks(newtracks);
            }
        }
        if (parent instanceof LayoutWindow) {
            ((LayoutWindow)parent).getScore().rebuildList();
        }
        cb.run();
    }

    public SceneCamera(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version < 0 || version > 1) {
            throw new InvalidObjectException("");
        }
        this.fov = in.readDouble();
        this.depthOfField = in.readDouble();
        this.focalDist = in.readDouble();
        if (version == 0) {
            this.filter = new ImageFilter[0];
        } else {
            this.filter = new ImageFilter[in.readInt()];
            try {
                for (int i = 0; i < this.filter.length; ++i) {
                    Class cls = ModellingApp.getClass(in.readUTF());
                    this.filter[i] = (ImageFilter)cls.newInstance();
                    this.filter[i].initFromStream(in, theScene);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException();
            }
        }
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(1);
        out.writeDouble(this.fov);
        out.writeDouble(this.depthOfField);
        out.writeDouble(this.focalDist);
        out.writeInt(this.filter.length);
        for (int i = 0; i < this.filter.length; ++i) {
            out.writeUTF(this.filter[i].getClass().getName());
            this.filter[i].writeToStream(out, theScene);
        }
    }

    public Keyframe getPoseKeyframe() {
        return new CameraKeyframe(this.fov, this.depthOfField, this.focalDist);
    }

    public void applyPoseKeyframe(Keyframe k) {
        CameraKeyframe key = (CameraKeyframe)k;
        this.fov = key.fov;
        this.depthOfField = key.depthOfField;
        this.focalDist = key.focalDist;
    }

    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[]{"Field of View", "Depth of Field", "Focal Distance"}, new double[]{this.fov, this.depthOfField, this.focalDist}, new double[][]{{0.0, 180.0}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}});
        Track[] subtrack = new FilterParameterTrack[this.filter.length];
        for (int i = 0; i < subtrack.length; ++i) {
            subtrack[i] = new FilterParameterTrack(track, this.filter[i]);
        }
        track.setSubtracks(subtrack);
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        CameraKeyframe key = (CameraKeyframe)k;
        ValueSlider fovSlider = new ValueSlider(0.0, 180.0, 90, key.fov);
        ValueField dofField = new ValueField(key.depthOfField, 3);
        ValueField fdField = new ValueField(key.focalDist, 3);
        ComponentsDialog dlg = new ComponentsDialog(parent.getFrame(), Translate.text("editCameraTitle"), new Widget[]{fovSlider, dofField, fdField}, new String[]{Translate.text("fieldOfView"), Translate.text("depthOfField"), Translate.text("focalDist")});
        if (!dlg.clickedOk()) {
            return;
        }
        key.fov = fovSlider.getValue();
        key.depthOfField = dofField.getValue();
        key.focalDist = fdField.getValue();
    }

    static {
        int i;
        int index = 0;
        bounds = new BoundingBox(-0.25, 0.25, -0.15, 0.2, -0.2, 0.2);
        double[] sine = new double[8];
        double[] cosine = new double[8];
        for (i = 0; i < 8; ++i) {
            sine[i] = Math.sin((double)i * 2.0 * Math.PI / 8.0);
            cosine[i] = Math.cos((double)i * 2.0 * Math.PI / 8.0);
        }
        Vec3[] vert = new Vec3[40];
        int[] from = new int[58];
        int[] to = new int[58];
        vert[0] = new Vec3(-0.25, -0.15, -0.2);
        vert[1] = new Vec3(0.25, -0.15, -0.2);
        vert[2] = new Vec3(0.25, 0.15, -0.2);
        vert[3] = new Vec3(-0.25, 0.15, -0.2);
        vert[4] = new Vec3(-0.25, -0.15, 0.0);
        vert[5] = new Vec3(0.25, -0.15, 0.0);
        vert[6] = new Vec3(0.25, 0.15, 0.0);
        vert[7] = new Vec3(-0.25, 0.15, 0.0);
        int[] f = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 0, 1, 2, 3};
        int[] t = new int[]{1, 2, 3, 0, 5, 6, 7, 4, 4, 5, 6, 7};
        i = 0;
        while (i < f.length) {
            from[index] = f[i];
            to[index] = t[i];
            ++i;
            ++index;
        }
        vert[8] = new Vec3(-0.25, 0.15, -0.15);
        vert[9] = new Vec3(-0.2, 0.15, -0.15);
        vert[10] = new Vec3(-0.2, 0.2, -0.15);
        vert[11] = new Vec3(-0.25, 0.2, -0.15);
        vert[12] = new Vec3(-0.25, 0.15, -0.1);
        vert[13] = new Vec3(-0.2, 0.15, -0.1);
        vert[14] = new Vec3(-0.2, 0.2, -0.1);
        vert[15] = new Vec3(-0.25, 0.2, -0.1);
        i = 0;
        while (i < f.length) {
            from[index] = f[i] + 8;
            to[index] = t[i] + 8;
            ++i;
            ++index;
        }
        vert[16] = new Vec3(-0.2, 0.15, 0.0);
        vert[17] = new Vec3(-0.05, 0.2, 0.0);
        vert[18] = new Vec3(0.05, 0.2, 0.0);
        vert[19] = new Vec3(0.2, 0.15, 0.0);
        vert[20] = new Vec3(0.2, 0.15, -0.2);
        vert[21] = new Vec3(0.05, 0.2, -0.2);
        vert[22] = new Vec3(-0.05, 0.2, -0.2);
        vert[23] = new Vec3(-0.2, 0.15, -0.2);
        f = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 17, 18};
        t = new int[]{17, 18, 19, 20, 21, 22, 23, 16, 22, 21};
        i = 0;
        while (i < f.length) {
            from[index] = f[i];
            to[index] = t[i];
            ++i;
            ++index;
        }
        i = 0;
        while (i < 8) {
            vert[24 + i] = new Vec3(0.1 * cosine[i], 0.1 * sine[i], 0.0);
            vert[24 + i + 8] = new Vec3(0.1 * cosine[i], 0.1 * sine[i], 0.2);
            from[index] = 24 + i;
            to[index] = 24 + (i + 1) % 8;
            from[index + 8] = 24 + i;
            to[index + 8] = 24 + i + 8;
            from[index + 16] = 24 + i + 8;
            to[index + 16] = 24 + (i + 1) % 8 + 8;
            ++i;
            ++index;
        }
        mesh = new WireframeMesh(vert, from, to);
    }

    public static class CameraKeyframe
    implements Keyframe {
        public double fov;
        public double depthOfField;
        public double focalDist;

        public CameraKeyframe(double fov, double depthOfField, double focalDist) {
            this.fov = fov;
            this.depthOfField = depthOfField;
            this.focalDist = focalDist;
        }

        public Keyframe duplicate() {
            return new CameraKeyframe(this.fov, this.depthOfField, this.focalDist);
        }

        public Keyframe duplicate(Object owner) {
            return new CameraKeyframe(this.fov, this.depthOfField, this.focalDist);
        }

        public double[] getGraphValues() {
            return new double[]{this.fov, this.depthOfField, this.focalDist};
        }

        public void setGraphValues(double[] values) {
            this.fov = values[0];
            this.depthOfField = values[1];
            this.focalDist = values[2];
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            CameraKeyframe k2 = (CameraKeyframe)o2;
            return new CameraKeyframe(weight1 * this.fov + weight2 * k2.fov, weight1 * this.depthOfField + weight2 * k2.depthOfField, weight1 * this.focalDist + weight2 * k2.focalDist);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            CameraKeyframe k2 = (CameraKeyframe)o2;
            CameraKeyframe k3 = (CameraKeyframe)o3;
            return new CameraKeyframe(weight1 * this.fov + weight2 * k2.fov + weight3 * k3.fov, weight1 * this.depthOfField + weight2 * k2.depthOfField + weight3 * k3.depthOfField, weight1 * this.focalDist + weight2 * k2.focalDist + weight3 * k3.focalDist);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            CameraKeyframe k2 = (CameraKeyframe)o2;
            CameraKeyframe k3 = (CameraKeyframe)o3;
            CameraKeyframe k4 = (CameraKeyframe)o4;
            return new CameraKeyframe(weight1 * this.fov + weight2 * k2.fov + weight3 * k3.fov + weight4 * k4.fov, weight1 * this.depthOfField + weight2 * k2.depthOfField + weight3 * k3.depthOfField + weight4 * k4.depthOfField, weight1 * this.focalDist + weight2 * k2.focalDist + weight3 * k3.focalDist + weight4 * k4.focalDist);
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof CameraKeyframe)) {
                return false;
            }
            CameraKeyframe key = (CameraKeyframe)k;
            return key.fov == this.fov && key.depthOfField == this.depthOfField && key.focalDist == this.focalDist;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            out.writeDouble(this.fov);
            out.writeDouble(this.depthOfField);
            out.writeDouble(this.focalDist);
        }

        public CameraKeyframe(DataInputStream in, Object parent) throws IOException {
            this(in.readDouble(), in.readDouble(), in.readDouble());
        }
    }
}

