/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Scene;
import artofillusion.Utilities;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.PoseTrack;
import artofillusion.math.BoundingBox;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Light;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.event.MouseClickedEvent;
import buoy.widget.BButton;
import buoy.widget.BCheckBox;
import buoy.widget.BFrame;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class PointLight
extends Light {
    double radius;
    static BoundingBox bounds;
    static WireframeMesh mesh;

    public PointLight(RGBColor theColor, float theIntensity, double theRadius) {
        this(theColor, theIntensity, theRadius, false, 0.25f);
    }

    public PointLight(RGBColor theColor, float theIntensity, double theRadius, boolean isAmbient, float decay) {
        this.setParameters(theColor.duplicate(), theIntensity, isAmbient, decay);
        this.setRadius(theRadius);
        bounds = new BoundingBox(-0.25, 0.25, -0.25, 0.25, -0.25, 0.25);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double r) {
        this.radius = r;
    }

    public Object3D duplicate() {
        return new PointLight(this.color, this.intensity, this.radius, this.ambient, this.decayRate);
    }

    public void copyObject(Object3D obj) {
        PointLight lt = (PointLight)obj;
        this.setParameters(lt.color.duplicate(), lt.intensity, lt.ambient, lt.decayRate);
        this.setRadius(lt.radius);
    }

    public BoundingBox getBounds() {
        return bounds;
    }

    public void setSize(double xsize, double ysize, double zsize) {
    }

    public boolean canSetTexture() {
        return false;
    }

    public WireframeMesh getWireframeMesh() {
        return mesh;
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        final Widget patch = this.color.getSample(50, 30);
        final ValueField intensityField = new ValueField(this.intensity, 0);
        final ValueField radiusField = new ValueField(this.radius, 1);
        final ValueField decayField = new ValueField(this.decayRate, 1);
        final BCheckBox ambientBox = new BCheckBox(Translate.text("Ambient"), this.ambient);
        RGBColor oldColor = this.color.duplicate();
        final BFrame parentFrame = parent.getFrame();
        patch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(parentFrame, Translate.text("lightColor"), PointLight.this.color);
                patch.setBackground(PointLight.this.color.getColor());
            }
        });
        BButton applyButton = Translate.button("apply", new Object(){

            void processEvent() {
                PointLight.this.setParameters(PointLight.this.color, (float)intensityField.getValue(), ambientBox.getState(), (float)decayField.getValue());
                PointLight.this.setRadius(radiusField.getValue());
                PointLight.this.informChanged(this, "object editor");
            }
        }, "processEvent");
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, Translate.text("editPointLightTitle"), new Widget[]{patch, intensityField, radiusField, decayField, ambientBox, applyButton}, new String[]{Translate.text("Color"), Translate.text("Intensity"), Translate.text("Radius"), Translate.text("decayRate"), null, null});
        if (!dlg.clickedOk()) {
            this.color.copy(oldColor);
            return;
        }
        this.setParameters(this.color, (float)intensityField.getValue(), ambientBox.getState(), (float)decayField.getValue());
        this.setRadius(radiusField.getValue());
        cb.run();
    }

    public PointLight(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.setParameters(new RGBColor(in), in.readFloat(), in.readBoolean(), in.readFloat());
        this.setRadius(in.readDouble());
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        this.color.writeToFile(out);
        out.writeFloat(this.intensity);
        out.writeBoolean(this.ambient);
        out.writeFloat(this.decayRate);
        out.writeDouble(this.radius);
    }

    public Keyframe getPoseKeyframe() {
        return new PointLightKeyframe(this.color, this.intensity, this.decayRate, this.radius);
    }

    public void applyPoseKeyframe(Keyframe k) {
        PointLightKeyframe key = (PointLightKeyframe)k;
        this.setParameters(key.color.duplicate(), key.intensity, this.ambient, key.decayRate);
        this.setRadius(key.radius);
    }

    public void configurePoseTrack(PoseTrack track) {
        track.setGraphableValues(new String[]{"Intensity", "Decay Rate", "Radius"}, new double[]{this.intensity, this.decayRate, this.radius}, new double[][]{{-1.7976931348623157E308, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}, {0.0, Double.MAX_VALUE}});
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
        final PointLightKeyframe key = (PointLightKeyframe)k;
        final Widget patch = key.color.getSample(50, 30);
        ValueField intensityField = new ValueField(key.intensity, 0);
        ValueField radiusField = new ValueField(key.radius, 1);
        ValueField decayField = new ValueField(key.decayRate, 1);
        RGBColor oldColor = key.color.duplicate();
        final BFrame parentFrame = parent.getFrame();
        patch.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(parentFrame, Translate.text("lightColor"), key.color);
                patch.setBackground(key.color.getColor());
            }
        });
        ComponentsDialog dlg = new ComponentsDialog(parentFrame, Translate.text("editPointLightTitle"), new Widget[]{patch, intensityField, radiusField, decayField}, new String[]{Translate.text("Color"), Translate.text("Intensity"), Translate.text("Radius"), Translate.text("decayRate")});
        if (!dlg.clickedOk()) {
            key.color.copy(oldColor);
            return;
        }
        key.intensity = (float)intensityField.getValue();
        key.decayRate = (float)decayField.getValue();
        key.radius = radiusField.getValue();
    }

    static {
        double r1 = 0.05;
        double r2 = 0.25;
        bounds = new BoundingBox(-0.25, 0.25, -0.25, 0.25, -0.25, 0.25);
        Vec3[] vert = new Vec3[28];
        int[] from = new int[14];
        int[] to = new int[14];
        vert[0] = new Vec3(r1, 0.0, 0.0);
        vert[1] = new Vec3(r2, 0.0, 0.0);
        from[0] = 0;
        to[0] = 1;
        vert[2] = new Vec3(-r1, 0.0, 0.0);
        vert[3] = new Vec3(-r2, 0.0, 0.0);
        from[1] = 2;
        to[1] = 3;
        vert[4] = new Vec3(0.0, r1, 0.0);
        vert[5] = new Vec3(0.0, r2, 0.0);
        from[2] = 4;
        to[2] = 5;
        vert[6] = new Vec3(0.0, -r1, 0.0);
        vert[7] = new Vec3(0.0, -r2, 0.0);
        from[3] = 6;
        to[3] = 7;
        vert[8] = new Vec3(0.0, 0.0, r1);
        vert[9] = new Vec3(0.0, 0.0, r2);
        from[4] = 8;
        to[4] = 9;
        vert[10] = new Vec3(0.0, 0.0, -r1);
        vert[11] = new Vec3(0.0, 0.0, -r2);
        from[5] = 10;
        to[5] = 11;
        r1 *= 0.57735;
        r2 *= 0.57735;
        int ind1 = 12;
        int ind2 = 6;
        for (double i = -1.0; i < 2.0; i += 2.0) {
            for (double j = -1.0; j < 2.0; j += 2.0) {
                for (double k = -1.0; k < 2.0; k += 2.0) {
                    vert[ind1++] = new Vec3(r1 * i, r1 * j, r1 * k);
                    vert[ind1++] = new Vec3(r2 * i, r2 * j, r2 * k);
                    from[ind2] = ind1 - 2;
                    to[ind2++] = ind1 - 1;
                }
            }
        }
        mesh = new WireframeMesh(vert, from, to);
    }

    public static class PointLightKeyframe
    extends Light.LightKeyframe {
        public double radius;

        public PointLightKeyframe(RGBColor color, float intensity, float decayRate, double radius) {
            super(color, intensity, decayRate);
            this.radius = radius;
        }

        public Keyframe duplicate() {
            return new PointLightKeyframe(this.color, this.intensity, this.decayRate, this.radius);
        }

        public double[] getGraphValues() {
            return Utilities.arrayConcat(super.getGraphValues(), new double[]{this.radius});
        }

        public void setGraphValues(double[] values) {
            super.setGraphValues(values);
            int shift = super.getGraphValueCount();
            this.radius = values[shift + 0];
        }

        public int getGraphValueCount() {
            return super.getGraphValueCount() + 1;
        }

        protected void blendInplace(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            super.blendInplace(o2, o3, o4, weight1, weight2, weight3, weight4);
            PointLightKeyframe k2 = (PointLightKeyframe)o2;
            PointLightKeyframe k3 = (PointLightKeyframe)o3;
            PointLightKeyframe k4 = (PointLightKeyframe)o4;
            this.radius = weight1 * this.radius + weight2 * k2.radius;
            if (k3 != null) {
                this.radius += weight3 * k3.radius;
                if (k4 != null) {
                    this.radius += weight4 * k4.radius;
                }
            }
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof PointLightKeyframe)) {
                return false;
            }
            PointLightKeyframe key = (PointLightKeyframe)k;
            return super.equals(k) && key.radius == this.radius;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            this.color.writeToFile(out);
            out.writeFloat(this.intensity);
            out.writeFloat(this.decayRate);
            out.writeDouble(this.radius);
        }

        public PointLightKeyframe(DataInputStream in, Object parent) throws IOException {
            this(new RGBColor(in), in.readFloat(), in.readFloat(), in.readDouble());
        }
    }
}

