/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Camera;
import artofillusion.ModellingApp;
import artofillusion.RenderingMesh;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.Skeleton;
import artofillusion.animation.TextureTrack;
import artofillusion.animation.Track;
import artofillusion.animation.distortion.Distortion;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectWrapper;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import java.awt.Graphics;

public class ObjectInfo {
    public Object3D object;
    public CoordinateSystem coords;
    public String name;
    public boolean visible;
    public boolean selected;
    public boolean parentSelected;
    public ObjectInfo parent;
    public ObjectInfo[] children;
    public Track[] tracks;
    public Keyframe pose;
    public int id;
    private Distortion distortion;
    private Distortion prevDistortion;
    private RenderingMesh cachedMesh;
    private WireframeMesh cachedWire;
    private BoundingBox cachedBounds;
    private boolean lastPreviewWasWireframe;

    public ObjectInfo(Object3D obj, CoordinateSystem c, String name) {
        this.object = obj;
        this.coords = c;
        this.name = name;
        this.visible = true;
        this.children = new ObjectInfo[0];
        this.id = -1;
    }

    public ObjectInfo duplicate() {
        return this.duplicate(this.object);
    }

    public ObjectInfo duplicateDeep() {
        return this.duplicate(this.object.duplicate());
    }

    public ObjectInfo duplicate(Object3D obj) {
        ObjectInfo info = new ObjectInfo(obj, this.coords.duplicate(), this.name);
        info.visible = this.visible;
        info.id = this.id;
        if (this.tracks != null) {
            info.tracks = new Track[this.tracks.length];
            for (int i = 0; i < this.tracks.length; ++i) {
                info.tracks[i] = this.tracks[i].duplicate(info);
            }
        }
        if (this.distortion != null) {
            info.distortion = this.distortion.duplicate();
        }
        return info;
    }

    public static ObjectInfo[] duplicateAll(ObjectInfo[] info) {
        int i;
        ObjectInfo[] newobj = new ObjectInfo[info.length];
        for (i = 0; i < newobj.length; ++i) {
            newobj[i] = info[i].duplicate(info[i].object.duplicate());
        }
        for (i = 0; i < info.length; ++i) {
            for (int k = info[i].children.length - 1; k >= 0; --k) {
                int j;
                for (j = 0; j < info.length && info[j] != info[i].children[k]; ++j) {
                }
                if (j >= info.length) continue;
                newobj[i].addChild(newobj[j], 0);
            }
        }
        return newobj;
    }

    public void copyInfoWithoutObject(ObjectInfo info) {
        this.coords.copyCoords(info.coords);
        this.name = info.name.toString();
        this.visible = info.visible;
        this.id = info.id;
        this.cachedMesh = info.cachedMesh;
        this.cachedWire = info.cachedWire;
        this.cachedBounds = info.cachedBounds;
        if (info.tracks == null) {
            this.tracks = null;
        } else {
            this.tracks = new Track[info.tracks.length];
            for (int i = 0; i < this.tracks.length; ++i) {
                this.tracks[i] = info.tracks[i].duplicate(this);
            }
        }
        if (info.distortion != null) {
            this.distortion = info.distortion.duplicate();
        }
        if (info.prevDistortion != null) {
            this.prevDistortion = info.prevDistortion.duplicate();
        }
    }

    public void copyInfo(ObjectInfo info) {
        this.object = info.object;
        this.copyInfoWithoutObject(info);
    }

    public void copyInfoDeep(ObjectInfo info) {
        this.object.copyObject(info.object);
        this.copyInfoWithoutObject(info);
    }

    public Object3D getObject3D() {
        return this.object;
    }

    public void addChild(ObjectInfo info, int position) {
        int i;
        ObjectInfo[] newChildren = new ObjectInfo[this.children.length + 1];
        for (i = 0; i < position; ++i) {
            newChildren[i] = this.children[i];
        }
        newChildren[position] = info;
        while (i < this.children.length) {
            newChildren[i + 1] = this.children[i];
            ++i;
        }
        this.children = newChildren;
        info.parent = this;
    }

    public void removeChild(ObjectInfo info) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != info) continue;
            this.removeChild(i);
            return;
        }
    }

    public void removeChild(int which) {
        int i;
        ObjectInfo[] newChildren = new ObjectInfo[this.children.length - 1];
        this.children[which].parent = null;
        for (i = 0; i < which; ++i) {
            newChildren[i] = this.children[i];
        }
        ++i;
        while (i < this.children.length) {
            newChildren[i - 1] = this.children[i];
            ++i;
        }
        this.children = newChildren;
    }

    public void addTrack(Track tr, int position) {
        int i;
        if (this.tracks == null) {
            this.tracks = new Track[]{tr};
            return;
        }
        Track[] newTracks = new Track[this.tracks.length + 1];
        for (i = 0; i < position; ++i) {
            newTracks[i] = this.tracks[i];
        }
        newTracks[position] = tr;
        while (i < this.tracks.length) {
            newTracks[i + 1] = this.tracks[i];
            ++i;
        }
        this.tracks = newTracks;
    }

    public void removeTrack(Track tr) {
        for (int i = 0; i < this.tracks.length; ++i) {
            if (this.tracks[i] != tr) continue;
            this.removeTrack(i);
            return;
        }
    }

    public void removeTrack(int which) {
        int i;
        Track[] newTracks = new Track[this.tracks.length - 1];
        for (i = 0; i < which; ++i) {
            newTracks[i] = this.tracks[i];
        }
        ++i;
        while (i < this.tracks.length) {
            newTracks[i - 1] = this.tracks[i];
            ++i;
        }
        this.tracks = newTracks;
    }

    public void setTexture(Texture tex, TextureMapping map) {
        this.object.setTexture(tex, map);
        this.clearCachedMeshes();
        if (this.tracks != null) {
            for (int i = 0; i < this.tracks.length; ++i) {
                if (!(this.tracks[i] instanceof TextureTrack)) continue;
                ((TextureTrack)this.tracks[i]).parametersChanged();
            }
        }
    }

    public void setMaterial(Material mat, MaterialMapping map) {
        this.object.setMaterial(mat, map);
    }

    public void clearDistortion() {
        this.distortion = null;
    }

    public void addDistortion(Distortion d) {
        d.setPreviousDistortion(this.distortion);
        this.distortion = d;
    }

    public boolean isDistorted() {
        return this.distortion != null;
    }

    private void checkDistortionChanged() {
        if (this.prevDistortion == this.distortion || this.distortion != null && this.distortion.isIdenticalTo(this.prevDistortion)) {
            return;
        }
        this.prevDistortion = this.distortion;
        this.clearCachedMeshes();
    }

    public Object3D getDistortedObject(double tol) {
        if (this.distortion == null) {
            return this.object;
        }
        Object3D obj = this.object;
        while (obj instanceof ObjectWrapper) {
            obj = ((ObjectWrapper)obj).getWrappedObject();
        }
        if (!(obj instanceof Mesh) && this.object.canConvertToTriangleMesh() != 0) {
            obj = obj.convertToTriangleMesh(tol);
        }
        if (obj instanceof Mesh) {
            obj = (Object3D)((Object)this.distortion.transform((Mesh)((Object)obj)));
        }
        return obj;
    }

    public RenderingMesh getRenderingMesh(double tol) {
        return this.getDistortedObject(tol).getRenderingMesh(tol, false, this);
    }

    public RenderingMesh getPreviewMesh() {
        this.checkDistortionChanged();
        if (this.cachedMesh == null) {
            if (this.pose != null && !this.pose.equals(this.object.getPoseKeyframe())) {
                this.object.applyPoseKeyframe(this.pose);
            }
            double tol = ModellingApp.getPreferences().getInteractiveSurfaceError();
            Object3D obj = this.getDistortedObject(tol);
            this.cachedMesh = obj.getRenderingMesh(tol, true, this);
            if (this.cachedBounds == null) {
                this.cachedBounds = obj.getBounds();
            }
        }
        this.lastPreviewWasWireframe = false;
        return this.cachedMesh;
    }

    public WireframeMesh getWireframePreview() {
        this.checkDistortionChanged();
        if (this.cachedWire == null) {
            if (this.pose != null && !this.pose.equals(this.object.getPoseKeyframe())) {
                this.object.applyPoseKeyframe(this.pose);
            }
            double tol = ModellingApp.getPreferences().getInteractiveSurfaceError();
            Object3D obj = this.getDistortedObject(tol);
            this.cachedWire = obj.getWireframeMesh();
            if (this.cachedBounds == null) {
                this.cachedBounds = obj.getBounds();
            }
        }
        this.lastPreviewWasWireframe = true;
        return this.cachedWire;
    }

    public BoundingBox getBounds() {
        this.checkDistortionChanged();
        if (this.cachedBounds == null) {
            if (this.pose != null && !this.pose.equals(this.object.getPoseKeyframe())) {
                this.object.applyPoseKeyframe(this.pose);
            }
            double tol = ModellingApp.getPreferences().getInteractiveSurfaceError();
            Object3D obj = this.getDistortedObject(tol);
            this.cachedBounds = obj.getBounds();
            if (this.lastPreviewWasWireframe && this.cachedWire == null && !(this.object instanceof ObjectCollection)) {
                this.cachedWire = obj.getWireframeMesh();
            } else if (!this.lastPreviewWasWireframe && this.cachedMesh == null && !(this.object instanceof ObjectCollection)) {
                this.cachedMesh = obj.getRenderingMesh(tol, true, this);
            }
        }
        return this.cachedBounds;
    }

    public void clearCachedMeshes() {
        this.cachedMesh = null;
        this.cachedWire = null;
        this.cachedBounds = null;
    }

    public Skeleton getSkeleton() {
        return this.object.getSkeleton();
    }

    public CoordinateSystem getCoordinates() {
        return this.coords;
    }

    public void setCoordinates(CoordinateSystem c) {
        this.coords = c;
    }

    public void draw(Graphics g, Camera cam) {
        Object3D.draw(g, cam, this.getWireframePreview(), this.getBounds());
    }
}

