/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.SceneRenderInfoProvider;
import artofillusion.WireframeMesh;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ObjectCollection
extends Object3D {
    protected Vector cachedObjects;
    protected BoundingBox cachedBounds;
    protected double lastTime;
    protected CoordinateSystem lastCoords;
    protected Scene lastScene;
    protected boolean usesTime;
    protected boolean usesCoords;

    public ObjectCollection() {
    }

    public ObjectCollection(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
    }

    public synchronized Enumeration getObjects(ObjectInfo info, boolean interactive, SceneRenderInfoProvider sceneinfo) {
        if (!interactive) {
            if (sceneinfo instanceof Scene) {
                return this.enumerateObjects(info, interactive, (Scene)sceneinfo);
            }
            return this.enumerateObjects(info, interactive, sceneinfo);
        }
        if (this.cachedObjects == null) {
            this.cachedObjects = new Vector();
            Enumeration objenum = null;
            objenum = sceneinfo instanceof Scene ? this.enumerateObjects(info, interactive, (Scene)sceneinfo) : this.enumerateObjects(info, interactive, sceneinfo);
            while (objenum.hasMoreElements()) {
                this.cachedObjects.addElement(objenum.nextElement());
            }
        }
        return this.cachedObjects.elements();
    }

    protected abstract Enumeration enumerateObjects(ObjectInfo var1, boolean var2, SceneRenderInfoProvider var3);

    protected synchronized Enumeration enumerateObjects(ObjectInfo info, boolean interactive, Scene scene) {
        return this.enumerateObjects(info, interactive, (SceneRenderInfoProvider)scene);
    }

    public BoundingBox getBounds() {
        return this.cachedBounds;
    }

    public void setUsesTime(boolean b) {
        this.usesTime = b;
    }

    public void setUsesCoords(boolean b) {
        this.usesCoords = b;
    }

    public boolean isClosed() {
        for (int i = 0; i < this.cachedObjects.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.cachedObjects.elementAt(i);
            if (info.object.isClosed()) continue;
            return false;
        }
        return true;
    }

    public boolean canSetMaterial() {
        return true;
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        return this.convertToTriangleMesh(tol).getRenderingMesh(tol, interactive, info);
    }

    public WireframeMesh getWireframeMesh() {
        return new WireframeMesh(new Vec3[0], new int[0], new int[0]);
    }

    public int canConvertToTriangleMesh() {
        return 2;
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        Vector<Vec3> allVert = new Vector<Vec3>();
        Vector<int[]> allFace = new Vector<int[]>();
        int start = 0;
        Enumeration enumeration = this.getObjects(new ObjectInfo(this, this.lastCoords, ""), false, this.lastScene);
        while (enumeration.hasMoreElements()) {
            ObjectInfo obj = (ObjectInfo)enumeration.nextElement();
            if (obj.object.canConvertToTriangleMesh() == 0) continue;
            Mat4 trans = obj.coords.fromLocal();
            TriangleMesh tri = obj.object.convertToTriangleMesh(tol);
            MeshVertex[] vert = tri.getVertices();
            for (int i = 0; i < vert.length; ++i) {
                allVert.addElement(trans.times(vert[i].r));
            }
            TriangleMesh.Face[] face = tri.getFaces();
            for (int i = 0; i < face.length; ++i) {
                allFace.addElement(new int[]{face[i].v1 + start, face[i].v2 + start, face[i].v3 + start});
            }
            start += vert.length;
        }
        if (allVert.size() == 0) {
            allVert.addElement(new Vec3());
        }
        Object[] vert = new Vec3[allVert.size()];
        allVert.copyInto(vert);
        int[][] face = new int[allFace.size()][];
        allFace.copyInto((Object[])face);
        TriangleMesh mesh = new TriangleMesh((Vec3[])vert, (int[][])face);
        mesh.copyTextureAndMaterial(this);
        mesh.copyModelEvent(this);
        return mesh;
    }

    public void sceneChanged(ObjectInfo info, Scene scene) {
        if (this.cachedBounds == null || this.usesTime && this.lastTime != scene.getTime() || this.usesCoords && !this.lastCoords.equals(info.coords)) {
            this.lastScene = scene;
            this.lastTime = scene.getTime();
            this.lastCoords = info.coords.duplicate();
            this.cachedObjects = null;
            Enumeration enumeration = this.getObjects(info, true, scene);
            if (!enumeration.hasMoreElements()) {
                this.cachedBounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            } else {
                while (enumeration.hasMoreElements()) {
                    ObjectInfo obj = (ObjectInfo)enumeration.nextElement();
                    BoundingBox bounds = obj.getBounds();
                    bounds = bounds.transformAndOutset(obj.coords.fromLocal());
                    if (this.cachedBounds == null) {
                        this.cachedBounds = bounds;
                        continue;
                    }
                    this.cachedBounds = this.cachedBounds.merge(bounds);
                }
            }
            info.clearCachedMeshes();
        }
    }
}

