/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.Scene;
import artofillusion.animation.Keyframe;
import artofillusion.math.RGBColor;
import artofillusion.object.Object3D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public abstract class Light
extends Object3D {
    RGBColor color;
    float intensity;
    float decayRate;
    boolean ambient;

    public Light() {
    }

    public Light(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
    }

    public void setParameters(RGBColor theColor, float theIntensity, boolean isAmbient, float decay) {
        this.color = theColor;
        this.intensity = theIntensity;
        this.ambient = isAmbient;
        this.decayRate = decay;
    }

    public RGBColor getColor() {
        return this.color;
    }

    public float getIntensity() {
        return this.intensity;
    }

    public void getLight(RGBColor light, float distance) {
        double d = distance * this.decayRate;
        light.copy(this.color);
        light.scale((double)this.intensity / (1.0 + d + d * d));
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public float getDecayRate() {
        return this.decayRate;
    }

    public static abstract class LightKeyframe
    implements Keyframe {
        public RGBColor color;
        public float intensity;
        public float decayRate;

        public LightKeyframe(RGBColor color, float intensity, float decayRate) {
            this.color = color.duplicate();
            this.intensity = intensity;
            this.decayRate = decayRate;
        }

        public abstract Keyframe duplicate();

        public Keyframe duplicate(Object owner) {
            return this.duplicate();
        }

        public double[] getGraphValues() {
            return new double[]{this.intensity, this.decayRate};
        }

        public void setGraphValues(double[] values) {
            this.intensity = (float)values[0];
            this.decayRate = (float)values[1];
        }

        public int getGraphValueCount() {
            return 2;
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            return this.blend(o2, null, null, weight1, weight2, 0.0, 0.0);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            return this.blend(o2, o3, null, weight1, weight2, weight3, 0.0);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            LightKeyframe result = (LightKeyframe)this.duplicate();
            result.blendInplace(o2, o3, o4, weight1, weight2, weight3, weight4);
            return result;
        }

        protected void blendInplace(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            LightKeyframe k2 = (LightKeyframe)o2;
            LightKeyframe k3 = (LightKeyframe)o3;
            LightKeyframe k4 = (LightKeyframe)o4;
            RGBColor c2 = k2.color;
            RGBColor c3 = k3 == null ? null : k3.color;
            RGBColor c4 = k4 == null ? null : k4.color;
            this.color.blendInplace(c2, c3, c4, weight1, weight2, weight3, weight4);
            double intensity = weight1 * (double)this.intensity + weight2 * (double)k2.intensity;
            double decayRate = weight1 * (double)this.decayRate + weight2 * (double)k2.decayRate;
            if (k3 != null) {
                intensity += weight3 * (double)k3.intensity;
                decayRate += weight3 * (double)k3.decayRate;
                if (k4 != null) {
                    intensity += weight4 * (double)k4.intensity;
                    decayRate += weight4 * (double)k4.decayRate;
                }
            }
            this.intensity = (float)intensity;
            this.decayRate = (float)decayRate;
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof LightKeyframe)) {
                return false;
            }
            LightKeyframe key = (LightKeyframe)k;
            return key.color.equals(this.color) && key.intensity == this.intensity && key.decayRate == this.decayRate;
        }

        public void writeToStream(DataOutputStream out) throws IOException {
            this.color.writeToFile(out);
            out.writeFloat(this.intensity);
            out.writeFloat(this.decayRate);
        }
    }
}

