/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.object;

import artofillusion.CSGEditorWindow;
import artofillusion.ModellingApp;
import artofillusion.RenderingMesh;
import artofillusion.Scene;
import artofillusion.WireframeMesh;
import artofillusion.animation.Keyframe;
import artofillusion.animation.RotationKeyframe;
import artofillusion.animation.VectorKeyframe;
import artofillusion.material.Material;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.CSGModeller;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.ui.EditingWindow;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class CSGObject
extends Object3D {
    ObjectInfo obj1;
    ObjectInfo obj2;
    int operation;
    RenderingMesh cachedMesh;
    WireframeMesh cachedWire;
    BoundingBox bounds;
    public static final int UNION = 0;
    public static final int INTERSECTION = 1;
    public static final int DIFFERENCE12 = 2;
    public static final int DIFFERENCE21 = 3;

    public CSGObject(ObjectInfo o1, ObjectInfo o2, int op) {
        this.obj1 = o1.duplicate();
        this.obj2 = o2.duplicate();
        this.obj1.object = this.obj1.object.duplicate();
        this.obj2.object = this.obj2.object.duplicate();
        this.operation = op;
        this.obj2.visible = true;
        this.obj1.visible = true;
    }

    public Object3D duplicate() {
        CSGObject obj = new CSGObject(this.obj1, this.obj2, this.operation);
        obj.copyTextureAndMaterial(this);
        return obj;
    }

    public void copyObject(Object3D obj) {
        CSGObject csg = (CSGObject)obj;
        this.obj1 = csg.obj1.duplicate();
        this.obj2 = csg.obj2.duplicate();
        this.obj1.object = this.obj1.object.duplicate();
        this.obj2.object = this.obj2.object.duplicate();
        this.operation = csg.operation;
        this.cachedMesh = csg.cachedMesh;
        this.cachedWire = csg.cachedWire;
        this.copyTextureAndMaterial(obj);
        this.bounds = null;
    }

    public ObjectInfo getObject1() {
        return this.obj1;
    }

    public ObjectInfo getObject2() {
        return this.obj2;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int op) {
        this.operation = op;
    }

    public void setComponentObjects(ObjectInfo o1, ObjectInfo o2) {
        this.obj1 = o1;
        this.obj2 = o2;
        this.bounds = null;
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public Vec3 centerObjects() {
        BoundingBox b1 = this.obj1.getBounds().transformAndOutset(this.obj1.coords.fromLocal());
        BoundingBox b2 = this.obj2.getBounds().transformAndOutset(this.obj2.coords.fromLocal());
        BoundingBox b = b1.merge(b2);
        Vec3 center = b.getCenter();
        this.obj1.coords.setOrigin(this.obj1.coords.getOrigin().minus(center));
        this.obj2.coords.setOrigin(this.obj2.coords.getOrigin().minus(center));
        this.bounds = null;
        this.cachedMesh = null;
        this.cachedWire = null;
        return center;
    }

    public BoundingBox getBounds() {
        if (this.bounds == null) {
            this.findBounds();
        }
        return this.bounds;
    }

    void findBounds() {
        Vec3[] vert;
        if (this.cachedMesh != null) {
            vert = this.cachedMesh.vert;
        } else if (this.cachedWire != null) {
            vert = this.cachedWire.vert;
        } else {
            this.getWireframeMesh();
            vert = this.cachedWire.vert;
        }
        this.bounds = BoundingBox.findBounds(vert);
    }

    public void setSize(double xsize, double ysize, double zsize) {
        Vec3 size = this.bounds.getSize();
        double xscale = size.x == 0.0 ? 1.0 : xsize / size.x;
        double yscale = size.y == 0.0 ? 1.0 : ysize / size.y;
        double zscale = size.z == 0.0 ? 1.0 : zsize / size.z;
        Vec3 objSize = this.obj1.getBounds().getSize();
        this.obj1.object.setSize(objSize.x * xscale, objSize.y * yscale, objSize.z * zscale);
        objSize = this.obj2.getBounds().getSize();
        this.obj2.object.setSize(objSize.x * xscale, objSize.y * yscale, objSize.z * zscale);
        Mat4 m = Mat4.scale(xscale, yscale, zscale);
        this.obj1.coords.transformOrigin(m);
        this.obj2.coords.transformOrigin(m);
        this.cachedMesh = null;
        this.cachedWire = null;
        this.findBounds();
    }

    public int canConvertToTriangleMesh() {
        if (this.obj1.object.canConvertToTriangleMesh() == 1 && this.obj2.object.canConvertToTriangleMesh() == 1) {
            return 1;
        }
        return 2;
    }

    public boolean isClosed() {
        return this.obj1.object.isClosed() && this.obj2.object.isClosed();
    }

    public TriangleMesh convertToTriangleMesh(double tol) {
        TriangleMesh mesh1 = this.obj1.object.convertToTriangleMesh(tol);
        TriangleMesh mesh2 = this.obj2.object.convertToTriangleMesh(tol);
        CSGModeller modeller = new CSGModeller(mesh1, mesh2, this.obj1.coords, this.obj2.coords);
        TriangleMesh trimesh = modeller.getMesh(this.operation);
        trimesh.copyTextureAndMaterial(this);
        trimesh.copyModelEvent(this);
        return trimesh;
    }

    public boolean isEditable() {
        return true;
    }

    public void edit(EditingWindow parent, ObjectInfo info, Runnable cb) {
        new CSGEditorWindow(parent, info.name, this, cb);
    }

    public void setTexture(Texture tex, TextureMapping mapping) {
        super.setTexture(tex, mapping);
        if (this.obj1 == null) {
            return;
        }
        this.obj1.object.setTexture(tex, mapping);
        this.obj2.object.setTexture(tex, mapping);
    }

    public void setMaterial(Material mat, MaterialMapping mapping) {
        super.setMaterial(mat, mapping);
        if (this.obj1 == null) {
            return;
        }
        this.obj1.object.setMaterial(mat, mapping);
        this.obj2.object.setMaterial(mat, mapping);
    }

    public RenderingMesh getRenderingMesh(double tol, boolean interactive, ObjectInfo info) {
        if (interactive) {
            if (this.cachedMesh == null) {
                this.cacheMeshes(tol, info);
            }
            return this.cachedMesh;
        }
        return this.convertToTriangleMesh(tol).getRenderingMesh(tol, false, info);
    }

    public WireframeMesh getWireframeMesh() {
        if (this.cachedWire == null) {
            this.cacheMeshes(ModellingApp.getPreferences().getInteractiveSurfaceError(), null);
        }
        return this.cachedWire;
    }

    private void cacheMeshes(double tol, ObjectInfo info) {
        TriangleMesh mesh = this.convertToTriangleMesh(tol);
        if (info == null) {
            this.cachedWire = mesh.getWireframeMesh();
            return;
        }
        this.cachedMesh = mesh.getRenderingMesh(tol, true, info);
        TriangleMesh.Edge[] edge = mesh.getEdges();
        int[] to = new int[edge.length];
        int[] from = new int[edge.length];
        for (int i = 0; i < edge.length; ++i) {
            to[i] = edge[i].v1;
            from[i] = edge[i].v2;
        }
        this.cachedWire = new WireframeMesh(this.cachedMesh.vert, from, to);
    }

    public void writeToFile(DataOutputStream out, Scene theScene) throws IOException {
        super.writeToFile(out, theScene);
        out.writeShort(0);
        out.writeInt(this.operation);
        this.obj1.coords.writeToFile(out);
        out.writeUTF(this.obj1.name);
        out.writeUTF(this.obj1.object.getClass().getName());
        this.obj1.object.writeToFile(out, theScene);
        this.obj2.coords.writeToFile(out);
        out.writeUTF(this.obj2.name);
        out.writeUTF(this.obj2.object.getClass().getName());
        this.obj2.object.writeToFile(out, theScene);
    }

    public CSGObject(DataInputStream in, Scene theScene) throws IOException, InvalidObjectException {
        super(in, theScene);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.operation = in.readInt();
        try {
            this.obj1 = new ObjectInfo(null, new CoordinateSystem(in), in.readUTF());
            Class cls = ModellingApp.getClass(in.readUTF());
            Constructor con = cls.getConstructor(DataInputStream.class, Scene.class);
            this.obj1.object = (Object3D)con.newInstance(in, theScene);
            this.obj2 = new ObjectInfo(null, new CoordinateSystem(in), in.readUTF());
            cls = ModellingApp.getClass(in.readUTF());
            con = cls.getConstructor(DataInputStream.class, Scene.class);
            this.obj2.object = (Object3D)con.newInstance(in, theScene);
        }
        catch (InvocationTargetException ex) {
            ex.getTargetException().printStackTrace();
            throw new IOException();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException();
        }
        this.obj1.object.setTexture(this.getTexture(), this.getTextureMapping());
        this.obj2.object.setTexture(this.getTexture(), this.getTextureMapping());
        if (this.getMaterial() != null) {
            this.obj1.object.setMaterial(this.getMaterial(), this.getMaterialMapping());
            this.obj2.object.setMaterial(this.getMaterial(), this.getMaterialMapping());
        }
    }

    public Keyframe getPoseKeyframe() {
        return new CSGKeyframe(this.obj1.object.getPoseKeyframe(), this.obj2.object.getPoseKeyframe(), this.obj1.coords.duplicate(), this.obj2.coords.duplicate());
    }

    public void applyPoseKeyframe(Keyframe k) {
        CSGKeyframe key = (CSGKeyframe)k;
        this.obj1.object.applyPoseKeyframe(key.key1);
        this.obj2.object.applyPoseKeyframe(key.key2);
        this.obj1.coords.copyCoords(key.coords1);
        this.obj2.coords.copyCoords(key.coords2);
        this.cachedMesh = null;
        this.cachedWire = null;
    }

    public void editKeyframe(EditingWindow parent, Keyframe k, ObjectInfo info) {
    }

    public static class CSGKeyframe
    implements Keyframe {
        public Keyframe key1;
        public Keyframe key2;
        public CoordinateSystem coords1;
        public CoordinateSystem coords2;

        public CSGKeyframe(Keyframe key1, Keyframe key2, CoordinateSystem coords1, CoordinateSystem coords2) {
            this.key1 = key1;
            this.key2 = key2;
            this.coords1 = coords1;
            this.coords2 = coords2;
        }

        public Keyframe duplicate() {
            return new CSGKeyframe(this.key1.duplicate(), this.key2.duplicate(), this.coords1.duplicate(), this.coords2.duplicate());
        }

        public Keyframe duplicate(Object owner) {
            return new CSGKeyframe(this.key1.duplicate(owner), this.key2.duplicate(owner), this.coords1.duplicate(), this.coords2.duplicate());
        }

        public double[] getGraphValues() {
            return new double[0];
        }

        public void setGraphValues(double[] values) {
        }

        public Keyframe blend(Keyframe o2, double weight1, double weight2) {
            CSGKeyframe k2 = (CSGKeyframe)o2;
            RotationKeyframe rot1 = new RotationKeyframe(this.coords1);
            RotationKeyframe rot2 = new RotationKeyframe(k2.coords1);
            rot1.setUseQuaternion(true);
            rot2.setUseQuaternion(true);
            VectorKeyframe orig1 = new VectorKeyframe(this.coords1.getOrigin());
            VectorKeyframe orig2 = new VectorKeyframe(k2.coords1.getOrigin());
            CoordinateSystem c1 = new CoordinateSystem((Vec3)((Object)orig1.blend(orig2, weight1, weight2)), Vec3.vz(), Vec3.vy());
            ((RotationKeyframe)rot1.blend(rot2, weight1, weight2)).applyToCoordinates(c1, 1.0, null, null, false, true, true, true);
            rot1 = new RotationKeyframe(this.coords2);
            rot2 = new RotationKeyframe(k2.coords2);
            rot1.setUseQuaternion(true);
            rot2.setUseQuaternion(true);
            orig1 = new VectorKeyframe(this.coords2.getOrigin());
            orig2 = new VectorKeyframe(k2.coords2.getOrigin());
            CoordinateSystem c2 = new CoordinateSystem((Vec3)((Object)orig1.blend(orig2, weight1, weight2)), Vec3.vz(), Vec3.vy());
            ((RotationKeyframe)rot1.blend(rot2, weight1, weight2)).applyToCoordinates(c2, 1.0, null, null, false, true, true, true);
            return new CSGKeyframe(this.key1.blend(k2.key1, weight1, weight2), this.key2.blend(k2.key2, weight1, weight2), c1, c2);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, double weight1, double weight2, double weight3) {
            CSGKeyframe k2 = (CSGKeyframe)o2;
            CSGKeyframe k3 = (CSGKeyframe)o3;
            RotationKeyframe rot1 = new RotationKeyframe(this.coords1);
            RotationKeyframe rot2 = new RotationKeyframe(k2.coords1);
            RotationKeyframe rot3 = new RotationKeyframe(k3.coords1);
            rot1.setUseQuaternion(true);
            rot2.setUseQuaternion(true);
            rot3.setUseQuaternion(true);
            VectorKeyframe orig1 = new VectorKeyframe(this.coords1.getOrigin());
            VectorKeyframe orig2 = new VectorKeyframe(k2.coords1.getOrigin());
            VectorKeyframe orig3 = new VectorKeyframe(k3.coords1.getOrigin());
            CoordinateSystem c1 = new CoordinateSystem((Vec3)((Object)orig1.blend(orig2, orig3, weight1, weight2, weight3)), Vec3.vz(), Vec3.vy());
            ((RotationKeyframe)rot1.blend(rot2, rot3, weight1, weight2, weight3)).applyToCoordinates(c1, 1.0, null, null, false, true, true, true);
            rot1 = new RotationKeyframe(this.coords2);
            rot2 = new RotationKeyframe(k2.coords2);
            rot3 = new RotationKeyframe(k3.coords2);
            rot1.setUseQuaternion(true);
            rot2.setUseQuaternion(true);
            rot3.setUseQuaternion(true);
            orig1 = new VectorKeyframe(this.coords2.getOrigin());
            orig2 = new VectorKeyframe(k2.coords2.getOrigin());
            orig3 = new VectorKeyframe(k3.coords2.getOrigin());
            CoordinateSystem c2 = new CoordinateSystem((Vec3)((Object)orig1.blend(orig2, orig3, weight1, weight2, weight3)), Vec3.vz(), Vec3.vy());
            ((RotationKeyframe)rot1.blend(rot2, rot3, weight1, weight2, weight3)).applyToCoordinates(c2, 1.0, null, null, false, true, true, true);
            return new CSGKeyframe(this.key1.blend(k2.key1, k3.key1, weight1, weight2, weight3), this.key2.blend(k2.key2, k3.key2, weight1, weight2, weight3), c1, c2);
        }

        public Keyframe blend(Keyframe o2, Keyframe o3, Keyframe o4, double weight1, double weight2, double weight3, double weight4) {
            CSGKeyframe k2 = (CSGKeyframe)o2;
            CSGKeyframe k3 = (CSGKeyframe)o3;
            CSGKeyframe k4 = (CSGKeyframe)o4;
            RotationKeyframe rot1 = new RotationKeyframe(this.coords1);
            RotationKeyframe rot2 = new RotationKeyframe(k2.coords1);
            RotationKeyframe rot3 = new RotationKeyframe(k3.coords1);
            RotationKeyframe rot4 = new RotationKeyframe(k4.coords1);
            rot1.setUseQuaternion(true);
            rot2.setUseQuaternion(true);
            rot3.setUseQuaternion(true);
            rot4.setUseQuaternion(true);
            VectorKeyframe orig1 = new VectorKeyframe(this.coords1.getOrigin());
            VectorKeyframe orig2 = new VectorKeyframe(k2.coords1.getOrigin());
            VectorKeyframe orig3 = new VectorKeyframe(k3.coords1.getOrigin());
            VectorKeyframe orig4 = new VectorKeyframe(k4.coords1.getOrigin());
            CoordinateSystem c1 = new CoordinateSystem((Vec3)((Object)orig1.blend(orig2, orig3, orig4, weight1, weight2, weight3, weight4)), Vec3.vz(), Vec3.vy());
            ((RotationKeyframe)rot1.blend(rot2, rot3, rot4, weight1, weight2, weight3, weight4)).applyToCoordinates(c1, 1.0, null, null, false, true, true, true);
            rot1 = new RotationKeyframe(this.coords2);
            rot2 = new RotationKeyframe(k2.coords2);
            rot3 = new RotationKeyframe(k3.coords2);
            rot4 = new RotationKeyframe(k4.coords2);
            rot1.setUseQuaternion(true);
            rot2.setUseQuaternion(true);
            rot3.setUseQuaternion(true);
            rot4.setUseQuaternion(true);
            orig1 = new VectorKeyframe(this.coords2.getOrigin());
            orig2 = new VectorKeyframe(k2.coords2.getOrigin());
            orig3 = new VectorKeyframe(k3.coords2.getOrigin());
            orig4 = new VectorKeyframe(k4.coords2.getOrigin());
            CoordinateSystem c2 = new CoordinateSystem((Vec3)((Object)orig1.blend(orig2, orig3, orig4, weight1, weight2, weight3, weight4)), Vec3.vz(), Vec3.vy());
            ((RotationKeyframe)rot1.blend(rot2, rot3, rot3, weight1, weight2, weight3, weight4)).applyToCoordinates(c2, 1.0, null, null, false, true, true, true);
            return new CSGKeyframe(this.key1.blend(k2.key1, k3.key1, k4.key1, weight1, weight2, weight3, weight4), this.key2.blend(k2.key2, k3.key2, k4.key2, weight1, weight2, weight3, weight4), c1, c2);
        }

        public boolean equals(Keyframe k) {
            if (!(k instanceof CSGKeyframe)) {
                return false;
            }
            CSGKeyframe key = (CSGKeyframe)k;
            if (!this.key1.equals(key.key1)) {
                return false;
            }
            if (!this.key2.equals(key.key2)) {
                return false;
            }
            if (!this.coords1.getOrigin().equals(key.coords1.getOrigin())) {
                return false;
            }
            if (!this.coords1.getZDirection().equals(key.coords1.getZDirection())) {
                return false;
            }
            if (!this.coords1.getUpDirection().equals(key.coords1.getUpDirection())) {
                return false;
            }
            if (!this.coords2.getOrigin().equals(key.coords2.getOrigin())) {
                return false;
            }
            if (!this.coords2.getZDirection().equals(key.coords2.getZDirection())) {
                return false;
            }
            return this.coords2.getUpDirection().equals(key.coords2.getUpDirection());
        }

        public void writeToStream(DataOutputStream out) throws IOException {
        }

        public CSGKeyframe(DataInputStream in, Object parent) throws IOException {
        }
    }
}

