/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import Jama.Matrix;
import Jama.SingularValueDecomposition;

public class SVD {
    public static void solve(double[][] a, double[] b) {
        SVD.solve(a, b, 1.0E-8);
    }

    public static void solve(double[][] a, double[] b, double tol) {
        int j;
        double d;
        int i;
        int m = a.length;
        int n = a[0].length;
        Matrix mat = new Matrix(a, m, n);
        SingularValueDecomposition svd = mat.svd();
        double[][] u = svd.getU().getArray();
        double[][] v = svd.getV().getArray();
        double[] s = svd.getSingularValues();
        double cutoff = s[0] * tol;
        double[] temp = new double[n];
        for (i = 0; i < n && s[i] > cutoff; ++i) {
            d = 0.0;
            for (j = 0; j < m; ++j) {
                d += u[j][i] * b[j];
            }
            temp[i] = d / s[i];
        }
        for (i = 0; i < n; ++i) {
            d = 0.0;
            for (j = 0; j < n; ++j) {
                d += v[i][j] * temp[j];
            }
            b[i] = d;
        }
    }
}

