/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.math;

import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public class CoordinateSystem
implements Serializable {
    private static final long serialVersionUID = 0L;
    Vec3 orig;
    Vec3 zdir;
    Vec3 updir;
    Mat4 transformTo;
    Mat4 transformFrom;
    double xrot;
    double yrot;
    double zrot;

    public CoordinateSystem() {
        this(new Vec3(), Vec3.vz(), Vec3.vy());
    }

    public CoordinateSystem(Vec3 orig, Vec3 zdir, Vec3 updir) {
        this.orig = orig;
        this.zdir = zdir;
        this.updir = updir;
        zdir.normalize();
        updir.normalize();
        this.findRotationAngles();
    }

    public CoordinateSystem(Vec3 orig, double x, double y, double z) {
        this.orig = orig;
        this.setOrientation(x, y, z);
    }

    public final CoordinateSystem duplicate() {
        CoordinateSystem coords = new CoordinateSystem(new Vec3(this.orig.x, this.orig.y, this.orig.z), new Vec3(this.zdir.x, this.zdir.y, this.zdir.z), new Vec3(this.updir.x, this.updir.y, this.updir.z));
        coords.xrot = this.xrot;
        coords.yrot = this.yrot;
        coords.zrot = this.zrot;
        return coords;
    }

    public final void copyCoords(CoordinateSystem c) {
        this.setOrigin(new Vec3(c.orig.x, c.orig.y, c.orig.z));
        this.setOrientation(new Vec3(c.zdir), new Vec3(c.updir));
        this.xrot = c.xrot;
        this.yrot = c.yrot;
        this.zrot = c.zrot;
    }

    public final boolean equals(Object coords) {
        CoordinateSystem c = (CoordinateSystem)coords;
        if (!this.orig.equals(c.orig)) {
            return false;
        }
        if (!this.zdir.equals(c.zdir)) {
            return false;
        }
        return this.updir.equals(c.updir);
    }

    public final void setOrigin(Vec3 orig) {
        this.orig = orig;
        this.transformFrom = null;
        this.transformTo = null;
    }

    public final void setOrientation(Vec3 zdir, Vec3 updir) {
        this.zdir = zdir;
        this.updir = updir;
        zdir.normalize();
        updir.normalize();
        this.findRotationAngles();
        this.transformFrom = null;
        this.transformTo = null;
    }

    public final void setOrientation(double x, double y, double z) {
        this.xrot = x * Math.PI / 180.0;
        this.yrot = y * Math.PI / 180.0;
        this.zrot = z * Math.PI / 180.0;
        Mat4 m = Mat4.yrotation(-this.yrot).times(Mat4.xrotation(-this.xrot)).times(Mat4.zrotation(-this.zrot));
        this.zdir = m.times(Vec3.vz());
        this.updir = m.times(Vec3.vy());
        this.transformFrom = null;
        this.transformTo = null;
    }

    public final Vec3 getOrigin() {
        return this.orig;
    }

    public final Vec3 getZDirection() {
        return this.zdir;
    }

    public final Vec3 getUpDirection() {
        return this.updir;
    }

    public final double[] getRotationAngles() {
        return new double[]{this.xrot * 180.0 / Math.PI, this.yrot * 180.0 / Math.PI, this.zrot * 180.0 / Math.PI};
    }

    public final void transformAxes(Mat4 m) {
        this.zdir = m.timesDirection(this.zdir);
        this.updir = m.timesDirection(this.updir);
        this.findRotationAngles();
        this.transformFrom = null;
        this.transformTo = null;
    }

    public final void transformOrigin(Mat4 m) {
        this.orig = m.times(this.orig);
        this.transformFrom = null;
        this.transformTo = null;
    }

    public final void transformCoordinates(Mat4 m) {
        this.orig = m.times(this.orig);
        this.zdir = m.timesDirection(this.zdir);
        this.updir = m.timesDirection(this.updir);
        this.findRotationAngles();
        this.transformFrom = null;
        this.transformTo = null;
    }

    public final Mat4 fromLocal() {
        if (this.transformFrom == null) {
            this.transformFrom = Mat4.objectTransform(this.orig, this.zdir, this.updir);
        }
        return this.transformFrom;
    }

    public final Mat4 toLocal() {
        if (this.transformTo == null) {
            this.transformTo = Mat4.viewTransform(this.orig, this.zdir, this.updir);
        }
        return this.transformTo;
    }

    private void findRotationAngles() {
        double d;
        if (this.zdir.x == 0.0 && this.zdir.z == 0.0) {
            d = Math.sqrt(this.updir.x * this.updir.x + this.updir.z * this.updir.z);
            this.yrot = Math.acos(this.updir.z / d);
            if (Double.isNaN(this.yrot)) {
                this.yrot = Math.acos(this.updir.z > 0.0 ? 1.0 : -1.0);
            }
            if (this.zdir.y > 0.0) {
                this.yrot *= -1.0;
            }
        } else {
            d = Math.sqrt(this.zdir.x * this.zdir.x + this.zdir.z * this.zdir.z);
            this.yrot = Math.acos(this.zdir.z / d);
            if (Double.isNaN(this.yrot)) {
                this.yrot = Math.acos(this.zdir.z > 0.0 ? 1.0 : -1.0);
            }
            if (this.zdir.x > 0.0) {
                this.yrot *= -1.0;
            }
        }
        Mat4 m = Mat4.yrotation(this.yrot);
        Vec3 v = m.times(this.zdir);
        d = this.zdir.length();
        this.xrot = Math.acos(v.z / d);
        if (Double.isNaN(this.xrot)) {
            this.xrot = Math.acos(v.z > 0.0 ? 1.0 : -1.0);
        }
        if (v.y < 0.0) {
            this.xrot *= -1.0;
        }
        m = Mat4.xrotation(this.xrot).times(m);
        v = m.times(this.updir);
        d = Math.sqrt(v.x * v.x + v.y * v.y);
        this.zrot = Math.acos(v.y / d);
        if (Double.isNaN(this.zrot)) {
            this.zrot = Math.acos(v.y > 0.0 ? 1.0 : -1.0);
        }
        if (v.x < 0.0) {
            this.zrot *= -1.0;
        }
    }

    public final double getAxisAngleRotation(Vec3 axis) {
        double cphi;
        double sphi;
        double[][] a = new double[4][];
        double[] b = new double[4];
        Mat4 m = this.toLocal();
        if (this.zdir.z == 1.0) {
            axis.set(0.0, 0.0, 1.0);
            if (this.updir.y == 1.0) {
                return 0.0;
            }
        } else if (this.updir.y == 1.0) {
            axis.set(0.0, 1.0, 0.0);
        } else {
            axis.set((this.updir.y - 1.0) * (this.zdir.z - 1.0) - this.updir.z * this.zdir.y, this.updir.z * this.zdir.x - this.updir.x * (this.zdir.z - 1.0), this.updir.x * this.zdir.y - (this.updir.y - 1.0) * this.zdir.x);
            if (axis.length2() < 1.0E-6) {
                Vec3 xdir = this.updir.cross(this.zdir);
                axis.set(xdir.y * (this.zdir.z - 1.0) - xdir.z * this.zdir.y, xdir.z * this.zdir.x - (xdir.x - 1.0) * (this.zdir.z - 1.0), (xdir.x - 1.0) * this.zdir.y - xdir.y * this.zdir.x);
            }
            axis.normalize();
        }
        if (Math.abs(axis.z) < Math.abs(axis.y)) {
            Vec3 v = axis.cross(this.zdir);
            double ctheta2 = axis.z * axis.z;
            sphi = v.z / (ctheta2 - 1.0);
            cphi = (this.zdir.z - ctheta2) / (1.0 - ctheta2);
        } else {
            Vec3 v = axis.cross(this.updir);
            double ctheta2 = axis.y * axis.y;
            sphi = v.y / (ctheta2 - 1.0);
            cphi = (this.updir.y - ctheta2) / (1.0 - ctheta2);
        }
        if (cphi > 0.0) {
            return Math.asin(sphi);
        }
        if (sphi > 0.0) {
            return Math.PI - Math.asin(sphi);
        }
        return -(Math.PI + Math.asin(sphi));
    }

    public CoordinateSystem(DataInputStream in) throws IOException {
        this.orig = new Vec3(in);
        this.xrot = in.readDouble();
        this.yrot = in.readDouble();
        this.zrot = in.readDouble();
        Mat4 m = Mat4.yrotation(-this.yrot).times(Mat4.xrotation(-this.xrot)).times(Mat4.zrotation(-this.zrot));
        this.zdir = m.times(Vec3.vz());
        this.updir = m.times(Vec3.vy());
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        this.orig.writeToFile(out);
        out.writeDouble(this.xrot);
        out.writeDouble(this.yrot);
        out.writeDouble(this.zrot);
    }
}

