/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.material;

import artofillusion.MaterialPreviewer;
import artofillusion.material.Material;
import artofillusion.material.Material3D;
import artofillusion.material.MaterialMapping;
import artofillusion.material.MaterialSpec;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Object3D;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;

public class LinearMaterialMapping
extends MaterialMapping {
    CoordinateSystem coords;
    double ax;
    double bx;
    double cx;
    double dx;
    double ay;
    double by;
    double cy;
    double dy;
    double az;
    double bz;
    double cz;
    double dz;
    double xscale;
    double yscale;
    double zscale;
    double matScaleX;
    double matScaleY;
    double matScaleZ;
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;

    public LinearMaterialMapping(Material3D theMaterial) {
        super(theMaterial);
        this.coords = new CoordinateSystem(new Vec3(), new Vec3(0.0, 0.0, 1.0), new Vec3(0.0, 1.0, 0.0));
        this.zscale = 1.0;
        this.yscale = 1.0;
        this.xscale = 1.0;
        this.dz = 0.0;
        this.dy = 0.0;
        this.dx = 0.0;
        this.findCoefficients();
    }

    public static String getName() {
        return "Linear";
    }

    public static boolean legalMapping(Object3D obj, Material mat) {
        return mat instanceof Material3D;
    }

    private void findCoefficients() {
        Vec3 zdir = this.coords.getZDirection();
        Vec3 ydir = this.coords.getUpDirection();
        Vec3 xdir = ydir.cross(zdir);
        this.ax = xdir.x / this.xscale;
        this.bx = xdir.y / this.xscale;
        this.cx = xdir.z / this.xscale;
        this.ay = ydir.x / this.yscale;
        this.by = ydir.y / this.yscale;
        this.cy = ydir.z / this.yscale;
        this.az = zdir.x / this.zscale;
        this.bz = zdir.y / this.zscale;
        this.cz = zdir.z / this.zscale;
        this.matScaleX = 1.0 / this.xscale;
        this.matScaleY = 1.0 / this.yscale;
        this.matScaleZ = 1.0 / this.zscale;
    }

    public Vec3 getCenter() {
        return new Vec3(this.dx, this.dy, this.dz);
    }

    public void setCenter(Vec3 center) {
        this.dx = center.x;
        this.dy = center.y;
        this.dz = center.z;
        this.findCoefficients();
    }

    public Vec3 getScale() {
        return new Vec3(this.xscale, this.yscale, this.zscale);
    }

    public void setScale(Vec3 scale) {
        this.xscale = scale.x;
        this.yscale = scale.y;
        this.zscale = scale.z;
        this.findCoefficients();
    }

    public Vec3 getRotations() {
        double[] angles = this.coords.getRotationAngles();
        return new Vec3(angles[0], angles[1], angles[2]);
    }

    public void setRotations(Vec3 angles) {
        this.coords.setOrientation(angles.x, angles.y, angles.z);
        this.findCoefficients();
    }

    public double getStepSize() {
        return Math.abs(this.material.getStepSize() * Math.min(Math.min(this.matScaleX, this.matScaleY), this.matScaleZ));
    }

    public void getMaterialSpec(Vec3 pos, MaterialSpec spec, double size, double time) {
        ((Material3D)this.material).getMaterialSpec(spec, pos.x * this.ax + pos.y * this.bx + pos.z * this.cx - this.dx, pos.x * this.ay + pos.y * this.by + pos.z * this.cy - this.dy, pos.x * this.az + pos.y * this.bz + pos.z * this.cz - this.dz, size * this.matScaleX, size * this.matScaleY, size * this.matScaleZ, time);
    }

    public MaterialMapping duplicate() {
        return this.duplicate(this.material);
    }

    public MaterialMapping duplicate(Material mat) {
        LinearMaterialMapping map = new LinearMaterialMapping((Material3D)mat);
        map.coords = this.coords.duplicate();
        map.dx = this.dx;
        map.dy = this.dy;
        map.dz = this.dz;
        map.xscale = this.xscale;
        map.yscale = this.yscale;
        map.zscale = this.zscale;
        map.findCoefficients();
        return map;
    }

    public void copy(MaterialMapping mapping) {
        LinearMaterialMapping map = (LinearMaterialMapping)mapping;
        this.coords = map.coords.duplicate();
        this.dx = map.dx;
        this.dy = map.dy;
        this.dz = map.dz;
        this.xscale = map.xscale;
        this.yscale = map.yscale;
        this.zscale = map.zscale;
        this.findCoefficients();
    }

    public Widget getEditingPanel(Object3D obj, MaterialPreviewer preview) {
        return new Editor(obj, preview);
    }

    public LinearMaterialMapping(DataInputStream in, Material theMaterial) throws IOException, InvalidObjectException {
        super(theMaterial);
        short version = in.readShort();
        if (version != 0) {
            throw new InvalidObjectException("");
        }
        this.coords = new CoordinateSystem(in);
        this.dx = in.readDouble();
        this.dy = in.readDouble();
        this.dz = in.readDouble();
        this.xscale = in.readDouble();
        this.yscale = in.readDouble();
        this.zscale = in.readDouble();
        this.findCoefficients();
    }

    public void writeToFile(DataOutputStream out) throws IOException {
        out.writeShort(0);
        this.coords.writeToFile(out);
        out.writeDouble(this.dx);
        out.writeDouble(this.dy);
        out.writeDouble(this.dz);
        out.writeDouble(this.xscale);
        out.writeDouble(this.yscale);
        out.writeDouble(this.zscale);
    }

    private class Editor
    extends FormContainer {
        ValueField xrotField;
        ValueField yrotField;
        ValueField zrotField;
        ValueField xscaleField;
        ValueField yscaleField;
        ValueField zscaleField;
        ValueField xtransField;
        ValueField ytransField;
        ValueField ztransField;
        Object3D theObject;
        MaterialPreviewer preview;

        public Editor(Object3D obj, MaterialPreviewer preview) {
            super(6, 6);
            this.theObject = obj;
            this.preview = preview;
            this.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
            this.add(new BLabel(Translate.text("Scale") + ":"), 0, 0, 3, 1);
            this.add(new BLabel("X"), 0, 1);
            this.xscaleField = new ValueField(LinearMaterialMapping.this.xscale, 2, 5);
            this.add(this.xscaleField, 1, 1);
            this.add(new BLabel("Y"), 2, 1);
            this.yscaleField = new ValueField(LinearMaterialMapping.this.yscale, 2, 5);
            this.add(this.yscaleField, 3, 1);
            this.add(new BLabel("Z"), 4, 1);
            this.zscaleField = new ValueField(LinearMaterialMapping.this.zscale, 2, 5);
            this.add(this.zscaleField, 5, 1);
            this.add(new BLabel(Translate.text("Center") + ":"), 0, 2, 3, 1);
            this.add(new BLabel("X"), 0, 3);
            this.xtransField = new ValueField(LinearMaterialMapping.this.dx, 0, 5);
            this.add(this.xtransField, 1, 3);
            this.add(new BLabel("Y"), 2, 3);
            this.ytransField = new ValueField(LinearMaterialMapping.this.dy, 0, 5);
            this.add(this.ytransField, 3, 3);
            this.add(new BLabel("Z"), 4, 3);
            this.ztransField = new ValueField(LinearMaterialMapping.this.dz, 0, 5);
            this.add(this.ztransField, 5, 3);
            double[] angles = LinearMaterialMapping.this.coords.getRotationAngles();
            this.add(new BLabel(Translate.text("Rotation") + ":"), 0, 4, 3, 1);
            this.add(new BLabel("X"), 0, 5);
            this.xrotField = new ValueField(angles[0], 0, 5);
            this.add(this.xrotField, 1, 5);
            this.add(new BLabel("Y"), 2, 5);
            this.yrotField = new ValueField(angles[1], 0, 5);
            this.add(this.yrotField, 3, 5);
            this.add(new BLabel("Z"), 4, 5);
            this.zrotField = new ValueField(angles[2], 0, 5);
            this.add(this.zrotField, 5, 5);
            this.xscaleField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMaterialMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.yscaleField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMaterialMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.zscaleField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMaterialMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.xtransField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMaterialMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.ytransField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMaterialMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.ztransField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMaterialMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.xrotField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMaterialMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.yrotField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMaterialMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
            this.zrotField.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = LinearMaterialMapping.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, this);
        }

        private void processEvent() {
            LinearMaterialMapping.this.xscale = this.xscaleField.getValue();
            LinearMaterialMapping.this.yscale = this.yscaleField.getValue();
            LinearMaterialMapping.this.zscale = this.zscaleField.getValue();
            LinearMaterialMapping.this.dx = this.xtransField.getValue();
            LinearMaterialMapping.this.dy = this.ytransField.getValue();
            LinearMaterialMapping.this.dz = this.ztransField.getValue();
            LinearMaterialMapping.this.coords.setOrientation(this.xrotField.getValue(), this.yrotField.getValue(), this.zrotField.getValue());
            LinearMaterialMapping.this.findCoefficients();
            this.preview.render();
        }
    }
}

