/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.object.SceneCamera;
import artofillusion.ui.ColorChooser;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import buoy.event.MouseClickedEvent;
import buoy.widget.BLabel;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TintFilter
extends ImageFilter {
    public String getName() {
        return Translate.text("Tint");
    }

    public void filterImage(ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        this.filterComponent(image, 2, (float)this.paramValue[0]);
        this.filterComponent(image, 1, (float)this.paramValue[1]);
        this.filterComponent(image, 0, (float)this.paramValue[2]);
    }

    private void filterComponent(ComplexImage image, int component, float scale) {
        int width = image.getWidth();
        int height = image.getHeight();
        float[] filtered = new float[width * height];
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                filtered[i + j * width] = image.getPixelComponent(i, j, component) * scale;
            }
        }
        image.setComponentValues(component, filtered);
    }

    public TextureParameter[] getParameters() {
        return new TextureParameter[]{new TextureParameter(this, Translate.text("Red"), 0.0, Double.MAX_VALUE, 1.0), new TextureParameter(this, Translate.text("Green"), 0.0, Double.MAX_VALUE, 1.0), new TextureParameter(this, Translate.text("Blue"), 0.0, Double.MAX_VALUE, 1.0)};
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        for (int i = 0; i < this.paramValue.length; ++i) {
            out.writeDouble(this.paramValue[i]);
        }
    }

    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        for (int i = 0; i < this.paramValue.length; ++i) {
            this.paramValue[i] = in.readDouble();
        }
    }

    public Widget getConfigPanel() {
        final RGBColor color = new RGBColor(this.paramValue[0], this.paramValue[1], this.paramValue[2]);
        final Widget sample = color.getSample(40, 30);
        RowContainer row = new RowContainer();
        row.add(new BLabel(Translate.text("Color") + ": "));
        row.add(sample);
        sample.addEventLink(MouseClickedEvent.class, new Object(){

            void processEvent() {
                new ColorChooser(UIUtilities.findFrame(sample), Translate.text("chooseTintColor"), color);
                TintFilter.this.paramValue[0] = color.getRed();
                TintFilter.this.paramValue[1] = color.getGreen();
                TintFilter.this.paramValue[2] = color.getBlue();
                sample.setBackground(color.getColor());
            }
        });
        UIUtilities.applyBackground(row, null);
        sample.setBackground(color.getColor());
        return row;
    }
}

