/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ComplexImage;
import artofillusion.image.filter.ImageFilter;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.object.SceneCamera;
import artofillusion.ui.Translate;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SaturationFilter
extends ImageFilter {
    public String getName() {
        return Translate.text("Saturation");
    }

    public void filterImage(ComplexImage image, Scene scene, SceneCamera camera, CoordinateSystem cameraPos) {
        int width = image.getWidth();
        int height = image.getHeight();
        float saturation = (float)this.paramValue[0];
        float[] red = new float[width * height];
        float[] green = new float[width * height];
        float[] blue = new float[width * height];
        RGBColor color = new RGBColor();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                float r = image.getPixelComponent(i, j, 2);
                float g = image.getPixelComponent(i, j, 1);
                float b = image.getPixelComponent(i, j, 0);
                color.setRGB(r, g, b);
                float brightness = color.getBrightness();
                r = brightness + (r - brightness) * saturation;
                g = brightness + (g - brightness) * saturation;
                b = brightness + (b - brightness) * saturation;
                if (r < 0.0f) {
                    r = 0.0f;
                }
                if (g < 0.0f) {
                    g = 0.0f;
                }
                if (b < 0.0f) {
                    b = 0.0f;
                }
                red[i + j * width] = r;
                green[i + j * width] = g;
                blue[i + j * width] = b;
            }
        }
        image.setComponentValues(2, red);
        image.setComponentValues(1, green);
        image.setComponentValues(0, blue);
    }

    public TextureParameter[] getParameters() {
        return new TextureParameter[]{new TextureParameter(this, this.getName(), 0.0, Double.MAX_VALUE, 1.0)};
    }

    public void writeToStream(DataOutputStream out, Scene theScene) throws IOException {
        out.writeDouble(this.paramValue[0]);
    }

    public void initFromStream(DataInputStream in, Scene theScene) throws IOException {
        this.paramValue[0] = in.readDouble();
    }
}

