/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image.filter;

import artofillusion.Scene;
import artofillusion.TextureParameter;
import artofillusion.image.ComplexImage;
import artofillusion.math.CoordinateSystem;
import artofillusion.object.SceneCamera;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.widget.BLabel;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import java.awt.Insets;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class ImageFilter {
    protected double[] paramValue;
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;

    public ImageFilter() {
        TextureParameter[] param = this.getParameters();
        this.paramValue = new double[param.length];
        for (int i = 0; i < param.length; ++i) {
            this.paramValue[i] = param[i].defaultVal;
        }
    }

    public abstract String getName();

    public int getDesiredComponents() {
        return 3;
    }

    public abstract void filterImage(ComplexImage var1, Scene var2, SceneCamera var3, CoordinateSystem var4);

    public ImageFilter duplicate() {
        try {
            ImageFilter f = (ImageFilter)this.getClass().newInstance();
            f.copy(this);
            return f;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void copy(ImageFilter f) {
        this.paramValue = new double[f.paramValue.length];
        for (int i = 0; i < this.paramValue.length; ++i) {
            this.paramValue[i] = f.paramValue[i];
        }
    }

    public TextureParameter[] getParameters() {
        return new TextureParameter[0];
    }

    public double[] getParameterValues() {
        double[] val = new double[this.paramValue.length];
        System.arraycopy(this.paramValue, 0, val, 0, val.length);
        return val;
    }

    public void setParameterValue(int which, double value) {
        this.paramValue[which] = value;
    }

    public abstract void writeToStream(DataOutputStream var1, Scene var2) throws IOException;

    public abstract void initFromStream(DataInputStream var1, Scene var2) throws IOException;

    public Widget getConfigPanel() {
        TextureParameter[] param = this.getParameters();
        FormContainer form = new FormContainer(2, param.length);
        LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        for (int i = 0; i < param.length; ++i) {
            form.add(new BLabel(param[i].name + ": "), 0, i, leftLayout);
        }
        LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
        for (int i = 0; i < param.length; ++i) {
            Widget w = param[i].getEditingWidget(this.paramValue[i]);
            if (w instanceof ValueField) {
                class FieldListener {
                    private int which;
                    private ValueField field;

                    public FieldListener(int which, ValueField field) {
                        this.which = which;
                        this.field = field;
                    }

                    void processEvent() {
                        ImageFilter.this.setParameterValue(this.which, this.field.getValue());
                    }
                }
                w.addEventLink(class$buoy$event$ValueChangedEvent == null ? ImageFilter.class$("buoy.event.ValueChangedEvent") : class$buoy$event$ValueChangedEvent, new FieldListener(i, (ValueField)w));
            } else {
                class SliderListener {
                    private int which;
                    private ValueSlider slider;

                    public SliderListener(int which, ValueSlider slider) {
                        this.which = which;
                        this.slider = slider;
                    }

                    void processEvent() {
                        ImageFilter.this.setParameterValue(this.which, this.slider.getValue());
                    }
                }
                w.addEventLink(class$buoy$event$ValueChangedEvent == null ? ImageFilter.class$("buoy.event.ValueChangedEvent") : class$buoy$event$ValueChangedEvent, new SliderListener(i, (ValueSlider)w));
            }
            form.add(w, 1, i, rightLayout);
        }
        UIUtilities.applyBackground(form, null);
        return form;
    }
}

