/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.ModellingApp;
import artofillusion.image.BMPEncoder;
import artofillusion.image.ComplexImage;
import artofillusion.image.HDREncoder;
import artofillusion.image.MovieEncoder;
import artofillusion.image.TIFFEncoder;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.BStandardDialog;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.OverlayContainer;
import buoy.widget.RowContainer;
import buoy.widget.WindowWidget;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import javax.imageio.ImageIO;
import jpegencoder.JpegEncoder;

public class ImageSaver {
    private int format;
    private int index;
    private String name;
    private String directory;
    private boolean ok;
    private boolean premultiply;
    private double quality;
    private BFrame parent;
    private MovieEncoder movie;
    public static final int FORMAT_JPEG = 0;
    public static final int FORMAT_TIFF = 1;
    public static final int FORMAT_PNG = 2;
    public static final int FORMAT_BMP = 3;
    public static final int FORMAT_HDR = 4;
    public static final int FORMAT_QUICKTIME = 5;
    private static final String[] FORMAT_NAME = new String[]{"JPEG", "TIFF", "PNG", "BMP", "HDR", "Quicktime"};
    private static final String[] FORMAT_EXTENSION = new String[]{"jpg", "tif", "png", "bmp", "hdr", "mov"};
    private static boolean premultiplyDefault = true;
    private static double qualityDefault = 90.0;
    private static int lastImageFormat = 0;
    private static int lastMovieFormat = 5;

    public ImageSaver(BFrame parent) {
        this.init(parent, false);
    }

    public ImageSaver(BFrame parent, int width, int height, int fps) {
        this.init(parent, true);
        if (this.format == 5 && this.clickedOk()) {
            this.movie = new MovieEncoder(width, height, fps, new File(this.directory, this.name));
            this.movie.doIt();
        }
    }

    private void init(BFrame parent, boolean animate) {
        this.parent = parent;
        this.index = animate ? 1 : -1;
        final BComboBox formatChoice = new BComboBox();
        boolean allowQuicktime = this.gotJMF() && animate;
        for (int i = 0; i < FORMAT_NAME.length; ++i) {
            if (!allowQuicktime && i == 5) continue;
            formatChoice.add(FORMAT_NAME[i]);
        }
        if (animate && !allowQuicktime && lastMovieFormat == 5) {
            lastMovieFormat = 0;
        }
        formatChoice.setSelectedValue(FORMAT_NAME[animate ? lastMovieFormat : lastImageFormat]);
        BCheckBox premultBox = new BCheckBox("Premultiply Transparency", premultiplyDefault);
        ValueSlider qualitySlider = new ValueSlider(0.0, 100.0, 100, qualityDefault);
        final OverlayContainer optionsPanel = new OverlayContainer();
        formatChoice.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                Object value = formatChoice.getSelectedValue();
                if (FORMAT_NAME[0].equals(value) || FORMAT_NAME[5].equals(value)) {
                    optionsPanel.setVisibleChild(0);
                } else if (FORMAT_NAME[1].equals(value)) {
                    optionsPanel.setVisibleChild(1);
                } else {
                    optionsPanel.setVisibleChild(2);
                }
            }
        });
        FormContainer mainPanel = new FormContainer(1, 2);
        mainPanel.add(formatChoice, 0, 0, new LayoutInfo());
        mainPanel.add(optionsPanel, 0, 1);
        RowContainer jpegRow = new RowContainer();
        jpegRow.add(Translate.label("Quality"));
        jpegRow.add(qualitySlider);
        optionsPanel.add(jpegRow, 0);
        optionsPanel.add(premultBox, 1);
        optionsPanel.add(new BLabel(), 2);
        premultBox.setEnabled(true);
        formatChoice.dispatchEvent(new ValueChangedEvent(formatChoice));
        PanelDialog dlg = new PanelDialog((WindowWidget)parent, Translate.text("selectFileFormat"), mainPanel);
        if (dlg.clickedOk()) {
            this.premultiply = premultiplyDefault = premultBox.getState();
            this.quality = qualityDefault = qualitySlider.getValue();
            Object formatValue = formatChoice.getSelectedValue();
            for (int i = 0; i < FORMAT_NAME.length; ++i) {
                if (!FORMAT_NAME[i].equals(formatValue)) continue;
                this.format = i;
            }
            if (animate) {
                lastMovieFormat = this.format;
            } else {
                lastImageFormat = this.format;
            }
            BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text("saveImage"));
            String filename = "Untitled." + FORMAT_EXTENSION[this.format];
            File file = ModellingApp.currentDirectory == null ? new File(filename) : new File(ModellingApp.currentDirectory, filename);
            fc.setSelectedFile(file);
            this.ok = fc.showDialog(parent);
            if (this.ok) {
                file = fc.getSelectedFile();
                this.name = file.getName();
                this.directory = file.getParentFile().getAbsolutePath();
            }
        }
    }

    private boolean gotJMF() {
        try {
            Class<?> c = Class.forName("javax.media.protocol.DataSource");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean clickedOk() {
        return this.ok;
    }

    public boolean saveImage(Image im) {
        return this.saveImage(new ComplexImage(im));
    }

    public boolean saveImage(ComplexImage img) {
        String filename = this.name;
        if (this.movie != null) {
            Image im = img.getImage();
            im = ImageSaver.premultiplyTransparency(im);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            JpegEncoder jpg = new JpegEncoder(im, (int)this.quality, bos);
            jpg.Compress();
            this.movie.pushBytes(baos.toByteArray());
            try {
                bos.close();
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
            return true;
        }
        if (this.index > 0) {
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(4);
            nf.setGroupingUsed(false);
            int i = this.name.lastIndexOf(46);
            filename = i == -1 || i == this.name.length() - 1 ? filename + nf.format(this.index++) : this.name.substring(0, i) + nf.format(this.index++) + this.name.substring(i);
        }
        try {
            if (this.format == 1 && this.premultiply) {
                img = new ComplexImage(ImageSaver.premultiplyTransparency(img.getImage()));
            }
            return ImageSaver.saveImage(img, new File(this.directory, filename), this.format, (int)this.quality);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new BStandardDialog("", Translate.text("errorSavingFile", ex.getMessage()), BStandardDialog.ERROR).showMessageDialog(this.parent);
            return false;
        }
    }

    public static boolean saveImage(Image im, File f, int format, int quality) throws IOException, InterruptedException {
        return ImageSaver.saveImage(new ComplexImage(im), f, format, quality);
    }

    public static boolean saveImage(ComplexImage img, File f, int format, int quality) throws IOException, InterruptedException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));
        Image im = img.getImage();
        if (format == 0) {
            im = ImageSaver.premultiplyTransparency(im);
            JpegEncoder jpg = new JpegEncoder(im, quality, bos);
            jpg.Compress();
            bos.close();
            return true;
        }
        if (format == 1) {
            DataOutputStream dos = new DataOutputStream(bos);
            TIFFEncoder tiff = new TIFFEncoder(im);
            tiff.writeImage(dos);
            dos.close();
            return true;
        }
        if (format == 2) {
            ImageIO.write((RenderedImage)ImageSaver.getBufferedImage(im), "png", bos);
            bos.close();
            return true;
        }
        if (format == 3) {
            im = ImageSaver.premultiplyTransparency(im);
            DataOutputStream dos = new DataOutputStream(bos);
            BMPEncoder bmp = new BMPEncoder(im);
            bmp.writeImage(dos);
            dos.close();
            return true;
        }
        if (format == 4) {
            HDREncoder.writeImage(img, bos);
            bos.close();
            return true;
        }
        bos.close();
        return false;
    }

    public void lastMovieImage() {
        if (this.movie != null) {
            this.movie.signalDone();
            this.movie = null;
        }
    }

    private static Image premultiplyTransparency(Image im) {
        int i;
        int[] data;
        try {
            PixelGrabber pg = new PixelGrabber(im, 0, 0, -1, -1, true);
            pg.grabPixels();
            data = (int[])pg.getPixels();
        }
        catch (InterruptedException ex) {
            return im;
        }
        for (i = 0; i < data.length && (data[i] & 0xFF000000) == -16777216; ++i) {
        }
        if (i == data.length) {
            return im;
        }
        for (i = 0; i < data.length; ++i) {
            int alpha = data[i] >> 24 & 0xFF;
            int red = data[i] >> 16 & 0xFF;
            int green = data[i] >> 8 & 0xFF;
            int blue = data[i] & 0xFF;
            red = red * (alpha + 1) >> 8;
            green = green * (alpha + 1) >> 8;
            blue = blue * (alpha + 1) >> 8;
            data[i] = (alpha << 24) + (red << 16) + (green << 8) + blue;
        }
        MemoryImageSource source = new MemoryImageSource(im.getWidth(null), im.getHeight(null), data, 0, im.getWidth(null));
        return Toolkit.getDefaultToolkit().createImage(source);
    }

    private static BufferedImage getBufferedImage(Image im) {
        if (im instanceof BufferedImage) {
            return (BufferedImage)im;
        }
        BufferedImage bi = new BufferedImage(im.getWidth(null), im.getHeight(null), 2);
        Graphics g = bi.getGraphics();
        g.drawImage(im, 0, 0, null);
        g.dispose();
        return bi;
    }
}

