/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.image.ComplexImage;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;

public class ImageAverager {
    int width;
    int height;
    int num;
    float[] red;
    float[] green;
    float[] blue;
    float[] alpha;

    public ImageAverager(int width, int height) {
        int size = width * height;
        this.width = width;
        this.height = height;
        this.red = new float[size];
        this.green = new float[size];
        this.blue = new float[size];
        this.alpha = new float[size];
    }

    public void addImage(Image im) {
        this.addImage(new ComplexImage(im));
    }

    public void addImage(ComplexImage img) {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int index;
                int n = index = i + j * this.width;
                this.red[n] = this.red[n] + img.getPixelComponent(i, j, 2);
                int n2 = index;
                this.green[n2] = this.green[n2] + img.getPixelComponent(i, j, 1);
                int n3 = index;
                this.blue[n3] = this.blue[n3] + img.getPixelComponent(i, j, 0);
                int n4 = index;
                this.alpha[n4] = this.alpha[n4] + img.getPixelComponent(i, j, 3);
            }
        }
        ++this.num;
    }

    public ComplexImage getAverageImage() {
        int[] data = new int[this.red.length];
        float scale = 1.0f / (float)this.num;
        for (int i = 0; i < data.length; ++i) {
            int n = i;
            this.red[n] = this.red[n] * scale;
            int n2 = i;
            this.green[n2] = this.green[n2] * scale;
            int n3 = i;
            this.blue[n3] = this.blue[n3] * scale;
            int n4 = i;
            this.alpha[n4] = this.alpha[n4] * scale;
            int a = (int)(this.alpha[i] * 255.0f);
            int r = (int)(this.red[i] * 255.0f);
            int g = (int)(this.green[i] * 255.0f);
            int b = (int)(this.blue[i] * 255.0f);
            if (a > 255) {
                a = 255;
            }
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            data[i] = (a << 24) + (r << 16) + (g << 8) + b;
        }
        MemoryImageSource source = new MemoryImageSource(this.width, this.height, data, 0, this.width);
        ComplexImage img = new ComplexImage(Toolkit.getDefaultToolkit().createImage(source));
        img.setComponentValues(2, this.red);
        img.setComponentValues(1, this.green);
        img.setComponentValues(0, this.blue);
        img.setComponentValues(3, this.alpha);
        return img;
    }

    public void clear() {
        this.num = 0;
        for (int i = 0; i < this.red.length; ++i) {
            this.blue[i] = 0.0f;
            this.green[i] = 0.0f;
            this.red[i] = 0.0f;
            this.alpha[i] = 0.0f;
        }
    }
}

