/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.image;

import artofillusion.image.HDRImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class HDRDecoder {
    public static HDRImage createImage(File file) throws IOException {
        int xres;
        int yres;
        String s;
        byte[] signature = "#?RADIANCE".getBytes("ISO-8859-1");
        byte[] fileSignature = new byte[signature.length];
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        in.mark(signature.length);
        in.read(fileSignature, 0, signature.length);
        for (int i = 0; i < signature.length; ++i) {
            if (signature[i] == fileSignature[i]) continue;
            in.close();
            throw new IOException("Not an .hdr file");
        }
        in.reset();
        boolean xyze = false;
        while ((s = HDRDecoder.readLine(in)).length() > 0) {
            if (!s.startsWith("FORMAT")) continue;
            xyze = s.indexOf("xyze") > -1;
        }
        String resolution = HDRDecoder.readLine(in);
        StringTokenizer st = new StringTokenizer(resolution);
        String[] res = new String[4];
        for (int i = 0; i < 4; ++i) {
            if (!st.hasMoreTokens()) {
                in.close();
                throw new IOException("Error parsing image file.");
            }
            res[i] = st.nextToken();
        }
        boolean flipY = res[0].startsWith("+");
        boolean flipX = res[2].startsWith("-");
        try {
            yres = Integer.parseInt(res[1]);
            xres = Integer.parseInt(res[3]);
        }
        catch (NumberFormatException ex) {
            in.close();
            throw new IOException("Error parsing image file.");
        }
        byte[][] map = new byte[4][xres * yres];
        byte[] buf = new byte[4];
        for (int row = 0; row < yres; ++row) {
            int col;
            int step;
            int start = flipY ? (yres - row - 1) * xres : row * xres;
            if (flipX) {
                step = -1;
                start += xres - 1;
            } else {
                step = 1;
            }
            in.readFully(buf);
            if (buf[0] == 2 && buf[1] == 2 && buf[2] >= 0) {
                for (int component = 0; component < 4; ++component) {
                    int count;
                    int pos = start;
                    for (col = 0; col < xres; col += count) {
                        count = in.read();
                        if (count <= 128) {
                            for (int i = 0; i < count; ++i) {
                                map[component][pos] = (byte)in.read();
                                pos += step;
                            }
                            continue;
                        }
                        byte repeat = (byte)in.read();
                        count -= 128;
                        for (int i = 0; i < count; ++i) {
                            map[component][pos] = repeat;
                            pos += step;
                        }
                    }
                }
                continue;
            }
            int pos = start;
            for (col = 0; col < xres; ++col) {
                if (col > 0) {
                    in.readFully(buf);
                }
                if (buf[0] == 1 && buf[1] == 1 && buf[2] == 1) {
                    int count = buf[3] & 0xFF;
                    byte r = map[0][pos - step];
                    byte g = map[1][pos - step];
                    byte b = map[2][pos - step];
                    byte e = map[3][pos - step];
                    for (int i = 0; i < count; ++i) {
                        map[0][pos] = r;
                        map[1][pos] = g;
                        map[2][pos] = b;
                        map[3][pos] = e;
                        pos += step;
                    }
                    col += count - 1;
                    continue;
                }
                map[0][pos] = buf[0];
                map[1][pos] = buf[1];
                map[2][pos] = buf[2];
                map[3][pos] = buf[3];
                pos += step;
            }
        }
        in.close();
        if (xyze) {
            for (int i = 0; i < map[0].length; ++i) {
                int x = map[0][i] & 0xFF;
                int y = map[1][i] & 0xFF;
                int z = map[2][i] & 0xFF;
                map[0][i] = (byte)(3.24 * (double)x - 1.54 * (double)y - 0.5 * (double)z);
                map[1][i] = (byte)(-0.97 * (double)x + 1.88 * (double)y + 0.42 * (double)z);
                map[2][i] = (byte)(0.06 * (double)x - 0.2 * (double)y + 1.06 * (double)z);
            }
        }
        return new HDRImage(map[0], map[1], map[2], map[3], xres, yres);
    }

    private static String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while ((c = in.read()) > -1 && c != 10) {
            buf.append((char)c);
        }
        return buf.toString();
    }
}

