/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.datahandling;

import artofillusion.datahandling.AbstractInplaceListOperation;
import java.util.List;
import java.util.ListIterator;

public class DeleteMarkedItemsListOp
extends AbstractInplaceListOperation {
    boolean[] markedItems;

    public DeleteMarkedItemsListOp(boolean[] markedItems) {
        this.markedItems = markedItems;
    }

    public void applyInplace(List data) {
        if (data.size() != this.markedItems.length) {
            throw new ArrayIndexOutOfBoundsException("Length mismatch");
        }
        ListIterator iter = data.listIterator();
        for (int i = 0; i < this.markedItems.length; ++i) {
            iter.next();
            if (!this.markedItems[i]) continue;
            iter.remove();
        }
    }

    public int[] getMappingNewToOld() {
        int i;
        int newlen = 0;
        for (i = 0; i < this.markedItems.length; ++i) {
            if (this.markedItems[i]) continue;
            ++newlen;
        }
        int counter = 0;
        int[] result = new int[newlen];
        for (i = 0; i < this.markedItems.length; ++i) {
            if (this.markedItems[i]) continue;
            result[counter] = i;
            ++counter;
        }
        return result;
    }

    public int[] getMappingOldToNew() {
        int counter = 0;
        int[] result = new int[this.markedItems.length];
        for (int i = 0; i < this.markedItems.length; ++i) {
            result[i] = !this.markedItems[i] ? counter++ : -1;
        }
        return result;
    }
}

