/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.MeshEditorWindow;
import artofillusion.MeshViewer;
import artofillusion.SplineMeshViewer;
import artofillusion.TriMeshViewer;
import artofillusion.UndoRecord;
import artofillusion.animation.Actor;
import artofillusion.animation.ActorEditorWindow;
import artofillusion.animation.Gesture;
import artofillusion.animation.Joint;
import artofillusion.animation.Skeleton;
import artofillusion.animation.SkeletonTool;
import artofillusion.animation.Smoothness;
import artofillusion.animation.Timecourse;
import artofillusion.animation.distortion.SkeletonShapeKeyframe;
import artofillusion.animation.distortion.SkeletonShapeTrack;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.ObjectWrapper;
import artofillusion.object.SplineMesh;
import artofillusion.object.TriangleMesh;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.EditingTool;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.MenuDescription;
import artofillusion.ui.MenuStructure;
import artofillusion.ui.ToolPalette;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.CommandEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BLabel;
import buoy.widget.BMenu;
import buoy.widget.BMenuItem;
import buoy.widget.BorderContainer;
import buoy.widget.MenuWidget;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;

public class SkeletonShapeEditorWindow
extends MeshEditorWindow
implements EditingWindow {
    private SkeletonShapeTrack track;
    private SkeletonShapeKeyframe keyframe;
    private int keyIndex;
    private double keyTime;
    private Smoothness keySmoothness;
    private BMenu editMenu;
    private BMenu skeletonMenu;
    private BMenuItem[] skeletonMenuItem;
    private BMenuItem undoItem;
    private BMenuItem redoItem;
    private BMenuItem templateItem;
    private BMenuItem[] displayItem;
    private BMenuItem[] coordsItem;
    private BMenuItem axesItem;
    private Runnable onClose;

    public SkeletonShapeEditorWindow(EditingWindow parent, String title, SkeletonShapeTrack track, int keyIndex, Runnable onClose) {
        super(parent, title, new ObjectInfo((Object3D)((Object)SkeletonShapeEditorWindow.getEditMesh(((ObjectInfo)track.getParent()).object)), new CoordinateSystem(), ""), onClose);
        this.track = track;
        this.keyIndex = keyIndex;
        this.onClose = onClose;
        Timecourse tc = track.getTimecourse();
        this.keyframe = (SkeletonShapeKeyframe)tc.getValues()[keyIndex];
        this.keySmoothness = tc.getSmoothness()[keyIndex].duplicate();
        this.keyTime = tc.getTimes()[keyIndex];
        ObjectInfo info = ((ObjectInfo)track.getParent()).duplicate(this.oldObject.duplicate());
        MenuStructure ms = new MenuStructure();
        ms.loadStructure("SkeletonShape", false);
        this.menubar = ms.createMenuBar(this);
        this.setMenuBar(this.menubar);
        this.menuitemsCache = null;
        Dimension d1 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d2 = new Dimension(d1.width * 3 / 4, d1.height * 3 / 4);
        this.setBounds(new Rectangle((d1.width - d2.width) / 2, (d1.height - d2.height) / 2, d2.width, d2.height));
        this.tools.requestFocus();
        this.updateMenus();
        info.object.getSkeleton().copy(this.keyframe.getSkeleton());
        this.adjustMeshForSkeleton();
    }

    private static Mesh getEditMesh(Object3D object) {
        while (object instanceof ObjectWrapper) {
            object = ((ObjectWrapper)object).getWrappedObject();
        }
        if (object instanceof SplineMesh || object instanceof TriangleMesh) {
            return (Mesh)((Object)object);
        }
        return object.convertToTriangleMesh(Double.MAX_VALUE);
    }

    public void setTool(EditingTool tool) {
        for (int i = 0; i < this.theView.length; ++i) {
            this.theView[i].setTool(tool);
        }
        this.currentTool = tool;
    }

    protected void updateMenuItem(MenuWidget item) {
        String itemname = ((Widget)((Object)item)).getName();
        BMenuItem mnitem = null;
        if (!(item instanceof BMenuItem)) {
            return;
        }
        mnitem = (BMenuItem)item;
        if ("editBone".equals(itemname)) {
            Skeleton s = this.keyframe.getSkeleton();
            Joint selJoint = s.getJoint(this.getCurrentView().getSelectedJoint());
            mnitem.setEnabled(selJoint != null);
        } else {
            super.updateMenuItem(item);
        }
    }

    public void actionPerformed(CommandEvent e) {
        String command = e.getActionCommand();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.handleMenuAction(command)) {
            if ("properties".equals(command)) {
                this.editProperties();
            } else if ("editBone".equals(command)) {
                this.editJointCommand();
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public MenuWidget createMenuItem(MenuDescription menudesc) {
        MenuWidget w = super.createMenuItem(menudesc);
        if (w != null && "createPoseFromGestures".equals(((Widget)((Object)w)).getName())) {
            Object3D obj = ((ObjectInfo)this.track.getParent()).object;
            ((BMenuItem)w).setEnabled(Actor.getActor(obj) != null);
        }
        return w;
    }

    public void doOk() {
        this.parentWindow.setUndoRecord(new UndoRecord(this.parentWindow, false, 12, new Object[]{this.track, this.track.duplicate(this.track.getParent())}));
        this.keyframe.getSkeleton().copy(this.getCurrentView().getObject().getSkeleton());
        this.track.moveKeyframe(this.keyIndex, this.keyTime);
        this.track.getTimecourse().getSmoothness()[this.keyIndex] = this.keySmoothness;
        this.oldObject = null;
        this.dispose();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public void doCancel() {
        this.oldObject = null;
        this.dispose();
    }

    private void adjustMeshForSkeleton() {
        Object3D obj = ((ObjectInfo)this.track.getParent()).object;
        Actor actor = Actor.getActor(obj);
        Mesh mesh = (Mesh)((Object)this.getCurrentView().getObject().object);
        if (this.track.getUseGestures() && actor != null) {
            actor.shapeMeshFromGestures((Object3D)((Object)mesh));
        } else {
            Skeleton.adjustMesh((Mesh)((Object)this.oldObject), mesh);
        }
    }

    public void resetToDefaultPoseCommand() {
        Object3D obj = ((ObjectInfo)this.track.getParent()).object;
        Actor actor = Actor.getActor(obj);
        Skeleton defaultSkeleton = actor != null ? actor.getGesture(0).getSkeleton() : obj.getSkeleton();
        Object3D editObj = this.getCurrentView().getObject().object;
        this.setUndoRecord(new UndoRecord(this, false, 0, new Object[]{editObj, editObj.duplicate()}));
        editObj.getSkeleton().copy(defaultSkeleton);
        this.adjustMeshForSkeleton();
        this.getCurrentView().objectChanged();
        this.getCurrentView().updateImage();
        this.getCurrentView().repaint();
    }

    public void createPoseFromGesturesCommand() {
        ObjectInfo info = (ObjectInfo)this.track.getParent();
        final Actor actor = Actor.getActor(info.object);
        final Actor.ActorKeyframe key = new Actor.ActorKeyframe();
        new ActorEditorWindow(this, info, actor, key, new Runnable(){

            public void run() {
                Skeleton newSkeleton = ((Gesture)key.createObjectKeyframe(actor)).getSkeleton();
                Object3D editObj = SkeletonShapeEditorWindow.this.getCurrentView().getObject().object;
                SkeletonShapeEditorWindow.this.setUndoRecord(new UndoRecord(SkeletonShapeEditorWindow.this, false, 0, new Object[]{editObj, editObj.duplicate()}));
                editObj.getSkeleton().copy(newSkeleton);
                SkeletonShapeEditorWindow.this.adjustMeshForSkeleton();
                SkeletonShapeEditorWindow.this.getCurrentView().objectChanged();
                SkeletonShapeEditorWindow.this.getCurrentView().updateImage();
                SkeletonShapeEditorWindow.this.getCurrentView().repaint();
            }
        });
    }

    protected void editProperties() {
        Timecourse tc = this.track.getTimecourse();
        ValueField timeField = new ValueField(this.keyTime, 0, 5);
        ValueSlider s1Slider = new ValueSlider(0.0, 1.0, 100, this.keySmoothness.getLeftSmoothness());
        final ValueSlider s2Slider = new ValueSlider(0.0, 1.0, 100, this.keySmoothness.getRightSmoothness());
        final BCheckBox sameBox = new BCheckBox(Translate.text("separateSmoothness"), !this.keySmoothness.isForceSame());
        sameBox.addEventLink(ValueChangedEvent.class, new Object(){

            void processEvent() {
                s2Slider.setEnabled(sameBox.getState());
            }
        });
        s2Slider.setEnabled(sameBox.getState());
        ComponentsDialog dlg = new ComponentsDialog(this, Translate.text("editKeyframe"), new Widget[]{timeField, sameBox, new BLabel(Translate.text("Smoothness") + ':'), s1Slider, s2Slider}, new String[]{Translate.text("Time"), null, null, "(" + Translate.text("left") + ")", "(" + Translate.text("right") + ")"});
        if (!dlg.clickedOk()) {
            return;
        }
        if (sameBox.getState()) {
            this.keySmoothness.setSmoothness(s1Slider.getValue(), s2Slider.getValue());
        } else {
            this.keySmoothness.setSmoothness(s1Slider.getValue());
        }
        this.keyTime = timeField.getValue();
    }

    public void adjustDeltas(Vec3[] delta) {
    }

    public MeshViewer createMeshViewer(ObjectInfo obj, RowContainer p) {
        if (this.oldObject instanceof SplineMesh) {
            return new SplineMeshViewer(obj, p);
        }
        return new TriMeshViewer(obj, p);
    }

    public void initBaseSelectionHolder(ObjectInfo obj) {
    }

    public void initWindowMenus(ObjectInfo obj) {
    }

    public BorderContainer createToolbarPanel() {
        BorderContainer p4 = new BorderContainer();
        this.tools = new ToolPalette(1, 3);
        p4.add(this.tools, BorderContainer.NORTH);
        this.defaultTool = new SkeletonTool(this, false){

            protected void adjustMesh(Mesh newMesh) {
                SkeletonShapeEditorWindow.this.adjustMeshForSkeleton();
            }
        };
        this.tools.addTool(this.defaultTool);
        this.tools.addTool(this.getMetaTool());
        this.tools.addTool(this.getAltTool());
        this.tools.selectTool(this.defaultTool);
        return p4;
    }

    protected MeshEditorWindow createNewViewNewSelection() {
        return null;
    }
}

