/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation.distortion;

import artofillusion.animation.distortion.Distortion;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;

public class ScaleDistortion
implements Distortion {
    private double xscale;
    private double yscale;
    private double zscale;
    private Mat4 preTransform;
    private Mat4 postTransform;
    private Distortion previous;

    public ScaleDistortion(double xscale, double yscale, double zscale, Mat4 preTransform, Mat4 postTransform) {
        this.xscale = xscale;
        this.yscale = yscale;
        this.zscale = zscale;
        this.preTransform = preTransform;
        this.postTransform = postTransform;
    }

    public void setPreviousDistortion(Distortion previous) {
        this.previous = previous;
    }

    public boolean isIdenticalTo(Distortion d) {
        if (!(d instanceof ScaleDistortion)) {
            return false;
        }
        ScaleDistortion s = (ScaleDistortion)d;
        if (this.previous != null && !this.previous.isIdenticalTo(s.previous)) {
            return false;
        }
        if (this.previous == null && s.previous != null) {
            return false;
        }
        if (this.xscale != s.xscale || this.yscale != s.yscale || this.zscale != s.zscale) {
            return false;
        }
        if (this.preTransform == s.preTransform && this.postTransform == s.postTransform) {
            return true;
        }
        return this.preTransform != null && this.preTransform.equals(s.preTransform) && this.postTransform != null && this.postTransform.equals(s.postTransform);
    }

    public Distortion duplicate() {
        ScaleDistortion d = new ScaleDistortion(this.xscale, this.yscale, this.zscale, this.preTransform, this.postTransform);
        if (this.previous != null) {
            d.previous = this.previous.duplicate();
        }
        return d;
    }

    public Mesh transform(Mesh obj) {
        if (this.previous != null) {
            obj = this.previous.transform(obj);
        }
        Mesh newmesh = (Mesh)((Object)obj.duplicate());
        MeshVertex[] vert = newmesh.getVertices();
        Vec3[] newvert = new Vec3[vert.length];
        for (int i = 0; i < newvert.length; ++i) {
            newvert[i] = vert[i].r;
            if (this.preTransform != null) {
                this.preTransform.transform(newvert[i]);
            }
            newvert[i].set(newvert[i].x * this.xscale, newvert[i].y * this.yscale, newvert[i].z * this.zscale);
            if (this.postTransform == null) continue;
            this.postTransform.transform(newvert[i]);
        }
        newmesh.setVertexPositions(newvert);
        return newmesh;
    }
}

