/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Keyframe;
import artofillusion.animation.Smoothness;

public class Timecourse {
    double[] time;
    Smoothness[] smoothness;
    Keyframe[] value;
    public static final int DISCONTINUOUS = 0;
    public static final int LINEAR = 1;
    public static final int INTERPOLATING = 2;
    public static final int APPROXIMATING = 3;

    public Timecourse(Keyframe[] value, double[] time, Smoothness[] smoothness) {
        this.value = value;
        this.time = time;
        this.smoothness = smoothness;
    }

    public void setTimepoints(Keyframe[] value, double[] time, Smoothness[] smoothness) {
        this.value = value;
        this.time = time;
        this.smoothness = smoothness;
    }

    public int addTimepoint(Keyframe v, double t, Smoothness s) {
        int i;
        for (int i2 = 0; i2 < this.time.length; ++i2) {
            if (!(Math.abs(this.time[i2] - t) < 1.0E-10)) continue;
            this.value[i2] = v;
            this.time[i2] = t;
            this.smoothness[i2] = s;
            return i2;
        }
        Keyframe[] newv = new Keyframe[this.value.length + 1];
        double[] newt = new double[this.time.length + 1];
        Smoothness[] news = new Smoothness[this.smoothness.length + 1];
        for (i = 0; i < this.time.length && this.time[i] < t; ++i) {
        }
        for (int j = 0; j < newv.length; ++j) {
            if (j < i) {
                newv[j] = this.value[j];
                newt[j] = this.time[j];
                news[j] = this.smoothness[j];
                continue;
            }
            if (j == i) {
                newv[j] = v;
                newt[j] = t;
                news[j] = s;
                continue;
            }
            newv[j] = this.value[j - 1];
            newt[j] = this.time[j - 1];
            news[j] = this.smoothness[j - 1];
        }
        this.value = newv;
        this.time = newt;
        this.smoothness = news;
        return i;
    }

    public void removeTimepoint(double t) {
        int i;
        for (i = 0; i < this.time.length && this.time[i] != t; ++i) {
        }
        if (i < this.time.length) {
            this.removeTimepoint(i);
        }
    }

    public void removeTimepoint(int which) {
        Keyframe[] newv = new Keyframe[this.value.length - 1];
        double[] newt = new double[this.time.length - 1];
        Smoothness[] news = new Smoothness[this.smoothness.length - 1];
        for (int j = 0; j < newv.length; ++j) {
            if (j < which) {
                newv[j] = this.value[j];
                newt[j] = this.time[j];
                news[j] = this.smoothness[j];
                continue;
            }
            newv[j] = this.value[j + 1];
            newt[j] = this.time[j + 1];
            news[j] = this.smoothness[j + 1];
        }
        this.value = newv;
        this.time = newt;
        this.smoothness = news;
    }

    public void removeAllTimepoints() {
        this.value = new Keyframe[0];
        this.time = new double[0];
        this.smoothness = new Smoothness[0];
    }

    public int moveTimepoint(int which, double t) {
        int newpos;
        for (newpos = 0; newpos < this.time.length && this.time[newpos] < t; ++newpos) {
        }
        Keyframe tempv = this.value[which];
        Smoothness temps = this.smoothness[which];
        if (newpos > which) {
            --newpos;
            for (int i = which; i < newpos; ++i) {
                this.value[i] = this.value[i + 1];
                this.time[i] = this.time[i + 1];
                this.smoothness[i] = this.smoothness[i + 1];
            }
        } else {
            for (int i = which; i > newpos; --i) {
                this.value[i] = this.value[i - 1];
                this.time[i] = this.time[i - 1];
                this.smoothness[i] = this.smoothness[i - 1];
            }
        }
        this.value[newpos] = tempv;
        this.time[newpos] = t;
        this.smoothness[newpos] = temps;
        return newpos;
    }

    public double[] getTimes() {
        return this.time;
    }

    public Keyframe[] getValues() {
        return this.value;
    }

    public Smoothness[] getSmoothness() {
        return this.smoothness;
    }

    public Timecourse duplicate(Object owner) {
        double[] newt = new double[this.time.length];
        Smoothness[] news = new Smoothness[this.smoothness.length];
        Keyframe[] newv = new Keyframe[this.value.length];
        for (int i = 0; i < newt.length; ++i) {
            newt[i] = this.time[i];
            news[i] = this.smoothness[i].duplicate();
            newv[i] = this.value[i].duplicate(owner);
        }
        return new Timecourse(newv, newt, news);
    }

    public Timecourse subdivide(int method) {
        int i;
        if (this.time.length < 2) {
            return this;
        }
        double[] t = new double[this.time.length * 2 - 1];
        Keyframe[] v = new Keyframe[this.value.length * 2 - 1];
        Smoothness[] s = new Smoothness[this.smoothness.length * 2 - 1];
        if (method == 0) {
            for (i = 0; i < this.value.length; ++i) {
                v[i * 2] = this.value[i];
                t[i * 2] = this.time[i];
            }
            for (i = 0; i < this.value.length - 1; ++i) {
                v[i * 2 + 1] = this.value[i].blend(this.value[i], 1.0, 0.0);
                t[i * 2 + 1] = (this.time[i] + this.time[i + 1]) * 0.5;
            }
        } else if (method == 1 || this.time.length < 3) {
            for (i = 0; i < this.value.length; ++i) {
                v[i * 2] = this.value[i];
                t[i * 2] = this.time[i];
            }
            for (i = 0; i < this.value.length - 1; ++i) {
                v[i * 2 + 1] = this.value[i].blend(this.value[i + 1], 0.5, 0.5);
                t[i * 2 + 1] = (this.time[i] + this.time[i + 1]) * 0.5;
            }
        } else if (method == 2) {
            v[0] = this.value[0];
            t[0] = this.time[0];
            v[1] = Timecourse.calcInterpPoint(this.value, this.smoothness, 0, 0, 1, 2);
            t[1] = Timecourse.calcInterpTime(this.time, this.smoothness, 0, 0, 1, 2);
            int j = 1;
            for (i = 2; i < v.length - 2; ++i) {
                if ((i & 1) == 0) {
                    v[i] = this.value[j];
                    t[i] = this.time[j];
                    continue;
                }
                v[i] = Timecourse.calcInterpPoint(this.value, this.smoothness, j - 1, j, j + 1, j + 2);
                t[i] = Timecourse.calcInterpTime(this.time, this.smoothness, j - 1, j, j + 1, j + 2);
                ++j;
            }
            v[i] = Timecourse.calcInterpPoint(this.value, this.smoothness, j - 1, j, j + 1, j + 1);
            t[i] = Timecourse.calcInterpTime(this.time, this.smoothness, j - 1, j, j + 1, j + 1);
            v[i + 1] = this.value[j + 1];
            t[i + 1] = this.time[j + 1];
        } else {
            v[0] = this.value[0];
            t[0] = this.time[0];
            for (i = 1; i < this.value.length - 1; ++i) {
                v[i * 2 - 1] = this.value[i].blend(this.value[i - 1], 0.5, 0.5);
                t[i * 2 - 1] = (this.time[i] + this.time[i - 1]) * 0.5;
                v[i * 2] = Timecourse.calcApproxPoint(this.value, this.smoothness, i - 1, i, i + 1);
                t[i * 2] = Timecourse.calcApproxTime(this.time, this.smoothness, i - 1, i, i + 1);
            }
            v[i * 2 - 1] = this.value[i].blend(this.value[i - 1], 0.5, 0.5);
            t[i * 2 - 1] = (this.time[i] + this.time[i - 1]) * 0.5;
            v[i * 2] = this.value[i];
            t[i * 2] = this.time[i];
        }
        for (i = 0; i < this.smoothness.length - 1; ++i) {
            s[i * 2] = this.smoothness[i].getSmoother();
            s[i * 2 + 1] = new Smoothness();
        }
        s[i * 2] = this.smoothness[i].getSmoother();
        return new Timecourse(v, t, s);
    }

    private static Keyframe calcInterpPoint(Keyframe[] value, Smoothness[] smoothness, int i, int j, int k, int m) {
        double w1 = -0.0625 * smoothness[j].getRightSmoothness();
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * smoothness[k].getLeftSmoothness();
        double w3 = 0.5 - w4;
        return value[i].blend(value[j], value[k], value[m], w1, w2, w3, w4);
    }

    private static double calcInterpTime(double[] time, Smoothness[] smoothness, int i, int j, int k, int m) {
        double w1 = -0.0625 * smoothness[j].getRightSmoothness();
        double w2 = 0.5 - w1;
        double w4 = -0.0625 * smoothness[k].getLeftSmoothness();
        double w3 = 0.5 - w4;
        return w1 * time[i] + w2 * time[j] + w3 * time[k] + w4 * time[m];
    }

    private static Keyframe calcApproxPoint(Keyframe[] value, Smoothness[] smoothness, int i, int j, int k) {
        double w1 = 0.125 * smoothness[j].getRightSmoothness();
        double w3 = 0.125 * smoothness[j].getLeftSmoothness();
        double w2 = 1.0 - w1 - w3;
        return value[i].blend(value[j], value[k], w1, w2, w3);
    }

    private static double calcApproxTime(double[] time, Smoothness[] smoothness, int i, int j, int k) {
        double w1 = 0.125 * smoothness[j].getRightSmoothness();
        double w3 = 0.125 * smoothness[j].getLeftSmoothness();
        double w2 = 1.0 - w1 - w3;
        return w1 * time[i] + w2 * time[j] + w3 * time[k];
    }

    public Keyframe evaluate(double t, int method) {
        int i;
        int last = this.time.length - 1;
        if (this.time.length == 0) {
            return null;
        }
        if (t <= this.time[0]) {
            return this.value[0];
        }
        if (t >= this.time[this.time.length - 1]) {
            return this.value[this.time.length - 1];
        }
        if (method == 0) {
            int i2;
            for (i2 = 1; i2 < this.time.length && t > this.time[i2]; ++i2) {
            }
            return this.value[i2 - 1];
        }
        if (method == 1 || this.time.length == 2) {
            int i3;
            for (i3 = 1; i3 < this.time.length && t > this.time[i3]; ++i3) {
            }
            if (this.time[i3 - 1] == this.time[i3]) {
                return this.value[i3];
            }
            double fract = (t - this.time[i3 - 1]) / (this.time[i3] - this.time[i3 - 1]);
            return this.value[i3 - 1].blend(this.value[i3], 1.0 - fract, fract);
        }
        Keyframe[] v1 = new Keyframe[7];
        Keyframe[] v2 = new Keyframe[7];
        double[] t1 = new double[7];
        double[] t2 = new double[7];
        Smoothness[] s1 = new Smoothness[7];
        Smoothness[] s2 = new Smoothness[7];
        if (method == 2) {
            this.subdivideLocalInterp(t, this.value, this.time, this.smoothness, v1, t1, s1, method);
            this.subdivideLocalInterp(t, v1, t1, s1, v2, t2, s2, method);
            this.subdivideLocalInterp(t, v2, t2, s2, v1, t1, s1, method);
            this.subdivideLocalInterp(t, v1, t1, s1, v2, t2, s2, method);
        } else {
            this.subdivideLocalApprox(t, this.value, this.time, this.smoothness, v1, t1, s1, method);
            this.subdivideLocalApprox(t, v1, t1, s1, v2, t2, s2, method);
            this.subdivideLocalApprox(t, v2, t2, s2, v1, t1, s1, method);
            this.subdivideLocalApprox(t, v1, t1, s1, v2, t2, s2, method);
        }
        for (i = 1; i < t2.length && t > t2[i]; ++i) {
        }
        if (t2[i - 1] == t2[i]) {
            return v2[i];
        }
        double fract = (t - t2[i - 1]) / (t2[i] - t2[i - 1]);
        return v2[i - 1].blend(v2[i], 1.0 - fract, fract);
    }

    private void subdivideLocalInterp(double t, Keyframe[] v1, double[] t1, Smoothness[] s1, Keyframe[] v2, double[] t2, Smoothness[] s2, int method) {
        int ind4;
        int ind5;
        int ind6;
        int ind1;
        int ind2;
        int ind3;
        int i;
        int last = t1.length - 1;
        for (i = 1; i < t1.length && t > t1[i]; ++i) {
        }
        if (i == 1) {
            ind3 = 0;
            ind2 = 0;
            ind1 = 0;
        } else if (i == 2) {
            ind2 = 0;
            ind1 = 0;
            ind3 = 1;
        } else {
            ind1 = i - 3;
            ind2 = i - 2;
            ind3 = i - 1;
        }
        if (i == last) {
            ind5 = ind6 = last;
            ind4 = ind6;
        } else if (i == last - 1) {
            ind4 = last - 1;
            ind5 = ind6 = last;
        } else {
            ind4 = i;
            ind5 = i + 1;
            ind6 = i + 2;
        }
        v2[0] = v1[ind2];
        t2[0] = t1[ind2];
        s2[0] = s1[ind2].getSmoother();
        v2[1] = Timecourse.calcInterpPoint(v1, s1, ind1, ind2, ind3, ind4);
        t2[1] = Timecourse.calcInterpTime(t1, s1, ind1, ind2, ind3, ind4);
        s2[1] = new Smoothness();
        v2[2] = v1[ind3];
        t2[2] = t1[ind3];
        s2[2] = s1[ind3].getSmoother();
        v2[3] = Timecourse.calcInterpPoint(v1, s1, ind2, ind3, ind4, ind5);
        t2[3] = Timecourse.calcInterpTime(t1, s1, ind2, ind3, ind4, ind5);
        s2[3] = new Smoothness();
        v2[4] = v1[ind4];
        t2[4] = t1[ind4];
        s2[4] = s1[ind5].getSmoother();
        v2[5] = Timecourse.calcInterpPoint(v1, s1, ind3, ind4, ind5, ind6);
        t2[5] = Timecourse.calcInterpTime(t1, s1, ind3, ind4, ind5, ind6);
        s2[5] = new Smoothness();
        v2[6] = v1[ind5];
        t2[6] = t1[ind5];
        s2[6] = s1[ind5].getSmoother();
    }

    private void subdivideLocalApprox(double t, Keyframe[] v1, double[] t1, Smoothness[] s1, Keyframe[] v2, double[] t2, Smoothness[] s2, int method) {
        int ind4;
        int ind5;
        int ind6;
        int ind1;
        int ind2;
        int ind3;
        int i;
        int last = t1.length - 1;
        for (i = 1; i < t1.length && t > t1[i]; ++i) {
        }
        if (i == 1) {
            ind3 = 0;
            ind2 = 0;
            ind1 = 0;
        } else if (i == 2) {
            ind2 = 0;
            ind1 = 0;
            ind3 = 1;
        } else {
            ind1 = i - 3;
            ind2 = i - 2;
            ind3 = i - 1;
        }
        if (i == last) {
            ind5 = ind6 = last;
            ind4 = ind6;
        } else if (i == last - 1) {
            ind4 = last - 1;
            ind5 = ind6 = last;
        } else {
            ind4 = i;
            ind5 = i + 1;
            ind6 = i + 2;
        }
        v2[0] = Timecourse.calcApproxPoint(v1, s1, ind1, ind2, ind3);
        t2[0] = Timecourse.calcApproxTime(t1, s1, ind1, ind2, ind3);
        s2[0] = s1[ind2].getSmoother();
        v2[1] = v1[ind2].blend(v1[ind3], 0.5, 0.5);
        t2[1] = 0.5 * (t1[ind2] + t1[ind3]);
        s2[1] = new Smoothness();
        v2[2] = Timecourse.calcApproxPoint(v1, s1, ind2, ind3, ind4);
        t2[2] = Timecourse.calcApproxTime(t1, s1, ind2, ind3, ind4);
        s2[2] = s1[ind3].getSmoother();
        v2[3] = v1[ind3].blend(v1[ind4], 0.5, 0.5);
        t2[3] = 0.5 * (t1[ind3] + t1[ind4]);
        s2[3] = new Smoothness();
        v2[4] = Timecourse.calcApproxPoint(v1, s1, ind3, ind4, ind5);
        t2[4] = Timecourse.calcApproxTime(t1, s1, ind3, ind4, ind5);
        s2[4] = s1[ind4].getSmoother();
        v2[5] = v1[ind4].blend(v1[ind5], 0.5, 0.5);
        t2[5] = 0.5 * (t1[ind4] + t1[ind5]);
        s2[5] = new Smoothness();
        v2[6] = Timecourse.calcApproxPoint(v1, s1, ind4, ind5, ind6);
        t2[6] = Timecourse.calcApproxTime(t1, s1, ind4, ind5, ind6);
        s2[6] = s1[ind5].getSmoother();
    }
}

