/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.animation;

import artofillusion.animation.Marker;
import artofillusion.animation.Score;
import artofillusion.ui.ActionProcessor;
import buoy.event.MouseDraggedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.RepaintEvent;
import buoy.event.WidgetMouseEvent;
import buoy.widget.CustomWidget;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.NumberFormat;
import java.util.Vector;

public class TimeAxis
extends CustomWidget {
    double start;
    double scale;
    double origMarkerPos;
    Score theScore;
    Vector markers;
    int subdivisions;
    Marker draggingMarker;
    Point clickPos;
    ActionProcessor process;
    static final int TICK_HEIGHT = 7;
    static final int MARKER_SIZE = 5;
    private static final NumberFormat nf = NumberFormat.getNumberInstance();

    public TimeAxis(int subdivisions, double scale, Score sc) {
        this.subdivisions = subdivisions;
        this.scale = scale;
        this.theScore = sc;
        nf.setMinimumFractionDigits(1);
        nf.setMaximumFractionDigits(2);
        this.markers = new Vector();
        this.addEventLink(MousePressedEvent.class, (Object)this, "mousePressed");
        this.addEventLink(MouseReleasedEvent.class, (Object)this, "mouseReleased");
        this.addEventLink(MouseDraggedEvent.class, (Object)this, "mouseDragged");
        this.addEventLink(RepaintEvent.class, (Object)this, "paint");
    }

    public double getStartTime() {
        return this.start;
    }

    public void setStartTime(double time) {
        this.start = time;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double s) {
        this.scale = s;
    }

    public void setSubdivisions(int s) {
        this.subdivisions = s;
    }

    public void addMarker(Marker m) {
        this.markers.addElement(m);
    }

    public Dimension getPreferredSize() {
        Font f = this.getFont();
        if (f == null) {
            return new Dimension();
        }
        FontMetrics fm = this.getComponent().getFontMetrics(f);
        return new Dimension(1, fm.getMaxAscent() + fm.getMaxDescent() + 7);
    }

    private void paint(RepaintEvent ev) {
        int labelInterval;
        Graphics2D g = ev.getGraphics();
        FontMetrics fm = this.getComponent().getFontMetrics(this.getFont());
        Rectangle dim = this.getBounds();
        double inc = 1.0 / (double)this.subdivisions;
        int labelPos = fm.getMaxAscent();
        int tickPos = labelPos + fm.getMaxDescent();
        int i = 1;
        while (i < this.subdivisions && inc * this.scale < 2.0) {
            if (++i * (this.subdivisions / i) != this.subdivisions) continue;
            inc = (double)i / (double)this.subdivisions;
        }
        inc = (double)i / (double)this.subdivisions;
        int numLabels = this.subdivisions / i;
        if (numLabels == 0) {
            numLabels = 1;
        }
        boolean[] label = new boolean[numLabels];
        int labelWidth = fm.stringWidth("0000");
        if (numLabels > 1) {
            for (labelInterval = (int)Math.ceil((double)labelWidth / (this.scale * inc)); labelInterval < numLabels && numLabels / labelInterval * labelInterval != numLabels; ++labelInterval) {
            }
        }
        for (int j = 0; j < label.length; j += labelInterval) {
            label[j] = true;
        }
        double t = Math.ceil(this.start / inc) * inc;
        int x = (int)Math.round((t - this.start) * this.scale);
        int lastLabel = -labelWidth;
        i = (int)Math.round((t - Math.floor(t)) / inc);
        while (x < dim.width) {
            if (i == 0) {
                g.drawLine(x, tickPos, x, tickPos + 7);
            } else if (label[i]) {
                g.drawLine(x, tickPos + 1, x, tickPos + 7);
            } else {
                g.drawLine(x, tickPos + 2, x, tickPos + 7);
            }
            if (label[i] && x - lastLabel > labelWidth) {
                String s = nf.format((double)Math.round(t * (double)this.subdivisions) / (double)this.subdivisions);
                int w = fm.stringWidth(s);
                g.drawString(s, x - w / 2, labelPos);
                lastLabel = x;
            }
            i = (i + 1) % label.length;
            x = (int)Math.round(((t += inc) - this.start) * this.scale);
        }
        for (i = 0; i < this.markers.size(); ++i) {
            Marker m = (Marker)this.markers.elementAt(i);
            x = (int)Math.round(this.scale * (m.position - this.start));
            g.setColor(m.color);
            g.fillRect(x - 2, tickPos + 2, 5, 5);
        }
    }

    private void mousePressed(MousePressedEvent ev) {
        this.clickPos = ev.getPoint();
        this.draggingMarker = null;
        this.process = new ActionProcessor();
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker m = (Marker)this.markers.elementAt(i);
            int x = (int)(this.scale * (m.position - this.start));
            if (this.clickPos.x < x - 2 - 1 || this.clickPos.x > x + 2 + 1) continue;
            this.draggingMarker = m;
            this.origMarkerPos = m.position;
        }
        if (this.draggingMarker == null && this.markers.size() > 0) {
            this.draggingMarker = (Marker)this.markers.elementAt(0);
            this.origMarkerPos = (double)this.clickPos.x / this.scale + this.start;
            this.mouseDragged(ev);
        }
    }

    private void mouseDragged(WidgetMouseEvent ev) {
        final Point pos = ev.getPoint();
        if (this.draggingMarker == null) {
            return;
        }
        Runnable c = new Runnable(){

            public void run() {
                int width;
                if (pos.x < 0) {
                    pos.x = 0;
                }
                if (pos.x >= (width = TimeAxis.this.getBounds().width)) {
                    pos.x = width - 1;
                }
                double t = TimeAxis.this.draggingMarker.position;
                t = TimeAxis.this.origMarkerPos + (double)(pos.x - TimeAxis.this.clickPos.x) / TimeAxis.this.scale;
                TimeAxis.this.draggingMarker.position = t = (double)Math.round(t * (double)TimeAxis.this.subdivisions) / (double)TimeAxis.this.subdivisions;
                TimeAxis.this.theScore.markerMoved(TimeAxis.this.draggingMarker, true);
            }
        };
        this.process.addEvent(c);
    }

    private void mouseReleased(MouseReleasedEvent ev) {
        if (this.process != null) {
            this.process.stopProcessing();
        }
        this.process = null;
        if (this.draggingMarker != null) {
            this.theScore.markerMoved(this.draggingMarker, false);
        }
    }
}

